/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.crafting.RecipeRuneAltar;
import vazkii.botania.common.crafting.RecipeSerializerBase;
import vazkii.botania.common.helper.ItemNBTHelper;

public class HeadRecipe
extends RecipeRuneAltar {
    public HeadRecipe(ResourceLocation id, ItemStack output, int mana, Ingredient ... inputs) {
        super(id, output, mana, inputs);
    }

    @Override
    public boolean m_5818_(Container inv, @Nonnull Level world) {
        boolean matches = super.m_5818_(inv, world);
        if (matches) {
            ItemStack stack;
            for (int i = 0; i < inv.m_6643_() && !(stack = inv.m_8020_(i)).m_41619_(); ++i) {
                if (!stack.m_150930_(Items.f_42656_)) continue;
                String defaultName = new TranslatableComponent(Items.f_42656_.m_5524_()).getString();
                if (!stack.m_41786_().getString().equals(defaultName)) continue;
                return false;
            }
        }
        return matches;
    }

    @Override
    @Nonnull
    public ItemStack m_5874_(@Nonnull Container inv) {
        ItemStack stack = this.m_8043_().m_41777_();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack ingr = inv.m_8020_(i);
            if (!ingr.m_150930_(Items.f_42656_)) continue;
            ItemNBTHelper.setString(stack, "SkullOwner", ingr.m_41786_().getString());
            break;
        }
        return stack;
    }

    public static class Serializer
    extends RecipeSerializerBase<HeadRecipe> {
        @Nonnull
        public HeadRecipe fromJson(@Nonnull ResourceLocation id, @Nonnull JsonObject json) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            int mana = GsonHelper.m_13927_((JsonObject)json, (String)"mana");
            JsonArray ingrs = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
            for (JsonElement e : ingrs) {
                inputs.add(Ingredient.m_43917_((JsonElement)e));
            }
            return new HeadRecipe(id, output, mana, inputs.toArray(new Ingredient[0]));
        }

        public HeadRecipe fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buf) {
            Ingredient[] inputs = new Ingredient[buf.m_130242_()];
            for (int i = 0; i < inputs.length; ++i) {
                inputs[i] = Ingredient.m_43940_((FriendlyByteBuf)buf);
            }
            ItemStack output = buf.m_130267_();
            int mana = buf.m_130242_();
            return new HeadRecipe(id, output, mana, inputs);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buf, @Nonnull HeadRecipe recipe) {
            ModRecipeTypes.RUNE_SERIALIZER.m_6178_(buf, (Recipe)recipe);
        }
    }
}

