/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import com.google.common.base.Predicates;
import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.mana.spark.IManaSpark;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.SparkHelper;
import vazkii.botania.api.recipe.ITerraPlateRecipe;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.PacketBotaniaEffect;
import vazkii.botania.xplat.IXplatAbstractions;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.PatchouliAPI;

public class TileTerraPlate
extends TileMod
implements ISparkAttachable,
IManaReceiver {
    public static final Supplier<IMultiblock> MULTIBLOCK = Suppliers.memoize(() -> PatchouliAPI.get().makeMultiblock((String[][])new String[][]{{"___", "_P_", "___"}, {"RLR", "L0L", "RLR"}}, new Object[]{Character.valueOf('P'), ModBlocks.terraPlate, Character.valueOf('R'), "#botania:terra_plate_base", Character.valueOf('0'), "#botania:terra_plate_base", Character.valueOf('L'), IXplatAbstractions.INSTANCE.isFabric() ? "#c:lapis_blocks" : "#forge:storage_blocks/lapis"}));
    private static final String TAG_MANA = "mana";
    private int mana;

    public TileTerraPlate(BlockPos pos, BlockState state) {
        super(ModTiles.TERRA_PLATE, pos, state);
    }

    public static void serverTick(Level level, BlockPos worldPosition, BlockState state, TileTerraPlate self) {
        boolean removeMana = true;
        if (self.hasValidPlatform()) {
            List<ItemStack> items = self.getItems();
            SimpleContainer inv = self.getInventory();
            ITerraPlateRecipe recipe = self.getCurrentRecipe(inv);
            if (recipe != null) {
                removeMana = false;
                IManaSpark spark = self.getAttachedSpark();
                if (spark != null) {
                    SparkHelper.getSparksAround(level, (double)worldPosition.m_123341_() + 0.5, (double)worldPosition.m_123342_() + 0.5, (double)worldPosition.m_123343_() + 0.5, spark.getNetwork()).filter(otherSpark -> spark != otherSpark && otherSpark.getAttachedManaReceiver() instanceof IManaPool).forEach(os -> os.registerTransfer(spark));
                }
                if (self.mana > 0) {
                    VanillaPacketDispatcher.dispatchTEToNearbyPlayers(self);
                    int proportion = Float.floatToIntBits(self.getCompletion());
                    IXplatAbstractions.INSTANCE.sendToNear(level, worldPosition, new PacketBotaniaEffect(EffectType.TERRA_PLATE, worldPosition.m_123341_(), worldPosition.m_123342_(), worldPosition.m_123343_(), proportion));
                }
                if (self.mana >= recipe.getMana()) {
                    ItemStack result = recipe.m_5874_((Container)inv);
                    for (ItemStack item : items) {
                        item.m_41764_(0);
                    }
                    ItemEntity item = new ItemEntity(level, (double)worldPosition.m_123341_() + 0.5, (double)worldPosition.m_123342_() + 0.2, (double)worldPosition.m_123343_() + 0.5, result);
                    item.m_20256_(Vec3.f_82478_);
                    level.m_7967_((Entity)item);
                    level.m_6263_(null, item.m_20185_(), item.m_20186_(), item.m_20189_(), ModSounds.terrasteelCraft, SoundSource.BLOCKS, 1.0f, 1.0f);
                    self.mana = 0;
                    level.m_46717_(worldPosition, state.m_60734_());
                    VanillaPacketDispatcher.dispatchTEToNearbyPlayers(self);
                }
            }
        }
        if (removeMana) {
            self.receiveMana(-1000);
        }
    }

    private List<ItemStack> getItems() {
        List itemEntities = this.f_58857_.m_6443_(ItemEntity.class, new AABB(this.f_58858_, this.f_58858_.m_142082_(1, 1, 1)), EntitySelector.f_20402_);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ItemEntity entity : itemEntities) {
            if (entity.m_32055_().m_41619_()) continue;
            stacks.add(entity.m_32055_());
        }
        return stacks;
    }

    private SimpleContainer getInventory() {
        List<ItemStack> items = this.getItems();
        return new SimpleContainer(TileTerraPlate.flattenStacks(items));
    }

    private static ItemStack[] flattenStacks(List<ItemStack> items) {
        int i = 0;
        for (ItemStack item : items) {
            i += item.m_41613_();
        }
        if (i > 64) {
            return new ItemStack[0];
        }
        ItemStack[] stacks = new ItemStack[i];
        int j = 0;
        for (ItemStack item : items) {
            if (item.m_41613_() > 1) {
                ItemStack temp = item.m_41777_();
                temp.m_41764_(1);
                for (int count = 0; count < item.m_41613_(); ++count) {
                    stacks[j] = temp.m_41777_();
                    ++j;
                }
                continue;
            }
            stacks[j] = item;
            ++j;
        }
        return stacks;
    }

    @Nullable
    private ITerraPlateRecipe getCurrentRecipe(SimpleContainer items) {
        if (items.m_7983_()) {
            return null;
        }
        return this.f_58857_.m_7465_().m_44015_(ModRecipeTypes.TERRA_PLATE_TYPE, (Container)items, this.f_58857_).orElse(null);
    }

    private boolean isActive() {
        return this.getCurrentRecipe(this.getInventory()) != null;
    }

    private boolean hasValidPlatform() {
        return MULTIBLOCK.get().validate(this.f_58857_, this.m_58899_().m_7495_()) != null;
    }

    @Override
    public void writePacketNBT(CompoundTag cmp) {
        cmp.m_128405_(TAG_MANA, this.mana);
    }

    @Override
    public void readPacketNBT(CompoundTag cmp) {
        this.mana = cmp.m_128451_(TAG_MANA);
    }

    @Override
    public Level getManaReceiverLevel() {
        return this.m_58904_();
    }

    @Override
    public BlockPos getManaReceiverPos() {
        return this.m_58899_();
    }

    @Override
    public int getCurrentMana() {
        return this.mana;
    }

    @Override
    public boolean isFull() {
        ITerraPlateRecipe recipe = this.getCurrentRecipe(this.getInventory());
        return recipe == null || this.getCurrentMana() >= recipe.getMana();
    }

    @Override
    public void receiveMana(int mana) {
        this.mana = Math.max(0, this.mana + mana);
        this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
    }

    @Override
    public boolean canReceiveManaFromBursts() {
        return this.isActive();
    }

    @Override
    public boolean canAttachSpark(ItemStack stack) {
        return true;
    }

    @Override
    public IManaSpark getAttachedSpark() {
        List sparks = this.f_58857_.m_6443_(Entity.class, new AABB(this.f_58858_.m_7494_(), this.f_58858_.m_7494_().m_142082_(1, 1, 1)), (Predicate)Predicates.instanceOf(IManaSpark.class));
        if (sparks.size() == 1) {
            Entity e = (Entity)sparks.get(0);
            return (IManaSpark)e;
        }
        return null;
    }

    @Override
    public boolean areIncomingTranfersDone() {
        return !this.isActive();
    }

    @Override
    public int getAvailableSpaceForMana() {
        ITerraPlateRecipe recipe = this.getCurrentRecipe(this.getInventory());
        return recipe == null ? 0 : Math.max(0, recipe.getMana() - this.getCurrentMana());
    }

    public float getCompletion() {
        ITerraPlateRecipe recipe = this.getCurrentRecipe(this.getInventory());
        if (recipe == null) {
            return 0.0f;
        }
        return (float)this.getCurrentMana() / (float)recipe.getMana();
    }

    public int getComparatorLevel() {
        int val = (int)((double)this.getCompletion() * 15.0);
        if (this.getCurrentMana() > 0) {
            val = Math.max(val, 1);
        }
        return val;
    }
}

