/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import com.google.common.base.Predicates;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.mixin.AccessorGoalSelector;
import vazkii.botania.mixin.AccessorMob;

public class SubTileHeiseiDream
extends TileEntityFunctionalFlower {
    private static final int RANGE = 5;
    private static final int COST = 100;

    public SubTileHeiseiDream(BlockPos pos, BlockState state) {
        super(ModSubtiles.HEISEI_DREAM, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.m_58904_().f_46443_) {
            return;
        }
        List mobs = this.m_58904_().m_6443_(Entity.class, new AABB(this.getEffectivePos().m_142082_(-5, -5, -5), this.getEffectivePos().m_142082_(6, 6, 6)), (Predicate)Predicates.instanceOf(Enemy.class));
        if (mobs.size() > 1 && this.getMana() >= 100) {
            for (Enemy mob : mobs) {
                Mob entity;
                if (!(mob instanceof Mob) || !SubTileHeiseiDream.brainwashEntity(entity = (Mob)mob, mobs)) continue;
                this.addMana(-100);
                this.sync();
                break;
            }
        }
    }

    public static boolean brainwashEntity(Mob entity, List<Enemy> mobs) {
        LivingEntity target = entity.m_5448_();
        boolean did = false;
        if (!(target instanceof Enemy)) {
            Enemy newTarget;
            while ((newTarget = mobs.get(entity.f_19853_.f_46441_.nextInt(mobs.size()))) == entity) {
            }
            if (newTarget instanceof Mob) {
                Mob mob = (Mob)newTarget;
                entity.m_6710_(null);
                GoalSelector targetSelector = ((AccessorMob)entity).getTargetSelector();
                for (WrappedGoal entry : ((AccessorGoalSelector)targetSelector).getAvailableGoals()) {
                    if (!(entry.m_26015_() instanceof HurtByTargetGoal)) continue;
                    targetSelector.m_25363_(entry.m_26015_());
                    targetSelector.m_25352_(-1, entry.m_26015_());
                    break;
                }
                entity.m_6703_((LivingEntity)mob);
                did = true;
            }
        }
        return did;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 5);
    }

    @Override
    public int getColor() {
        return 16720285;
    }

    @Override
    public int getMaxMana() {
        return 1000;
    }
}

