/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.model;

import com.google.common.base.Preconditions;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.AtlasSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.botania.client.model.DelegatedModel;
import vazkii.botania.common.item.ItemManaGun;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.mixin.client.AccessorModelBakery;

public class GunModel
implements BakedModel {
    private static final ModelResourceLocation DESU = new ModelResourceLocation("botania:desu_gun", "inventory");
    private static final ModelResourceLocation DESU_CLIP = new ModelResourceLocation("botania:desu_gun_clip", "inventory");
    private final ModelBakery bakery;
    private final BakedModel originalModel;
    private final BakedModel originalModelClip;
    private final ItemOverrides itemHandler = new ItemOverrides(){

        @Nonnull
        public BakedModel m_173464_(BakedModel model, ItemStack stack, @Nullable ClientLevel worldIn, @Nullable LivingEntity entityIn, int seed) {
            boolean clip = ItemManaGun.hasClip(stack);
            if (ItemManaGun.isSugoiKawaiiDesuNe(stack)) {
                return Minecraft.m_91087_().m_91304_().m_119422_(clip ? DESU_CLIP : DESU);
            }
            ItemStack lens = ItemManaGun.getLens(stack);
            if (!lens.m_41619_()) {
                return GunModel.this.getModel(lens, clip);
            }
            return clip ? GunModel.this.originalModelClip : GunModel.this.originalModel;
        }
    };
    private final HashMap<Pair<Item, Boolean>, CompositeBakedModel> cache = new HashMap();

    public GunModel(ModelBakery bakery, BakedModel originalModel, BakedModel originalModelClip) {
        this.bakery = bakery;
        this.originalModel = (BakedModel)Preconditions.checkNotNull((Object)originalModel);
        this.originalModelClip = (BakedModel)Preconditions.checkNotNull((Object)originalModelClip);
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return this.itemHandler;
    }

    @Nonnull
    public List<BakedQuad> m_6840_(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand) {
        return this.originalModel.m_6840_(state, side, rand);
    }

    public boolean m_7541_() {
        return this.originalModel.m_7541_();
    }

    public boolean m_7539_() {
        return this.originalModel.m_7539_();
    }

    public boolean m_7521_() {
        return this.originalModel.m_7521_();
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return this.originalModel.m_6160_();
    }

    @Nonnull
    public ItemTransforms m_7442_() {
        return this.originalModel.m_7442_();
    }

    public boolean m_7547_() {
        return this.originalModel.m_7547_();
    }

    private CompositeBakedModel getModel(ItemStack lens, boolean clip) {
        return this.cache.computeIfAbsent((Pair<Item, Boolean>)Pair.of((Object)lens.m_41720_(), (Object)clip), p -> new CompositeBakedModel(this.bakery, lens, clip ? this.originalModelClip : this.originalModel));
    }

    private static class CompositeBakedModel
    extends DelegatedModel {
        private final List<BakedQuad> genQuads = new ArrayList<BakedQuad>();
        private final Map<Direction, List<BakedQuad>> faceQuads = new EnumMap<Direction, List<BakedQuad>>(Direction.class);

        /*
         * Unable to fully structure code
         */
        CompositeBakedModel(ModelBakery bakery, ItemStack lens, BakedModel gun) {
            super(gun);
            lensId = Registry.f_122827_.m_7981_((Object)lens.m_41720_());
            lensUnbaked = bakery.m_119341_((ResourceLocation)new ModelResourceLocation(lensId, "inventory"));
            transform = new ModelState(){

                public Transformation m_6189_() {
                    return new Transformation(new Vector3f(-0.4f, 0.2f, 0.0f), Vector3f.f_122225_.m_122270_(1.5707964f), new Vector3f(0.625f, 0.625f, 0.625f), null);
                }
            };
            name = ResourceLocationHelper.prefix("gun_with_" + lensId.toString().replace(':', '_'));
            textureGetter = (Function<Material, TextureAtlasSprite>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, m_117971_(net.minecraft.client.resources.model.Material ), (Lnet/minecraft/client/resources/model/Material;)Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;)((AtlasSet)((AccessorModelBakery)bakery).getSpriteAtlasManager());
            if (!(lensUnbaked instanceof BlockModel)) ** GOTO lbl-1000
            bm = (Direction[])lensUnbaked;
            if (((BlockModel)lensUnbaked).m_111490_() == ModelBakery.f_119232_) {
                lensBaked = new ItemModelGenerator().m_111670_(textureGetter, (BlockModel)bm).m_111449_(bakery, (BlockModel)bm, textureGetter, transform, name, false);
            } else lbl-1000:
            // 2 sources

            {
                lensBaked = lensUnbaked.m_7611_(bakery, textureGetter, transform, name);
            }
            for (Direction e : Direction.values()) {
                this.faceQuads.put(e, new ArrayList<E>());
            }
            rand = new Random(0L);
            this.genQuads.addAll(lensBaked.m_6840_(null, null, rand));
            for (Direction e : Direction.values()) {
                rand.setSeed(0L);
                this.faceQuads.get(e).addAll(lensBaked.m_6840_(null, e, rand));
            }
            rand.setSeed(0L);
            this.genQuads.addAll(gun.m_6840_(null, null, rand));
            for (Direction e : Direction.values()) {
                rand.setSeed(0L);
                this.faceQuads.get(e).addAll(gun.m_6840_(null, e, rand));
            }
        }

        @Override
        @Nonnull
        public List<BakedQuad> m_6840_(BlockState state, Direction face, @Nonnull Random rand) {
            return face == null ? this.genQuads : this.faceQuads.get(face);
        }
    }
}

