/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.fluids.FluidStack;
import vazkii.botania.api.recipe.IPureDaisyRecipe;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class PureDaisyRecipeCategory
implements IRecipeCategory<IPureDaisyRecipe> {
    public static final ResourceLocation UID = ResourceLocationHelper.prefix("pure_daisy");
    private final IDrawable background;
    private final Component localizedName;
    private final IDrawable overlay;
    private final IDrawable icon;

    public PureDaisyRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(96, 44);
        this.localizedName = new TranslatableComponent("botania.nei.pureDaisy");
        this.overlay = guiHelper.createDrawable(ResourceLocationHelper.prefix("textures/gui/pure_daisy_overlay.png"), 0, 0, 64, 44);
        this.icon = guiHelper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)ModSubtiles.pureDaisy));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public Class<? extends IPureDaisyRecipe> getRecipeClass() {
        return IPureDaisyRecipe.class;
    }

    @Nonnull
    public Component getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(IPureDaisyRecipe recipe, IRecipeSlotsView slotsView, PoseStack ms, double mouseX, double mouseY) {
        RenderSystem.m_69478_();
        this.overlay.draw(ms, 17, 0);
        RenderSystem.m_69461_();
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull IPureDaisyRecipe recipe, @Nonnull IFocusGroup focusGroup) {
        StateIngredient input = recipe.getInput();
        IRecipeSlotBuilder inputSlotBuilder = builder.addSlot(RecipeIngredientRole.INPUT, 9, 12).setFluidRenderer(1000, false, 16, 16);
        for (BlockState state : input.getDisplayed()) {
            if (state.m_60819_().m_76178_()) continue;
            inputSlotBuilder.addIngredient(VanillaTypes.FLUID, (Object)new FluidStack(state.m_60819_().m_76152_(), 1000));
        }
        ((IRecipeSlotBuilder)inputSlotBuilder.addItemStacks(input.getDisplayedStacks())).addTooltipCallback((view, tooltip) -> tooltip.addAll(input.descriptionTooltip()));
        builder.addSlot(RecipeIngredientRole.CATALYST, 39, 12).addItemStack(new ItemStack((ItemLike)ModSubtiles.pureDaisy));
        Block outBlock = recipe.getOutputState().m_60734_();
        FluidState outFluid = outBlock.m_49966_().m_60819_();
        if (!outFluid.m_76178_()) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 68, 12).setFluidRenderer(1000, false, 16, 16).addIngredient(VanillaTypes.FLUID, (Object)new FluidStack(outFluid.m_76152_(), 1000));
        } else if (outBlock.m_5456_() != Items.f_41852_) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 68, 12).addItemStack(new ItemStack((ItemLike)outBlock));
        }
    }
}

