/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client;

import java.util.Locale;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.mana.BlockPool;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.ItemBottledMana;
import vazkii.botania.common.item.ItemLexicon;
import vazkii.botania.common.item.ItemSpawnerMover;
import vazkii.botania.common.item.ItemTwigWand;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.brew.ItemBrewBase;
import vazkii.botania.common.item.equipment.bauble.ItemMagnetRing;
import vazkii.botania.common.item.equipment.tool.bow.ItemLivingwoodBow;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraAxe;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraPick;
import vazkii.botania.common.item.relic.ItemInfiniteFruit;
import vazkii.botania.common.item.rod.ItemTornadoRod;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.network.TriConsumer;

public final class BotaniaItemProperties {
    public static void init(TriConsumer<ItemLike, ResourceLocation, ClampedItemPropertyFunction> consumer) {
        consumer.accept((ItemLike)ModItems.blackHoleTalisman, ResourceLocationHelper.prefix("active"), (stack, world, entity, seed) -> ItemNBTHelper.getBoolean(stack, "active", false) ? 1.0f : 0.0f);
        consumer.accept((ItemLike)ModItems.manaBottle, ResourceLocationHelper.prefix("swigs_taken"), (stack, world, entity, seed) -> 6 - ItemBottledMana.getSwigsLeft(stack));
        ResourceLocation vuvuzelaId = ResourceLocationHelper.prefix("vuvuzela");
        ClampedItemPropertyFunction isVuvuzela = (stack, world, entity, seed) -> stack.m_41786_().getString().toLowerCase(Locale.ROOT).contains("vuvuzela") ? 1.0f : 0.0f;
        consumer.accept((ItemLike)ModItems.grassHorn, vuvuzelaId, isVuvuzela);
        consumer.accept((ItemLike)ModItems.leavesHorn, vuvuzelaId, isVuvuzela);
        consumer.accept((ItemLike)ModItems.snowHorn, vuvuzelaId, isVuvuzela);
        consumer.accept((ItemLike)ModItems.lexicon, ResourceLocationHelper.prefix("elven"), (stack, world, living, seed) -> ItemLexicon.isElven(stack) ? 1.0f : 0.0f);
        consumer.accept((ItemLike)ModItems.manaCookie, ResourceLocationHelper.prefix("totalbiscuit"), (stack, world, entity, seed) -> stack.m_41786_().getString().toLowerCase(Locale.ROOT).contains("totalbiscuit") ? 1.0f : 0.0f);
        consumer.accept((ItemLike)ModItems.slimeBottle, ResourceLocationHelper.prefix("active"), (stack, world, entity, seed) -> stack.m_41782_() && stack.m_41783_().m_128471_("active") ? 1.0f : 0.0f);
        consumer.accept((ItemLike)ModItems.spawnerMover, ResourceLocationHelper.prefix("full"), (stack, world, entity, seed) -> ItemSpawnerMover.hasData(stack) ? 1.0f : 0.0f);
        consumer.accept((ItemLike)ModItems.temperanceStone, ResourceLocationHelper.prefix("active"), (stack, world, entity, seed) -> ItemNBTHelper.getBoolean(stack, "active", false) ? 1.0f : 0.0f);
        consumer.accept((ItemLike)ModItems.twigWand, ResourceLocationHelper.prefix("bindmode"), (stack, world, entity, seed) -> ItemTwigWand.getBindMode(stack) ? 1.0f : 0.0f);
        consumer.accept((ItemLike)ModItems.dreamwoodWand, ResourceLocationHelper.prefix("bindmode"), (stack, world, entity, seed) -> ItemTwigWand.getBindMode(stack) ? 1.0f : 0.0f);
        ResourceLocation poolFullId = ResourceLocationHelper.prefix("full");
        ClampedItemPropertyFunction poolFull = (stack, world, entity, seed) -> {
            Block block = ((BlockItem)stack.m_41720_()).m_40614_();
            boolean renderFull = ((BlockPool)block).variant == BlockPool.Variant.CREATIVE || stack.m_41782_() && stack.m_41783_().m_128471_("RenderFull");
            return renderFull ? 1.0f : 0.0f;
        };
        consumer.accept((ItemLike)ModBlocks.manaPool, poolFullId, poolFull);
        consumer.accept((ItemLike)ModBlocks.dilutedPool, poolFullId, poolFull);
        consumer.accept((ItemLike)ModBlocks.creativePool, poolFullId, poolFull);
        consumer.accept((ItemLike)ModBlocks.fabulousPool, poolFullId, poolFull);
        ClampedItemPropertyFunction brewGetter = (stack, world, entity, seed) -> {
            ItemBrewBase item = (ItemBrewBase)stack.m_41720_();
            return item.getSwigs() - item.getSwigsLeft(stack);
        };
        consumer.accept((ItemLike)ModItems.brewVial, ResourceLocationHelper.prefix("swigs_taken"), brewGetter);
        consumer.accept((ItemLike)ModItems.brewFlask, ResourceLocationHelper.prefix("swigs_taken"), brewGetter);
        ResourceLocation holidayId = ResourceLocationHelper.prefix("holiday");
        ClampedItemPropertyFunction holidayGetter = (stack, worldIn, entityIn, seed) -> ClientProxy.jingleTheBells ? 1.0f : 0.0f;
        consumer.accept((ItemLike)ModItems.manaweaveHelm, holidayId, holidayGetter);
        consumer.accept((ItemLike)ModItems.manaweaveChest, holidayId, holidayGetter);
        consumer.accept((ItemLike)ModItems.manaweaveBoots, holidayId, holidayGetter);
        consumer.accept((ItemLike)ModItems.manaweaveLegs, holidayId, holidayGetter);
        ClampedItemPropertyFunction ringOnGetter = (stack, worldIn, entityIn, seed) -> ItemMagnetRing.getCooldown(stack) <= 0 ? 1.0f : 0.0f;
        consumer.accept((ItemLike)ModItems.magnetRing, ResourceLocationHelper.prefix("active"), ringOnGetter);
        consumer.accept((ItemLike)ModItems.magnetRingGreater, ResourceLocationHelper.prefix("active"), ringOnGetter);
        consumer.accept((ItemLike)ModItems.elementiumShears, ResourceLocationHelper.prefix("reddit"), (stack, world, entity, seed) -> stack.m_41786_().getString().equalsIgnoreCase("dammit reddit") ? 1.0f : 0.0f);
        consumer.accept((ItemLike)ModItems.manasteelSword, ResourceLocationHelper.prefix("elucidator"), (stack, world, entity, seed) -> "the elucidator".equals(stack.m_41786_().getString().toLowerCase(Locale.ROOT).trim()) ? 1.0f : 0.0f);
        consumer.accept((ItemLike)ModItems.terraAxe, ResourceLocationHelper.prefix("active"), (stack, world, entity, seed) -> {
            Player player;
            return !(entity instanceof Player) || ItemTerraAxe.shouldBreak(player = (Player)entity) ? 1 : 0;
        });
        consumer.accept((ItemLike)ModItems.terraPick, ResourceLocationHelper.prefix("tipped"), (stack, world, entity, seed) -> ItemTerraPick.isTipped(stack) ? 1.0f : 0.0f);
        consumer.accept((ItemLike)ModItems.terraPick, ResourceLocationHelper.prefix("active"), (stack, world, entity, seed) -> ItemTerraPick.isEnabled(stack) ? 1.0f : 0.0f);
        consumer.accept((ItemLike)ModItems.infiniteFruit, ResourceLocationHelper.prefix("boot"), (stack, worldIn, entity, seed) -> ItemInfiniteFruit.isBoot(stack) ? 1.0f : 0.0f);
        consumer.accept((ItemLike)ModItems.tornadoRod, ResourceLocationHelper.prefix("active"), (stack, world, living, seed) -> ItemTornadoRod.isFlying(stack) ? 1.0f : 0.0f);
        ClampedItemPropertyFunction pulling = (stack, worldIn, entity, seed) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f;
        ClampedItemPropertyFunction pull = (stack, worldIn, entity, seed) -> {
            if (entity == null) {
                return 0.0f;
            }
            ItemLivingwoodBow item = (ItemLivingwoodBow)stack.m_41720_();
            return entity.m_21211_() != stack ? 0.0f : (float)(stack.m_41779_() - entity.m_21212_()) * item.chargeVelocityMultiplier() / 20.0f;
        };
        consumer.accept((ItemLike)ModItems.livingwoodBow, new ResourceLocation("pulling"), pulling);
        consumer.accept((ItemLike)ModItems.livingwoodBow, new ResourceLocation("pull"), pull);
        consumer.accept((ItemLike)ModItems.crystalBow, new ResourceLocation("pulling"), pulling);
        consumer.accept((ItemLike)ModItems.crystalBow, new ResourceLocation("pull"), pull);
    }

    private BotaniaItemProperties() {
    }
}

