/*
 * Decompiled with CFR 0.152.
 */
package net.moddingplayground.twigs.init;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.moddingplayground.twigs.init.TwigsConfiguredFeatures;

public class TwigsPlacedFeatures {
    public static final Holder<PlacedFeature> PATCH_TWIG = TwigsPlacedFeatures.registerPlacedFeature("patch_twig", TwigsConfiguredFeatures.PATCH_TWIG, TwigsPlacedFeatures.modifiers(2));
    public static final Holder<PlacedFeature> PATCH_PEBBLE = TwigsPlacedFeatures.registerPlacedFeature("patch_pebble", TwigsConfiguredFeatures.PATCH_PEBBLE, TwigsPlacedFeatures.modifiers(2));
    public static final Holder<PlacedFeature> PATCH_SEA_SHELL = TwigsPlacedFeatures.registerPlacedFeature("patch_sea_shell", TwigsConfiguredFeatures.PATCH_SEA_SHELL, TwigsPlacedFeatures.modifiers(2));
    public static final Holder<PlacedFeature> ORE_RHYOLITE_LOWER = TwigsPlacedFeatures.registerPlacedFeature("ore_rhyolite_lower", TwigsConfiguredFeatures.ORE_RHYOLITE, TwigsPlacedFeatures.commonOrePlacement(2, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)16))));
    public static final Holder<PlacedFeature> ORE_SCHIST_UPPER = TwigsPlacedFeatures.registerPlacedFeature("ore_schist_upper", TwigsConfiguredFeatures.ORE_SCHIST, TwigsPlacedFeatures.rareOrePlacement(6, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)64), (VerticalAnchor)VerticalAnchor.m_158922_((int)128))));
    public static final Holder<PlacedFeature> ORE_SCHIST_LOWER = TwigsPlacedFeatures.registerPlacedFeature("ore_schist_lower", TwigsConfiguredFeatures.ORE_SCHIST, TwigsPlacedFeatures.commonOrePlacement(2, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)0), (VerticalAnchor)VerticalAnchor.m_158922_((int)60))));
    public static final Holder<PlacedFeature> ORE_BLOODSTONE_NETHER = TwigsPlacedFeatures.registerPlacedFeature("ore_bloodstone_nether", TwigsConfiguredFeatures.ORE_BLOODSTONE, TwigsPlacedFeatures.commonOrePlacement(2, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)5), (VerticalAnchor)VerticalAnchor.m_158922_((int)225))));

    public static void init() {
    }

    public static Holder<PlacedFeature> registerPlacedFeature(String string, Holder<? extends ConfiguredFeature<?, ?>> holder, List<PlacementModifier> list) {
        return BuiltinRegistries.m_206380_((Registry)BuiltinRegistries.f_194653_, (String)("twigs:" + string), (Object)new PlacedFeature(Holder.m_205706_(holder), List.copyOf(list)));
    }

    public static Holder<PlacedFeature> registerPlacedFeature(String string, Holder<? extends ConfiguredFeature<?, ?>> holder, PlacementModifier ... placementModifiers) {
        return TwigsPlacedFeatures.registerPlacedFeature(string, holder, List.of(placementModifiers));
    }

    private static List<PlacementModifier> modifiers(int chance) {
        return VegetationPlacements.m_195474_((int)chance);
    }

    private static List<PlacementModifier> orePlacement(PlacementModifier modifier, PlacementModifier modifier2) {
        return List.of(modifier, InSquarePlacement.m_191715_(), modifier2, BiomeFilter.m_191561_());
    }

    private static List<PlacementModifier> commonOrePlacement(int count, PlacementModifier modifier) {
        return TwigsPlacedFeatures.orePlacement((PlacementModifier)CountPlacement.m_191628_((int)count), modifier);
    }

    private static List<PlacementModifier> rareOrePlacement(int chance, PlacementModifier modifier) {
        return TwigsPlacedFeatures.orePlacement((PlacementModifier)RarityFilter.m_191900_((int)chance), modifier);
    }
}

