/*
 * Decompiled with CFR 0.152.
 */
package net.moddingplayground.twigs.events;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BambooBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BambooLeaves;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.InvertedLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.moddingplayground.twigs.block.PillarOxidizableBlock;
import net.moddingplayground.twigs.block.StrippedBambooBlock;
import net.moddingplayground.twigs.init.TwigsBlocks;
import net.moddingplayground.twigs.init.TwigsItems;

@Mod.EventBusSubscriber(modid="twigs", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MiscEvents {
    public static final Supplier<BiMap<Block, Block>> WAXABLES = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)((Block)TwigsBlocks.COPPER_PILLAR.get()), (Object)((Block)TwigsBlocks.WAXED_COPPER_PILLAR.get())).put((Object)((Block)TwigsBlocks.EXPOSED_COPPER_PILLAR.get()), (Object)((Block)TwigsBlocks.WAXED_EXPOSED_COPPER_PILLAR.get())).put((Object)((Block)TwigsBlocks.WEATHERED_COPPER_PILLAR.get()), (Object)((Block)TwigsBlocks.WAXED_WEATHERED_COPPER_PILLAR.get())).put((Object)((Block)TwigsBlocks.OXIDIZED_COPPER_PILLAR.get()), (Object)((Block)TwigsBlocks.WAXED_OXIDIZED_COPPER_PILLAR.get())).build());
    public static final Supplier<BiMap<Block, Block>> WAX_OFF_BY_BLOCK = Suppliers.memoize(() -> WAXABLES.get().inverse());

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        Optional<BlockState> waxables;
        BlockPos blockPos = event.getPos();
        Level world = event.getWorld();
        BlockState state = world.m_8055_(blockPos);
        Player player = event.getPlayer();
        ItemStack stack = event.getItemStack();
        InteractionHand hand = event.getHand();
        if (state.m_60713_(Blocks.f_152542_) && stack.m_204117_(Tags.Items.SHEARS)) {
            world.m_46597_(blockPos, Blocks.f_152541_.m_49966_());
            world.m_6269_(null, (Entity)player, SoundEvents.f_12344_, SoundSource.PLAYERS, 1.0f, 1.0f);
            Block.m_49840_((Level)world, (BlockPos)blockPos.m_7494_(), (ItemStack)new ItemStack((ItemLike)TwigsBlocks.AZALEA_FLOWERS.get(), world.f_46441_.nextInt(2) + 1));
            stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            player.m_6674_(hand);
        }
        if (stack.m_41720_() == Items.f_42784_ && (waxables = Optional.ofNullable((Block)WAXABLES.get().get((Object)state.m_60734_())).map(blockState -> blockState.m_152465_(state))).isPresent()) {
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10562_.m_45482_((ServerPlayer)player, blockPos, stack);
            }
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            world.m_7731_(blockPos, waxables.get(), 1);
            world.m_5898_(player, 3003, blockPos, 0);
            player.m_6674_(hand);
        }
        if (stack.m_41720_() instanceof AxeItem) {
            Optional<BlockState> previousWaxed;
            Optional<BlockState> previous;
            Optional<Object> finalState = Optional.empty();
            if (state.m_60734_() instanceof PillarOxidizableBlock && (previous = PillarOxidizableBlock.getPreviousState(state)).isPresent()) {
                world.m_5594_(player, blockPos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.m_5898_(player, 3005, blockPos, 0);
                finalState = previous;
            }
            if ((previousWaxed = Optional.ofNullable((Block)WAX_OFF_BY_BLOCK.get().get((Object)state.m_60734_())).map(blockState -> blockState.m_152465_(state))).isPresent()) {
                world.m_5594_(player, blockPos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.m_5898_(player, 3004, blockPos, 0);
                finalState = previousWaxed;
            }
            if (state.m_60713_(Blocks.f_50571_) && !world.m_8055_(blockPos.m_7494_()).m_60713_(Blocks.f_50571_)) {
                world.m_5594_(player, blockPos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
                finalState = Optional.of((BlockState)((Block)TwigsBlocks.STRIPPED_BAMBOO.get()).m_49966_().m_61124_((Property)StrippedBambooBlock.FROM_BAMBOO, (Comparable)Boolean.valueOf(true)));
            }
            if (finalState.isPresent()) {
                world.m_7731_(blockPos, (BlockState)finalState.get(), 11);
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                player.m_6674_(hand);
            }
        }
    }

    @SubscribeEvent
    public void onFuelBurn(FurnaceFuelBurnTimeEvent event) {
        ((ImmutableMap.Builder)Util.m_137469_((Object)ImmutableMap.builder(), map -> map.put((Object)((ItemLike)TwigsBlocks.STRIPPED_BAMBOO.get()), (Object)50).put((Object)((ItemLike)TwigsItems.STRIPPED_BAMBOO_BOAT.get()), (Object)1200).put((Object)((ItemLike)TwigsItems.STRIPPED_BAMBOO_SIGN.get()), (Object)200).put((Object)((ItemLike)TwigsBlocks.BUNDLED_BAMBOO.get()), (Object)450).put((Object)((ItemLike)TwigsBlocks.STRIPPED_BUNDLED_BAMBOO.get()), (Object)450).put((Object)((ItemLike)TwigsBlocks.STRIPPED_BAMBOO_PLANKS.get()), (Object)200))).build().forEach((item, burnTime) -> {
            if (event.getItemStack().m_150930_(item.m_5456_())) {
                event.setBurnTime(burnTime.intValue());
            }
        });
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        ResourceLocation id = event.getName();
        LootTable table = event.getTable();
        if (id.equals((Object)Blocks.f_50571_.m_60589_())) {
            table.addPool(LootPool.m_79043_().m_6509_(InvertedLootItemCondition.m_81694_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)Blocks.f_50571_).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)BambooBlock.f_48870_, (Comparable)BambooLeaves.NONE)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)TwigsBlocks.BAMBOO_LEAVES.get()))).m_79082_());
        }
    }
}

