/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.util.recipes;

import cofh.lib.fluid.FluidIngredient;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.recipes.RecipeJsonUtils;
import cofh.thermal.lib.util.recipes.ThermalRecipe;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class MachineRecipeSerializer<T extends ThermalRecipe>
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<T> {
    protected final int defaultEnergy;
    protected final IFactory<T> factory;

    public MachineRecipeSerializer(IFactory<T> factory, int defaultEnergy) {
        this.factory = factory;
        this.defaultEnergy = defaultEnergy;
    }

    public T fromJson(ResourceLocation recipeId, JsonObject json) {
        int energy = this.defaultEnergy;
        float experience = 0.0f;
        ArrayList<Ingredient> inputItems = new ArrayList<Ingredient>();
        ArrayList<FluidIngredient> inputFluids = new ArrayList<FluidIngredient>();
        ArrayList<ItemStack> outputItems = new ArrayList<ItemStack>();
        ArrayList<Float> outputItemChances = new ArrayList<Float>();
        ArrayList<FluidStack> outputFluids = new ArrayList<FluidStack>();
        if (json.has("ingredient")) {
            RecipeJsonUtils.parseInputs(inputItems, inputFluids, (JsonElement)json.get("ingredient"));
        } else if (json.has("ingredients")) {
            RecipeJsonUtils.parseInputs(inputItems, inputFluids, (JsonElement)json.get("ingredients"));
        } else if (json.has("input")) {
            RecipeJsonUtils.parseInputs(inputItems, inputFluids, (JsonElement)json.get("input"));
        } else if (json.has("inputs")) {
            RecipeJsonUtils.parseInputs(inputItems, inputFluids, (JsonElement)json.get("inputs"));
        }
        if (json.has("result")) {
            RecipeJsonUtils.parseOutputs(outputItems, outputItemChances, outputFluids, (JsonElement)json.get("result"));
        } else if (json.has("results")) {
            RecipeJsonUtils.parseOutputs(outputItems, outputItemChances, outputFluids, (JsonElement)json.get("results"));
        } else if (json.has("output")) {
            RecipeJsonUtils.parseOutputs(outputItems, outputItemChances, outputFluids, (JsonElement)json.get("output"));
        } else if (json.has("outputs")) {
            RecipeJsonUtils.parseOutputs(outputItems, outputItemChances, outputFluids, (JsonElement)json.get("outputs"));
        }
        if (json.has("energy")) {
            energy = json.get("energy").getAsInt();
        }
        if (json.has("energy_mod")) {
            energy = (int)((float)energy * json.get("energy_mod").getAsFloat());
        }
        energy = MathHelper.clamp((int)energy, (int)0, (int)Integer.MAX_VALUE);
        if (json.has("experience")) {
            experience = json.get("experience").getAsFloat();
        } else if (json.has("xp")) {
            experience = json.get("xp").getAsFloat();
        }
        if (inputItems.isEmpty() && inputFluids.isEmpty() || outputItems.isEmpty() && outputFluids.isEmpty()) {
            throw new JsonSyntaxException("Invalid Thermal Series recipe: " + recipeId + "\nRefer to the recipe's ResourceLocation to find the mod responsible and let them know!");
        }
        return this.factory.create(recipeId, energy, experience, inputItems, inputFluids, outputItems, outputItemChances, outputFluids);
    }

    @Nullable
    public T fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        int energy = buffer.m_130242_();
        float experience = buffer.readFloat();
        int numInputItems = buffer.m_130242_();
        ArrayList<Ingredient> inputItems = new ArrayList<Ingredient>(numInputItems);
        for (int i = 0; i < numInputItems; ++i) {
            inputItems.add(Ingredient.m_43940_((FriendlyByteBuf)buffer));
        }
        int numInputFluids = buffer.m_130242_();
        ArrayList<FluidIngredient> inputFluids = new ArrayList<FluidIngredient>(numInputFluids);
        for (int i = 0; i < numInputFluids; ++i) {
            inputFluids.add(FluidIngredient.fromNetwork((FriendlyByteBuf)buffer));
        }
        int numOutputItems = buffer.m_130242_();
        ArrayList<ItemStack> outputItems = new ArrayList<ItemStack>(numOutputItems);
        ArrayList<Float> outputItemChances = new ArrayList<Float>(numOutputItems);
        for (int i = 0; i < numOutputItems; ++i) {
            outputItems.add(buffer.m_130267_());
            outputItemChances.add(Float.valueOf(buffer.readFloat()));
        }
        int numOutputFluids = buffer.m_130242_();
        ArrayList<FluidStack> outputFluids = new ArrayList<FluidStack>(numOutputFluids);
        for (int i = 0; i < numOutputFluids; ++i) {
            outputFluids.add(buffer.readFluidStack());
        }
        if (inputItems.isEmpty() && inputFluids.isEmpty() || outputItems.isEmpty() && outputFluids.isEmpty()) {
            throw new JsonSyntaxException("Invalid Thermal Series recipe: " + recipeId + "\nRefer to the recipe's ResourceLocation to find the mod responsible and let them know!");
        }
        return this.factory.create(recipeId, energy, experience, inputItems, inputFluids, outputItems, outputItemChances, outputFluids);
    }

    public void toNetwork(FriendlyByteBuf buffer, T recipe) {
        buffer.m_130130_(((ThermalRecipe)((Object)recipe)).energy);
        buffer.writeFloat(((ThermalRecipe)((Object)recipe)).xp);
        int numInputItems = ((ThermalRecipe)((Object)recipe)).inputItems.size();
        buffer.m_130130_(numInputItems);
        for (int i = 0; i < numInputItems; ++i) {
            ((ThermalRecipe)((Object)recipe)).inputItems.get(i).m_43923_(buffer);
        }
        int numInputFluids = ((ThermalRecipe)((Object)recipe)).inputFluids.size();
        buffer.m_130130_(numInputFluids);
        for (int i = 0; i < numInputFluids; ++i) {
            ((ThermalRecipe)((Object)recipe)).inputFluids.get(i).toNetwork(buffer);
        }
        int numOutputItems = ((ThermalRecipe)((Object)recipe)).outputItems.size();
        buffer.m_130130_(numOutputItems);
        for (int i = 0; i < numOutputItems; ++i) {
            buffer.m_130055_(((ThermalRecipe)((Object)recipe)).outputItems.get(i));
            buffer.writeFloat(((ThermalRecipe)((Object)recipe)).outputItemChances.get(i).floatValue());
        }
        int numOutputFluids = ((ThermalRecipe)((Object)recipe)).outputFluids.size();
        buffer.m_130130_(numOutputFluids);
        for (int i = 0; i < numOutputFluids; ++i) {
            buffer.writeFluidStack(((ThermalRecipe)((Object)recipe)).outputFluids.get(i));
        }
    }

    public static interface IFactory<T extends ThermalRecipe> {
        public T create(ResourceLocation var1, int var2, float var3, List<Ingredient> var4, List<FluidIngredient> var5, List<ItemStack> var6, List<Float> var7, List<FluidStack> var8);
    }
}

