/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.util.managers;

import cofh.lib.fluid.IFluidStackAccess;
import cofh.lib.inventory.IItemStackAccess;
import cofh.lib.inventory.ItemStackHolder;
import cofh.lib.util.ComparableItemStack;
import cofh.thermal.lib.util.managers.AbstractManager;
import cofh.thermal.lib.util.managers.CatalyzedRecipeManager;
import cofh.thermal.lib.util.managers.IRecipeManager;
import cofh.thermal.lib.util.recipes.IThermalInventory;
import cofh.thermal.lib.util.recipes.ThermalCatalyst;
import cofh.thermal.lib.util.recipes.ThermalRecipe;
import cofh.thermal.lib.util.recipes.internal.BaseMachineCatalyst;
import cofh.thermal.lib.util.recipes.internal.BaseMachineRecipe;
import cofh.thermal.lib.util.recipes.internal.DisenchantMachineRecipe;
import cofh.thermal.lib.util.recipes.internal.IMachineRecipe;
import cofh.thermal.lib.util.recipes.internal.IRecipeCatalyst;
import cofh.thermal.lib.util.recipes.internal.SimpleMachineRecipe;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public abstract class SingleItemRecipeManager
extends AbstractManager
implements IRecipeManager {
    protected Map<ComparableItemStack, IMachineRecipe> recipeMap = new Object2ObjectOpenHashMap();
    protected int maxOutputItems;
    protected int maxOutputFluids;

    protected SingleItemRecipeManager(int defaultEnergy, int maxOutputItems, int maxOutputFluids) {
        super(defaultEnergy);
        this.maxOutputItems = maxOutputItems;
        this.maxOutputFluids = maxOutputFluids;
    }

    public final void addRecipe(ThermalRecipe recipe) {
        this.addRecipe(recipe, BaseMachineRecipe.RecipeType.STANDARD);
    }

    public void addRecipe(ThermalRecipe recipe, BaseMachineRecipe.RecipeType type) {
        if (!recipe.getInputFluids().isEmpty()) {
            for (FluidStack fluidInput : recipe.getInputFluids().get(0).getFluids()) {
                for (ItemStack recipeInput : recipe.getInputItems().get(0).m_43908_()) {
                    this.addRecipe(recipe.getEnergy(), recipe.getXp(), Collections.singletonList(recipeInput), Collections.singletonList(fluidInput), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids(), type);
                }
            }
        } else {
            for (ItemStack recipeInput : recipe.getInputItems().get(0).m_43908_()) {
                this.addRecipe(recipe.getEnergy(), recipe.getXp(), Collections.singletonList(recipeInput), Collections.emptyList(), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids(), type);
            }
        }
    }

    public boolean validRecipe(ItemStack input) {
        return this.getRecipe(input) != null;
    }

    protected void clear() {
        this.recipeMap.clear();
    }

    protected IMachineRecipe getRecipe(ItemStack input) {
        return this.getRecipe(Collections.singletonList(new ItemStackHolder(input)), Collections.emptyList());
    }

    protected IMachineRecipe getRecipe(List<? extends IItemStackAccess> inputSlots, List<? extends IFluidStackAccess> inputTanks) {
        if (inputSlots.isEmpty() || inputSlots.get(0).isEmpty()) {
            return null;
        }
        return this.recipeMap.get(SingleItemRecipeManager.convert(inputSlots.get(0).getItemStack()));
    }

    protected IMachineRecipe addRecipe(int energy, float experience, List<ItemStack> inputItems, List<FluidStack> inputFluids, List<ItemStack> outputItems, List<Float> chance, List<FluidStack> outputFluids, BaseMachineRecipe.RecipeType type) {
        if (inputItems.isEmpty() || outputItems.isEmpty() && outputFluids.isEmpty() || outputItems.size() > this.maxOutputItems || outputFluids.size() > this.maxOutputFluids || energy <= 0) {
            return null;
        }
        ItemStack input = inputItems.get(0);
        if (input.m_41619_()) {
            return null;
        }
        for (ItemStack itemStack : outputItems) {
            if (!itemStack.m_41619_()) continue;
            return null;
        }
        for (FluidStack fluidStack : outputFluids) {
            if (!fluidStack.isEmpty()) continue;
            return null;
        }
        energy = (int)((float)energy * this.getDefaultScale());
        BaseMachineRecipe recipe = type == BaseMachineRecipe.RecipeType.DISENCHANT ? new DisenchantMachineRecipe(energy, experience, inputItems, inputFluids, outputItems, chance, outputFluids) : new SimpleMachineRecipe(energy, experience, inputItems, inputFluids, outputItems, chance, outputFluids);
        this.recipeMap.put(SingleItemRecipeManager.convert(input), recipe);
        return recipe;
    }

    @Override
    public IMachineRecipe getRecipe(IThermalInventory inventory) {
        return this.getRecipe(inventory.inputSlots(), inventory.inputTanks());
    }

    @Override
    public List<IMachineRecipe> getRecipeList() {
        return new ArrayList<IMachineRecipe>(this.recipeMap.values());
    }

    public static abstract class Catalyzed
    extends SingleItemRecipeManager
    implements CatalyzedRecipeManager {
        protected Map<ComparableItemStack, IRecipeCatalyst> catalystMap = new Object2ObjectOpenHashMap();

        protected Catalyzed(int defaultEnergy, int maxOutputItems, int maxOutputFluids) {
            super(defaultEnergy, maxOutputItems, maxOutputFluids);
        }

        @Override
        protected void clear() {
            super.clear();
            this.catalystMap.clear();
        }

        @Override
        public List<ItemStack> getCatalysts() {
            ArrayList<ItemStack> ret = new ArrayList<ItemStack>(this.catalystMap.size());
            this.catalystMap.keySet().forEach(stack -> ret.add(stack.toItemStack()));
            return ret;
        }

        @Override
        public IRecipeCatalyst getCatalyst(IItemStackAccess input) {
            return this.catalystMap.get(Catalyzed.convert(input.getItemStack()));
        }

        @Override
        public IRecipeCatalyst getCatalyst(ItemStack input) {
            return this.catalystMap.get(Catalyzed.convert(input));
        }

        public void addCatalyst(ThermalCatalyst catalyst) {
            for (ItemStack ingredient : catalyst.getIngredient().m_43908_()) {
                this.addCatalyst(ingredient, catalyst.getPrimaryMod(), catalyst.getSecondaryMod(), catalyst.getEnergyMod(), catalyst.getMinChance(), catalyst.getUseChance());
            }
        }

        public IRecipeCatalyst addCatalyst(ItemStack input, float primaryMod, float secondaryMod, float energyMod, float minChance, float useChance) {
            if (input == null || input.m_41619_()) {
                return null;
            }
            BaseMachineCatalyst catalyst = new BaseMachineCatalyst(primaryMod, secondaryMod, energyMod, minChance, useChance);
            this.catalystMap.put(Catalyzed.convert(input), catalyst);
            return catalyst;
        }

        public boolean validCatalyst(ItemStack input) {
            return this.getCatalyst(input) != null;
        }

        public IRecipeCatalyst removeCatalyst(ItemStack input) {
            return this.catalystMap.remove(Catalyzed.convert(input));
        }
    }
}

