/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.compat.crt.actions;

import cofh.thermal.lib.util.recipes.ThermalFuel;
import com.blamejared.crafttweaker.api.action.recipe.ActionRecipeBase;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import java.util.Arrays;
import java.util.Iterator;
import net.minecraft.core.Registry;
import net.minecraft.world.item.crafting.Ingredient;

public class ActionRemoveThermalFuelByInput
extends ActionRecipeBase {
    private final IItemStack[] inputs;
    private final IFluidStack[] fluids;

    public ActionRemoveThermalFuelByInput(IRecipeManager manager, IItemStack[] inputs) {
        super(manager);
        this.inputs = inputs;
        this.fluids = new IFluidStack[0];
    }

    public ActionRemoveThermalFuelByInput(IRecipeManager manager, IFluidStack[] fluids) {
        super(manager);
        this.inputs = new IItemStack[0];
        this.fluids = fluids;
    }

    public ActionRemoveThermalFuelByInput(IRecipeManager manager, IItemStack[] inputs, IFluidStack[] fluids) {
        super(manager);
        this.inputs = inputs;
        this.fluids = fluids;
    }

    public void apply() {
        Iterator iter = this.getManager().getRecipes().entrySet().iterator();
        while (iter.hasNext()) {
            int i;
            ThermalFuel fuel = (ThermalFuel)((Object)iter.next().getValue());
            if (fuel.getInputItems().size() != this.inputs.length || fuel.getInputFluids().size() != this.fluids.length) continue;
            boolean valid = true;
            for (i = 0; i < fuel.getInputItems().size(); ++i) {
                if (IIngredient.fromIngredient((Ingredient)fuel.getInputItems().get(i)).matches(this.inputs[i])) continue;
                valid = false;
                break;
            }
            for (i = 0; i < fuel.getInputFluids().size(); ++i) {
                if (fuel.getInputFluids().get(i).test(this.fluids[i].getInternal())) continue;
                valid = false;
                break;
            }
            if (!valid) continue;
            iter.remove();
        }
    }

    public String describe() {
        return "Removing \"" + Registry.f_122864_.m_7981_((Object)this.getManager().getRecipeType()) + "\" fuels with inputs: " + Arrays.toString(this.inputs) + "\" and fluid inputs: \"" + Arrays.toString(this.fluids) + "\"";
    }
}

