/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.managers.dynamo;

import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.core.util.recipes.dynamo.GourmandFuel;
import cofh.thermal.lib.util.managers.SingleItemFuelManager;
import cofh.thermal.lib.util.recipes.ThermalFuel;
import cofh.thermal.lib.util.recipes.internal.IDynamoFuel;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class GourmandFuelManager
extends SingleItemFuelManager {
    private static final GourmandFuelManager INSTANCE = new GourmandFuelManager();
    protected static final int DEFAULT_ENERGY = 1600;
    protected List<GourmandFuel> convertedFuels = new ArrayList<GourmandFuel>();

    public static GourmandFuelManager instance() {
        return INSTANCE;
    }

    private GourmandFuelManager() {
        super(1600);
    }

    @Override
    public boolean validFuel(ItemStack input) {
        if (input.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) {
            return false;
        }
        return this.getEnergy(input) > 0;
    }

    @Override
    protected void clear() {
        this.fuelMap.clear();
        this.convertedFuels.clear();
    }

    public int getEnergy(ItemStack stack) {
        IDynamoFuel fuel = this.getFuel(stack);
        return fuel != null ? fuel.getEnergy() : this.getEnergyFromFood(stack);
    }

    public int getEnergyFromFood(ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        if (stack.m_41720_().hasContainerItem(stack)) {
            return 0;
        }
        FoodProperties food = stack.m_41720_().m_41473_();
        if (food == null) {
            return 0;
        }
        int energy = food.m_38744_() * 1600;
        if (food.m_38749_().size() > 0) {
            for (Pair effect : food.m_38749_()) {
                if (((MobEffectInstance)effect.getFirst()).m_19544_().m_19483_() != MobEffectCategory.HARMFUL) continue;
                return 0;
            }
            energy *= 2;
        }
        if (food.m_38745_() > 1.0f) {
            energy *= 4;
        }
        if (food.m_38748_()) {
            energy *= 2;
        }
        return energy >= 1000 ? energy : 0;
    }

    @Override
    public void refresh(RecipeManager recipeManager) {
        this.clear();
        Map recipes = recipeManager.m_44054_(TCoreRecipeTypes.FUEL_GOURMAND);
        for (Map.Entry entry : recipes.entrySet()) {
            this.addFuel((ThermalFuel)((Object)entry.getValue()));
        }
        this.createConvertedRecipes(recipeManager);
    }

    public List<GourmandFuel> getConvertedFuels() {
        return this.convertedFuels;
    }

    protected void createConvertedRecipes(RecipeManager recipeManager) {
        for (Item item : ForgeRegistries.ITEMS) {
            ItemStack query = new ItemStack((ItemLike)item);
            try {
                if (this.getFuel(query) != null || !this.validFuel(query)) continue;
                this.convertedFuels.add(this.convert(query, this.getEnergy(query)));
            }
            catch (Exception e) {
                ThermalCore.LOG.error(query.m_41720_().getRegistryName() + " threw an exception when querying the fuel value as the mod author is doing non-standard things in their item code (possibly tag related). It may not display in JEI but should function as fuel.");
            }
        }
    }

    protected GourmandFuel convert(ItemStack item, int energy) {
        return new GourmandFuel(new ResourceLocation("thermal", "gourmand_" + item.m_41720_().getRegistryName().m_135815_()), energy, Collections.singletonList(Ingredient.m_43927_((ItemStack[])new ItemStack[]{item})), Collections.emptyList());
    }
}

