/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.item;

import cofh.core.util.ProxyUtils;
import cofh.core.util.filter.EmptyFilter;
import cofh.core.util.filter.FilterRegistry;
import cofh.core.util.helpers.ChatHelper;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.inventory.SimpleItemInv;
import cofh.lib.item.IColorableItem;
import cofh.lib.item.IMultiModeItem;
import cofh.lib.util.Utils;
import cofh.lib.util.filter.IFilter;
import cofh.lib.util.filter.IFilterableItem;
import cofh.lib.util.helpers.AugmentableHelper;
import cofh.lib.util.helpers.FilterHelper;
import cofh.lib.util.helpers.InventoryHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.SecurityHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.core.inventory.container.storage.SatchelContainer;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.item.InventoryContainerItemAugmentable;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class SatchelItem
extends InventoryContainerItemAugmentable
implements IColorableItem,
DyeableLeatherItem,
IFilterableItem,
IMultiModeItem,
MenuProvider {
    protected static final Set<Item> BANNED_ITEMS = new ObjectOpenHashSet();
    protected static final WeakHashMap<ItemStack, IFilter> FILTERS = new WeakHashMap(128);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setBannedItems(Collection<String> itemLocs) {
        Set<Item> set = BANNED_ITEMS;
        synchronized (set) {
            BANNED_ITEMS.clear();
            for (String loc : itemLocs) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(loc));
                if (item == null) continue;
                BANNED_ITEMS.add(item);
            }
        }
    }

    public SatchelItem(Item.Properties builder, int slots) {
        super(builder, slots);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("color"), (stack, world, entity, seed) -> this.m_41113_(stack) ? 1.0f : 0.0f);
        ProxyUtils.registerColorable((Item)this);
        this.numSlots = () -> ThermalCoreConfig.storageAugments;
        this.augValidator = ThermalAugmentRules.createAllowValidator("Upgrade", "Filter");
    }

    protected void tooltipDelegate(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)StringHelper.getTextComponent((String)"info.thermal.satchel.use").m_130940_(ChatFormatting.GRAY));
        if (FilterHelper.hasFilter((ItemStack)stack)) {
            tooltip.add((Component)StringHelper.getTextComponent((String)"info.thermal.satchel.use.sneak").m_130940_(ChatFormatting.DARK_GRAY));
        }
        tooltip.add((Component)StringHelper.getTextComponent((String)("info.thermal.satchel.mode." + this.getMode(stack))).m_130940_(ChatFormatting.ITALIC));
        this.addModeChangeTooltip(this, stack, worldIn, tooltip, flagIn);
        super.tooltipDelegate(stack, worldIn, tooltip, flagIn);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        return this.useDelegate(stack, playerIn, handIn) ? InteractionResultHolder.m_19090_((Object)stack) : InteractionResultHolder.m_19098_((Object)stack);
    }

    public static boolean onItemPickup(EntityItemPickupEvent event, ItemStack container) {
        SatchelItem satchelItem = (SatchelItem)container.m_41720_();
        if (satchelItem.getMode(container) <= 0 || !satchelItem.canPlayerAccess(container, event.getPlayer())) {
            return false;
        }
        ItemEntity eventItem = event.getItem();
        int count = eventItem.m_32055_().m_41613_();
        if (satchelItem.getFilter(container).valid(eventItem.m_32055_())) {
            SimpleItemInv containerInv = satchelItem.getContainerInventory(container);
            eventItem.m_32045_(InventoryHelper.insertStackIntoInventory((IItemHandler)containerInv, (ItemStack)eventItem.m_32055_(), (boolean)false));
            if (eventItem.m_32055_().m_41613_() != count) {
                container.m_41754_(5);
                Player player = event.getPlayer();
                player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((MathHelper.RANDOM.nextFloat() - MathHelper.RANDOM.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                containerInv.write(satchelItem.getOrCreateInvTag(container));
                satchelItem.onContainerInventoryChanged(container);
            }
        }
        return eventItem.m_32055_().m_41613_() != count;
    }

    protected boolean useDelegate(ItemStack stack, Player player, InteractionHand hand) {
        if (Utils.isFakePlayer((Entity)player) || hand == InteractionHand.OFF_HAND) {
            return false;
        }
        if (player instanceof ServerPlayer) {
            if (!this.canPlayerAccess(stack, player)) {
                ChatHelper.sendIndexedChatMessageToPlayer((Player)player, (Component)new TranslatableComponent("info.cofh.secure_warning", new Object[]{SecurityHelper.getOwnerName((ItemStack)stack)}));
                return false;
            }
            if (SecurityHelper.attemptClaimItem((ItemStack)stack, (Player)player)) {
                ChatHelper.sendIndexedChatMessageToPlayer((Player)player, (Component)new TranslatableComponent("info.cofh.secure_item"));
                return false;
            }
            if (player.m_36341_()) {
                if (FilterHelper.hasFilter((ItemStack)stack)) {
                    NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)this.getFilter(stack));
                    return true;
                }
                return false;
            }
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)this);
        }
        return true;
    }

    protected SimpleItemInv readInventoryFromNBT(ItemStack container) {
        CompoundTag containerTag = this.getOrCreateInvTag(container);
        int numSlots = this.getContainerSlots(container);
        ArrayList<ItemStorageCoFH> invSlots = new ArrayList<ItemStorageCoFH>(numSlots);
        for (int i = 0; i < numSlots; ++i) {
            invSlots.add(new ItemStorageCoFH());
        }
        SimpleItemInv inventory = new SimpleItemInv(invSlots){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (slot < 0 || slot >= this.getSlots()) {
                    return false;
                }
                return !BANNED_ITEMS.contains(stack.m_41720_());
            }
        };
        inventory.read(containerTag);
        return inventory;
    }

    @Override
    protected void setAttributesFromAugment(ItemStack container, CompoundTag augmentData) {
        CompoundTag subTag = container.m_41737_("Properties");
        if (subTag == null) {
            return;
        }
        AugmentableHelper.setAttributeFromAugmentString((CompoundTag)subTag, (CompoundTag)augmentData, (String)"FilterType");
        super.setAttributesFromAugment(container, augmentData);
    }

    public Component m_5446_() {
        return new TranslatableComponent("item.thermal.satchel");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new SatchelContainer(i, inventory, player);
    }

    public IFilter getFilter(ItemStack stack) {
        String filterType = FilterHelper.getFilterType((ItemStack)stack);
        if (filterType.isEmpty()) {
            return EmptyFilter.INSTANCE;
        }
        IFilter ret = FILTERS.get(stack);
        if (ret != null) {
            return ret;
        }
        if (FILTERS.size() > 128) {
            FILTERS.clear();
        }
        FILTERS.put(stack, FilterRegistry.getHeldFilter((String)filterType, (CompoundTag)stack.m_41783_()));
        return FILTERS.get(stack);
    }

    public void onFilterChanged(ItemStack stack) {
        FILTERS.remove(stack);
    }

    public void onModeChange(Player player, ItemStack stack) {
        player.f_19853_.m_5594_(null, player.m_142538_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.4f, 0.8f + 0.4f * (float)this.getMode(stack));
        ChatHelper.sendIndexedChatMessageToPlayer((Player)player, (Component)new TranslatableComponent("info.thermal.satchel.mode." + this.getMode(stack)));
    }
}

