/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.item;

import cofh.core.item.ItemCoFH;
import cofh.core.util.ProxyUtils;
import cofh.lib.item.IPlacementItem;
import cofh.lib.util.IConveyableData;
import cofh.lib.util.Utils;
import cofh.lib.util.control.ISecurable;
import cofh.lib.util.helpers.StringHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class RedprintItem
extends ItemCoFH
implements IPlacementItem {
    public RedprintItem(Item.Properties builder) {
        super(builder);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("has_data"), (stack, world, entity, seed) -> stack.m_41782_() ? 1.0f : 0.0f);
    }

    protected void tooltipDelegate(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag conveyableData = stack.m_41783_();
        if (conveyableData == null) {
            tooltip.add((Component)StringHelper.getTextComponent((String)"info.thermal.redprint.use").m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)StringHelper.getTextComponent((String)"info.thermal.redprint.use.contents").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)StringHelper.getTextComponent((String)"info.thermal.redprint.use.sneak").m_130940_(ChatFormatting.DARK_GRAY));
            tooltip.add((Component)StringHelper.getTextComponent((String)"info.thermal.redprint.contents"));
            for (String type : conveyableData.m_128431_()) {
                if (!StringHelper.canLocalize((String)("info.thermal.redprint.data." + type))) {
                    tooltip.add((Component)StringHelper.getTextComponent((String)"info.thermal.redprint.unknown").m_130940_(ChatFormatting.DARK_GRAY));
                }
                tooltip.add((Component)new TextComponent(" - ").m_7220_((Component)StringHelper.getTextComponent((String)("info.thermal.redprint.data." + type)).m_130940_(ChatFormatting.GRAY)));
            }
        }
    }

    public Rarity m_41460_(ItemStack stack) {
        return stack.m_41782_() ? Rarity.UNCOMMON : Rarity.COMMON;
    }

    protected boolean useDelegate(ItemStack stack, UseOnContext context) {
        Level world = context.m_43725_();
        Player player = context.m_43723_();
        if (player == null || Utils.isClientWorld((Level)world)) {
            return false;
        }
        if (player.m_36341_() && context.m_43724_() == InteractionHand.MAIN_HAND) {
            if (stack.m_41783_() != null) {
                player.f_19853_.m_5594_(null, player.m_142538_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.5f, 0.3f);
                stack.m_41751_(null);
            }
            return true;
        }
        BlockPos pos = context.m_8083_();
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof ISecurable && !((ISecurable)tile).canAccess((Entity)player)) {
            return false;
        }
        if (tile instanceof IConveyableData) {
            IConveyableData conveyableTile = (IConveyableData)tile;
            if (stack.m_41783_() == null && context.m_43724_() == InteractionHand.MAIN_HAND) {
                conveyableTile.writeConveyableData(player, stack.m_41784_());
                tile.m_6596_();
                if (stack.m_41783_().m_128456_()) {
                    stack.m_41751_(null);
                    return false;
                }
                player.f_19853_.m_5594_(null, player.m_142538_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.5f, 0.7f);
            } else {
                conveyableTile.readConveyableData(player, stack.m_41783_());
                player.f_19853_.m_5594_(null, player.m_142538_(), SoundEvents.f_12490_, SoundSource.PLAYERS, 0.5f, 0.8f);
            }
            return true;
        }
        return false;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        return player.m_36204_(context.m_8083_(), context.m_43719_(), context.m_43722_()) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        return player.m_36204_(context.m_8083_(), context.m_43719_(), stack) && this.useDelegate(stack, context) ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_36341_()) {
            if (stack.m_41783_() != null) {
                player.m_5496_(SoundEvents.f_11871_, 0.5f, 0.3f);
            }
            stack.m_41751_(null);
        }
        player.m_6674_(hand);
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public boolean onBlockPlacement(ItemStack stack, UseOnContext context) {
        return this.useDelegate(stack, context);
    }
}

