/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.entity.projectile;

import cofh.lib.util.AreaUtils;
import cofh.lib.util.Utils;
import cofh.lib.util.references.CoreReferences;
import cofh.thermal.core.entity.projectile.ElementalProjectile;
import cofh.thermal.core.init.TCoreReferences;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class BlizzProjectile
extends ElementalProjectile {
    private static final int CLOUD_DURATION = 20;
    public static float defaultDamage = 5.0f;
    public static int effectAmplifier = 0;
    public static int effectDuration = 100;
    public static int effectRadius = 2;

    public BlizzProjectile(EntityType<? extends AbstractHurtingProjectile> type, Level world) {
        super(type, world);
    }

    public BlizzProjectile(LivingEntity shooter, double accelX, double accelY, double accelZ, Level world) {
        super(TCoreReferences.BLIZZ_PROJECTILE_ENTITY, shooter, accelX, accelY, accelZ, world);
    }

    public BlizzProjectile(double x, double y, double z, double accelX, double accelY, double accelZ, Level world) {
        super(TCoreReferences.BLIZZ_PROJECTILE_ENTITY, x, y, z, accelX, accelY, accelZ, world);
    }

    protected ParticleOptions m_5967_() {
        return ParticleTypes.f_123754_;
    }

    protected void m_6532_(HitResult result) {
        if (result.m_6662_() == HitResult.Type.ENTITY) {
            Entity entity = ((EntityHitResult)result).m_82443_();
            if (entity.m_6060_()) {
                entity.m_20095_();
            }
            if (entity.m_6469_(BlizzDamageSource.causeDamage(this, this.m_37282_()), this.getDamage(entity)) && !entity.m_20147_() && entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.m_7292_(new MobEffectInstance(CoreReferences.CHILLED, this.getEffectDuration(entity), this.getEffectAmplifier(entity), false, false));
            }
        }
        if (Utils.isServerWorld((Level)this.f_19853_)) {
            if (effectRadius > 0) {
                AreaUtils.freezeNearbyGround((Entity)this, (Level)this.f_19853_, (BlockPos)this.m_142538_(), (int)effectRadius);
                AreaUtils.freezeSurfaceWater((Entity)this, (Level)this.f_19853_, (BlockPos)this.m_142538_(), (int)effectRadius, (boolean)false);
                AreaUtils.freezeSurfaceLava((Entity)this, (Level)this.f_19853_, (BlockPos)this.m_142538_(), (int)effectRadius, (boolean)false);
                this.makeAreaOfEffectCloud();
            }
            this.f_19853_.m_7605_((Entity)this, (byte)3);
            this.m_146870_();
        }
    }

    private void makeAreaOfEffectCloud() {
        AreaEffectCloud cloud = new AreaEffectCloud(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
        cloud.m_19712_(1.0f);
        cloud.m_19724_((ParticleOptions)CoreReferences.FROST_PARTICLE);
        cloud.m_19734_(20);
        cloud.m_19740_(0);
        cloud.m_19738_(((float)effectRadius - cloud.m_19743_()) / (float)cloud.m_19748_());
        this.f_19853_.m_7967_((Entity)cloud);
    }

    @Override
    public float getDamage(Entity target) {
        return target.m_5825_() ? defaultDamage + 3.0f : defaultDamage;
    }

    @Override
    public int getEffectAmplifier(Entity target) {
        return effectAmplifier;
    }

    @Override
    public int getEffectDuration(Entity target) {
        return effectDuration;
    }

    protected static class BlizzDamageSource
    extends EntityDamageSource {
        public BlizzDamageSource(Entity source) {
            super("blizz", source);
        }

        public static DamageSource causeDamage(BlizzProjectile entityProj, Entity entitySource) {
            return new IndirectEntityDamageSource("blizz", (Entity)entityProj, (Entity)(entitySource == null ? entityProj : entitySource)).m_19366_();
        }
    }
}

