/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.entity.monster;

import cofh.lib.util.references.CoreReferences;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.config.ThermalClientConfig;
import cofh.thermal.core.entity.projectile.BlizzProjectile;
import cofh.thermal.core.init.TCoreSounds;
import cofh.thermal.lib.common.ThermalFlags;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.FrostWalkerEnchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class Blizz
extends Monster {
    private static final EntityDataAccessor<Byte> ANGRY = SynchedEntityData.m_135353_(Blizz.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);

    public static boolean canSpawn(EntityType<Blizz> entityType, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, Random rand) {
        return ThermalFlags.getFlag(ThermalFlags.FLAG_MOB_BLIZZ).getAsBoolean() && Monster.m_33017_(entityType, (ServerLevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (Random)rand);
    }

    public Blizz(EntityType<? extends Blizz> type, Level world) {
        super(type, world);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.f_21344_ = new FlyingPathNavigation((Mob)this, world);
        this.m_21441_(BlockPathTypes.LAVA, -1.0f);
        this.f_21364_ = 10;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(4, (Goal)new BlizzAttackGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22281_, 7.0).m_22268_(Attributes.f_22279_, (double)0.23f).m_22268_(Attributes.f_22280_, (double)0.6f).m_22268_(Attributes.f_22277_, 48.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANGRY, (Object)0);
    }

    protected SoundEvent m_7515_() {
        return ThermalClientConfig.mobAmbientSounds ? TCoreSounds.SOUND_BLIZZ_AMBIENT : null;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return TCoreSounds.SOUND_BLIZZ_HURT;
    }

    protected SoundEvent m_5592_() {
        return TCoreSounds.SOUND_BLIZZ_DEATH;
    }

    public void m_8107_() {
        if (!this.f_19861_ && this.m_20184_().f_82480_ < 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
        }
        if (this.f_19853_.f_46443_ && this.f_19796_.nextInt(2) == 0) {
            this.f_19853_.m_7106_((ParticleOptions)CoreReferences.FROST_PARTICLE, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
        }
        super.m_8107_();
    }

    protected void m_5806_(BlockPos pos) {
        FrostWalkerEnchantment.m_45018_((LivingEntity)this, (Level)this.f_19853_, (BlockPos)pos, (int)1);
        if (this.m_6757_(this.m_20075_())) {
            this.m_21185_();
        }
        this.m_21186_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return super.m_6469_(source, source.m_19384_() ? amount + 3.0f : amount);
    }

    public boolean m_7301_(MobEffectInstance effect) {
        return super.m_7301_(effect) && !effect.m_19544_().equals(CoreReferences.CHILLED);
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)ThermalCore.ITEMS.get("blizz_spawn_egg"));
    }

    public boolean m_6673_(DamageSource source) {
        return source.f_19326_.equals("blizz") || super.m_6673_(source);
    }

    public boolean isAngry() {
        return ((Byte)this.f_19804_.m_135370_(ANGRY) & 1) != 0;
    }

    protected void setAngry(boolean angry) {
        byte b0 = (Byte)this.f_19804_.m_135370_(ANGRY);
        b0 = angry ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(ANGRY, (Object)b0);
    }

    static class BlizzAttackGoal
    extends Goal {
        private final Blizz blizz;
        private final Vec3[] hoverOffsets = BlizzAttackGoal.getHoverOffsets(new Vec3(1.5, 2.25, 0.0), 16);
        private int attackTime;
        private int hoverStep;
        private int chaseStep;

        public BlizzAttackGoal(Blizz blizzIn) {
            this.blizz = blizzIn;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity target = this.blizz.m_5448_();
            return target != null && target.m_6084_() && this.blizz.m_6779_(target);
        }

        public void m_8056_() {
            this.chaseStep = 0;
        }

        public void m_8041_() {
            this.blizz.setAngry(false);
            this.chaseStep = 0;
        }

        public void m_8037_() {
            --this.attackTime;
            LivingEntity target = this.blizz.m_5448_();
            if (target == null) {
                return;
            }
            Vec3 pos = this.blizz.m_20182_();
            Vec3 targetPos = target.m_20299_(0.5f);
            Vec3 diff = pos.m_82546_(targetPos);
            double distSqr = this.blizz.m_20280_((Entity)target);
            double horzDistSqr = diff.m_165925_();
            if (this.blizz.m_21574_().m_148306_((Entity)target) && distSqr < this.getFollowDistance() * this.getFollowDistance()) {
                this.chaseStep = 0;
                this.blizz.m_21563_().m_24960_((Entity)target, 10.0f, 10.0f);
                if (distSqr < 4.0) {
                    if (this.attackTime <= 0) {
                        this.attackTime = 20;
                        this.blizz.m_7327_((Entity)target);
                    }
                } else {
                    if (pos.f_82480_ > target.m_20186_() + 2.0) {
                        this.blizz.setAngry(true);
                        if (this.attackTime <= 0) {
                            this.attackTime = 7;
                            Random rand = this.blizz.m_21187_();
                            Level world = this.blizz.f_19853_;
                            BlizzProjectile projectile = horzDistSqr < 9.0 ? new BlizzProjectile(targetPos.f_82479_ + rand.nextGaussian() * (double)0.8f, pos.f_82480_ - (double)(rand.nextFloat() * 0.5f) - (double)0.2f, targetPos.f_82481_ + rand.nextGaussian() * (double)0.8f, 0.0, -1.0, 0.0, world) : new BlizzProjectile(pos.f_82479_ + rand.nextGaussian() * (double)0.8f, pos.f_82480_ - (double)rand.nextFloat() - (double)0.2f, pos.f_82481_ + rand.nextGaussian() * (double)0.8f, 0.0, -1.0, 0.0, world);
                            projectile.m_5602_((Entity)this.blizz);
                            world.m_7967_((Entity)projectile);
                            ++this.hoverStep;
                            this.hoverStep %= this.hoverOffsets.length;
                        }
                        this.blizz.m_21566_().m_6849_(targetPos.f_82479_ + this.hoverOffsets[this.hoverStep].f_82479_, targetPos.f_82480_ + this.hoverOffsets[this.hoverStep].f_82480_, targetPos.f_82481_ + this.hoverOffsets[this.hoverStep].f_82481_, 1.0);
                        return;
                    }
                    this.blizz.setAngry(false);
                }
            } else {
                this.blizz.setAngry(false);
            }
            if (this.chaseStep < 5) {
                ++this.chaseStep;
                this.blizz.m_21566_().m_6849_(targetPos.f_82479_, targetPos.f_82480_ + this.hoverOffsets[0].f_82480_, targetPos.f_82481_, 1.0);
            }
            super.m_8037_();
        }

        private double getFollowDistance() {
            return this.blizz.m_21133_(Attributes.f_22277_);
        }

        protected static Vec3[] getHoverOffsets(Vec3 start, int steps) {
            float stepRad = (float)Math.PI * 2 / (float)steps;
            Vec3[] offsets = new Vec3[steps];
            for (int i = 0; i < steps; ++i) {
                offsets[i] = start.m_82524_(stepRad * (float)i);
            }
            return offsets;
        }
    }
}

