/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.client.renderer.entity;

import cofh.lib.util.helpers.MathHelper;
import cofh.thermal.core.client.renderer.entity.BasalzProjectileRenderer;
import cofh.thermal.core.client.renderer.entity.model.BasalzModel;
import cofh.thermal.core.client.renderer.entity.model.ElementalProjectileModel;
import cofh.thermal.core.entity.monster.Basalz;
import cofh.thermal.core.entity.projectile.BasalzProjectile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BasalzRenderer
extends MobRenderer<Basalz, BasalzModel<Basalz>> {
    private static final ResourceLocation CALM_TEXTURE = new ResourceLocation("thermal", "textures/entity/basalz.png");
    private static final ResourceLocation ANGRY_TEXTURE = new ResourceLocation("thermal", "textures/entity/basalz_angry.png");
    protected ElementalProjectileModel<BasalzProjectile> projectileModel;

    public BasalzRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, new BasalzModel(ctx.m_174027_().m_171103_(BasalzModel.BASALZ_LAYER)), 0.5f);
        this.projectileModel = new ElementalProjectileModel(ctx.m_174027_().m_171103_(ElementalProjectileModel.PROJECTILE_LAYER));
    }

    public void render(Basalz entity, float entityYaw, float partialTicks, PoseStack poseStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        if (entity.m_6084_()) {
            float scale = 1.0f - MathHelper.clamp((float)(((float)entity.angerTime + partialTicks) / 6.0f), (float)0.0f, (float)1.0f);
            scale = 1.0f - scale * scale * scale;
            if (!entity.isAngry()) {
                scale = 1.0f - scale;
            }
            if (scale > 0.0f) {
                poseStackIn.m_85836_();
                float time = (float)entity.f_19797_ + partialTicks;
                poseStackIn.m_85837_(0.0, (double)(entity.m_20206_() * (0.35f + 0.35f * scale)), 0.0);
                poseStackIn.m_85841_(scale, scale, scale);
                int orbit = entity.getOrbit();
                float inv = 1.0f / (float)orbit;
                Quaternion rot = Vector3f.f_122225_.m_122240_(360.0f * inv);
                poseStackIn.m_85845_(Vector3f.f_122225_.m_122240_(time * Math.max(36.0f * inv, 12.0f)));
                for (int i = 0; i < orbit; ++i) {
                    poseStackIn.m_85836_();
                    float t = time + (float)i;
                    poseStackIn.m_85837_(3.0, (double)(0.5f * MathHelper.sin((float)(time * 0.15708f - (float)i * inv * 6.2832f))), 0.0);
                    poseStackIn.m_85845_(Vector3f.f_122225_.m_122240_(MathHelper.sin((float)(t * 0.1f)) * 180.0f));
                    poseStackIn.m_85845_(Vector3f.f_122223_.m_122240_(MathHelper.cos((float)(t * 0.1f)) * 180.0f));
                    float invScale = 0.5f / scale;
                    poseStackIn.m_85841_(invScale, invScale, invScale);
                    VertexConsumer builder = bufferIn.m_6299_(this.projectileModel.m_103119_(BasalzProjectileRenderer.TEXTURE));
                    this.projectileModel.m_7695_(poseStackIn, builder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.8f);
                    poseStackIn.m_85849_();
                    poseStackIn.m_85845_(rot);
                }
                poseStackIn.m_85849_();
            }
        }
        super.m_7392_((Mob)entity, entityYaw, partialTicks, poseStackIn, bufferIn, packedLightIn);
    }

    protected int getBlockLightLevel(Basalz entityIn, BlockPos pos) {
        return entityIn.isAngry() ? 12 : super.m_6086_((Entity)entityIn, pos);
    }

    public ResourceLocation getTextureLocation(Basalz entity) {
        return entity.isAngry() ? ANGRY_TEXTURE : CALM_TEXTURE;
    }
}

