/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.block.entity.storage;

import cofh.core.client.renderer.model.ModelUtils;
import cofh.core.network.packet.client.TileStatePacket;
import cofh.core.util.helpers.FluidHelper;
import cofh.lib.block.entity.ICoFHTickableTile;
import cofh.lib.block.entity.ITilePacketHandler;
import cofh.lib.fluid.FluidHandlerRestrictionWrapper;
import cofh.lib.fluid.FluidStorageAdjustable;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.util.StorageGroup;
import cofh.lib.util.Utils;
import cofh.lib.util.control.IReconfigurable;
import cofh.lib.util.helpers.AugmentDataHelper;
import cofh.lib.util.helpers.BlockHelper;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.core.init.TCoreReferences;
import cofh.thermal.core.inventory.container.storage.FluidCellContainer;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.tileentity.CellTileBase;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidCellTile
extends CellTileBase
implements ICoFHTickableTile.IServerTickable {
    public static final int BASE_CAPACITY = 32000;
    protected FluidStorageCoFH fluidStorage = new FluidStorageAdjustable(32000, fluid -> this.filter.valid(fluid)).setTransferLimits(() -> this.amountInput, () -> this.amountOutput);
    protected LazyOptional<?> inputFluidCap = LazyOptional.empty();
    protected LazyOptional<?> outputFluidCap = LazyOptional.empty();

    public FluidCellTile(BlockPos pos, BlockState state) {
        super(TCoreReferences.FLUID_CELL_TILE, pos, state);
        this.amountInput = 1000;
        this.amountOutput = 1000;
        this.tankInv.addTank(this.fluidStorage, StorageGroup.ACCESSIBLE);
        this.transferControl.initControl(false, true);
        this.addAugmentSlots(ThermalCoreConfig.storageAugments);
        this.initHandlers();
    }

    public void tickServer() {
        if (this.redstoneControl.getState()) {
            this.transferOut();
            this.transferIn();
        }
        if (Utils.timeCheck() || this.fluidStorage.getFluidStack().getFluid() != this.renderFluid.getFluid()) {
            this.updateTrackers(true);
        }
    }

    public int getLightValue() {
        return FluidHelper.luminosity((FluidStack)this.renderFluid);
    }

    protected void transferIn() {
        int i;
        if (!this.transferControl.getTransferIn()) {
            return;
        }
        if (this.amountInput <= 0 || this.fluidStorage.isFull()) {
            return;
        }
        for (i = this.inputTracker; i < 6 && this.fluidStorage.getSpace() > 0; ++i) {
            if (!this.reconfigControl.getSideConfig(i).isInput()) continue;
            this.attemptTransferIn(Direction.m_122376_((int)i));
        }
        for (i = 0; i < this.inputTracker && this.fluidStorage.getSpace() > 0; ++i) {
            if (!this.reconfigControl.getSideConfig(i).isInput()) continue;
            this.attemptTransferIn(Direction.m_122376_((int)i));
        }
        ++this.inputTracker;
        this.inputTracker %= 6;
    }

    protected void transferOut() {
        int i;
        if (!this.transferControl.getTransferOut()) {
            return;
        }
        if (this.amountOutput <= 0 || this.fluidStorage.isEmpty()) {
            return;
        }
        for (i = this.outputTracker; i < 6 && this.fluidStorage.getAmount() > 0; ++i) {
            if (!this.reconfigControl.getSideConfig(i).isOutput()) continue;
            this.attemptTransferOut(Direction.m_122376_((int)i));
        }
        for (i = 0; i < this.outputTracker && this.fluidStorage.getAmount() > 0; ++i) {
            if (!this.reconfigControl.getSideConfig(i).isOutput()) continue;
            this.attemptTransferOut(Direction.m_122376_((int)i));
        }
        ++this.outputTracker;
        this.outputTracker %= 6;
    }

    protected void attemptTransferIn(Direction side) {
        FluidHelper.extractFromAdjacent((BlockEntity)this, (FluidStorageCoFH)this.fluidStorage, (int)Math.min(this.amountInput, this.fluidStorage.getSpace()), (Direction)side);
    }

    protected void attemptTransferOut(Direction side) {
        BlockEntity adjTile = BlockHelper.getAdjacentTileEntity((BlockEntity)this, (Direction)side);
        if (adjTile != null) {
            Direction opposite = side.m_122424_();
            int maxTransfer = Math.min(this.amountOutput, this.fluidStorage.getAmount());
            adjTile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, opposite).ifPresent(e -> this.fluidStorage.modify(-e.fill(new FluidStack(this.fluidStorage.getFluidStack(), maxTransfer), IFluidHandler.FluidAction.EXECUTE)));
        }
    }

    @Override
    protected boolean keepFluids() {
        return true;
    }

    @Override
    public int getMaxInput() {
        return this.fluidStorage.getCapacity() / 4;
    }

    @Override
    public int getMaxOutput() {
        return this.fluidStorage.getCapacity() / 4;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new FluidCellContainer(i, this.f_58857_, this.f_58858_, inventory, player);
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(ModelUtils.SIDES, (Object)this.reconfigControl().getRawSideConfig()).withInitial(ModelUtils.FACING, (Object)this.reconfigControl.getFacing()).withInitial(ModelUtils.FLUID, (Object)this.renderFluid).withInitial(ModelUtils.LEVEL, (Object)this.levelTracker).build();
    }

    @Override
    protected void updateTrackers(boolean send) {
        int curScale;
        this.prevLight = this.getLightValue();
        this.renderFluid = this.fluidStorage.getFluidStack();
        int n = curScale = this.fluidStorage.getAmount() > 0 ? 1 + (int)(this.fluidStorage.getRatio() * 14.0) : 0;
        if (curScale != this.compareTracker) {
            this.compareTracker = curScale;
            if (send) {
                this.m_6596_();
            }
        }
        if (this.fluidStorage.isCreative()) {
            curScale = this.fluidStorage.isEmpty() ? 10 : 9;
        } else {
            int n2 = curScale = this.fluidStorage.getAmount() > 0 ? 1 + Math.min((int)(this.fluidStorage.getRatio() * 8.0), 7) : 0;
        }
        if (this.levelTracker != curScale) {
            this.levelTracker = curScale;
            if (send) {
                TileStatePacket.sendToClient((ITilePacketHandler)this);
            }
        }
    }

    @Override
    protected Predicate<ItemStack> augValidator() {
        return item -> AugmentDataHelper.hasAugmentData((ItemStack)item) && ThermalAugmentRules.FLUID_STORAGE_VALIDATOR.test((ItemStack)item, this.getAugmentsAsList());
    }

    @Override
    protected void updateHandlers() {
        LazyOptional prevFluidCap = this.fluidCap;
        LazyOptional<?> prevFluidInputCap = this.inputFluidCap;
        LazyOptional<?> prevFluidOutputCap = this.outputFluidCap;
        FluidHandlerRestrictionWrapper inputHandler = new FluidHandlerRestrictionWrapper((IFluidHandler)this.fluidStorage, true, false);
        FluidHandlerRestrictionWrapper outputHandler = new FluidHandlerRestrictionWrapper((IFluidHandler)this.fluidStorage, false, true);
        this.fluidCap = LazyOptional.of(() -> this.fluidStorage);
        this.inputFluidCap = LazyOptional.of(() -> FluidCellTile.lambda$updateHandlers$6((IFluidHandler)inputHandler));
        this.outputFluidCap = LazyOptional.of(() -> FluidCellTile.lambda$updateHandlers$7((IFluidHandler)outputHandler));
        prevFluidCap.invalidate();
        prevFluidInputCap.invalidate();
        prevFluidOutputCap.invalidate();
    }

    @Override
    protected <T> LazyOptional<T> getFluidHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return super.getFluidHandlerCapability(side);
        }
        return switch (this.reconfigControl.getSideConfig(side)) {
            case IReconfigurable.SideConfig.SIDE_NONE -> LazyOptional.empty();
            case IReconfigurable.SideConfig.SIDE_INPUT -> this.inputFluidCap.cast();
            case IReconfigurable.SideConfig.SIDE_OUTPUT -> this.outputFluidCap.cast();
            default -> super.getFluidHandlerCapability(side);
        };
    }

    private static /* synthetic */ IFluidHandler lambda$updateHandlers$7(IFluidHandler outputHandler) {
        return outputHandler;
    }

    private static /* synthetic */ IFluidHandler lambda$updateHandlers$6(IFluidHandler inputHandler) {
        return inputHandler;
    }
}

