/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.time.extension;

import iskallia.vault.VaultMod;
import iskallia.vault.world.vault.time.VaultTimer;
import iskallia.vault.world.vault.time.extension.FallbackExtension;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class TimeExtension
implements INBTSerializable<CompoundTag> {
    public static final Map<ResourceLocation, Supplier<TimeExtension>> REGISTRY = new HashMap<ResourceLocation, Supplier<TimeExtension>>();
    protected ResourceLocation id;
    protected long extraTime;
    protected long executionTime;

    public TimeExtension() {
    }

    public TimeExtension(ResourceLocation id, long extraTime) {
        this.id = id;
        this.extraTime = extraTime;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public long getExtraTime() {
        return this.extraTime;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public void setExecutionTime(long executionTime) {
        this.executionTime = executionTime;
    }

    public void apply(VaultTimer timer) {
        timer.totalTime = (int)((long)timer.totalTime + this.extraTime);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("Id", this.getId().toString());
        nbt.m_128356_("ExtraTime", this.getExtraTime());
        nbt.m_128356_("ExecutionTime", this.getExecutionTime());
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.id = new ResourceLocation(nbt.m_128461_("Id"));
        this.extraTime = nbt.m_128454_("ExtraTime");
        this.executionTime = nbt.m_128454_("ExecutionTime");
    }

    public static TimeExtension fromNBT(CompoundTag nbt) {
        ResourceLocation id = new ResourceLocation(nbt.m_128461_("Id"));
        TimeExtension extension = REGISTRY.getOrDefault(id, () -> null).get();
        if (extension == null) {
            VaultMod.LOGGER.error("Vault time extension <" + id.toString() + "> is not defined, using fallback.");
            return new FallbackExtension(nbt);
        }
        try {
            extension.deserializeNBT(nbt);
        }
        catch (Exception e) {
            e.printStackTrace();
            VaultMod.LOGGER.error("Vault time extension <" + id.toString() + "> could not be deserialized, using fallback.");
            return new FallbackExtension(nbt);
        }
        return extension;
    }
}

