/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.time;

import iskallia.vault.nbt.VListNBT;
import iskallia.vault.world.vault.time.extension.TimeExtension;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;

public class VaultTimer
implements INBTSerializable<CompoundTag> {
    public int startTime;
    public int totalTime;
    public int runTime;
    protected VListNBT<TimeExtension, CompoundTag> extensions = VListNBT.of(TimeExtension::fromNBT);
    protected List<BiConsumer<VaultTimer, TimeExtension>> extensionAddedListeners = new ArrayList<BiConsumer<VaultTimer, TimeExtension>>();
    protected List<BiConsumer<VaultTimer, TimeExtension>> extensionAppliedListeners = new ArrayList<BiConsumer<VaultTimer, TimeExtension>>();

    public int getStartTime() {
        return this.startTime;
    }

    public int getTotalTime() {
        return this.totalTime;
    }

    public int getRunTime() {
        return this.runTime;
    }

    public int getTimeLeft() {
        return this.totalTime - this.runTime;
    }

    public VaultTimer addTime(TimeExtension extension, int delay) {
        extension.setExecutionTime(this.runTime + delay);
        this.extensions.add(extension);
        this.extensionAddedListeners.forEach(listener -> listener.accept(this, extension));
        return this;
    }

    public VaultTimer onExtensionAdded(BiConsumer<VaultTimer, TimeExtension> listener) {
        this.extensionAddedListeners.add(listener);
        return this;
    }

    public VaultTimer onExtensionApplied(BiConsumer<VaultTimer, TimeExtension> listener) {
        this.extensionAppliedListeners.add(listener);
        return this;
    }

    public VaultTimer start(int startTime) {
        this.runTime = 0;
        this.totalTime = this.startTime = startTime;
        return this;
    }

    public void tick() {
        this.extensions.forEach(extension -> {
            if (extension.getExecutionTime() == (long)this.runTime) {
                extension.apply(this);
                this.extensionAppliedListeners.forEach(listener -> listener.accept(this, extension));
            }
        });
        ++this.runTime;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("StartTime", this.startTime);
        nbt.m_128405_("TotalTime", this.totalTime);
        nbt.m_128405_("RunTime", this.runTime);
        nbt.m_128365_("TimeExtensions", (Tag)this.extensions.serializeNBT());
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.startTime = nbt.m_128451_("StartTime");
        this.totalTime = nbt.m_128451_("TotalTime");
        this.runTime = nbt.m_128451_("RunTime");
        this.extensions.deserializeNBT(nbt.m_128437_("TimeExtensions", 10));
    }
}

