/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.player;

import iskallia.vault.VaultMod;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.nbt.VListNBT;
import iskallia.vault.util.PlayerFilter;
import iskallia.vault.world.raid.RaidProperties;
import iskallia.vault.world.vault.VaultRaid;
import iskallia.vault.world.vault.logic.behaviour.VaultBehaviour;
import iskallia.vault.world.vault.logic.objective.VaultObjective;
import iskallia.vault.world.vault.modifier.VaultModifiers;
import iskallia.vault.world.vault.time.VaultTimer;
import iskallia.vault.world.vault.time.extension.TimeExtension;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.network.NetworkDirection;

public abstract class VaultPlayer
implements INBTSerializable<CompoundTag> {
    public static final Map<ResourceLocation, Supplier<VaultPlayer>> REGISTRY = new HashMap<ResourceLocation, Supplier<VaultPlayer>>();
    private ResourceLocation id;
    protected UUID playerId;
    protected boolean exited;
    protected VaultTimer timer = this.createTimer();
    protected VListNBT<TimeExtension, CompoundTag> addedExtensions = VListNBT.of(TimeExtension::fromNBT);
    protected VListNBT<TimeExtension, CompoundTag> appliedExtensions = VListNBT.of(TimeExtension::fromNBT);
    protected VaultModifiers modifiers = new VaultModifiers();
    protected RaidProperties properties = new RaidProperties();
    protected VListNBT<VaultBehaviour, CompoundTag> behaviours = VListNBT.of(VaultBehaviour::fromNBT);
    protected VListNBT<VaultObjective, CompoundTag> objectives = VListNBT.of(VaultObjective::fromNBT);

    public VaultPlayer() {
    }

    public VaultPlayer(ResourceLocation id, UUID playerId) {
        this.id = id;
        this.playerId = playerId;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public boolean hasExited() {
        return this.exited;
    }

    public VaultTimer getTimer() {
        return this.timer;
    }

    public VaultModifiers getModifiers() {
        return this.modifiers;
    }

    public RaidProperties getProperties() {
        return this.properties;
    }

    public List<VaultBehaviour> getBehaviours() {
        return this.behaviours;
    }

    public List<VaultObjective> getObjectives() {
        return this.objectives.stream().filter(objective -> !objective.isCompleted()).collect(Collectors.toList());
    }

    public List<VaultObjective> getAllObjectives() {
        return this.objectives;
    }

    public <T extends VaultObjective> Optional<T> getActiveObjective(Class<T> objectiveClass) {
        return this.getAllObjectives().stream().filter(objective -> !objective.isCompleted()).filter(objective -> objectiveClass.isAssignableFrom(objective.getClass())).findFirst().map(vaultObjective -> vaultObjective);
    }

    public void exit() {
        this.exited = true;
    }

    public VaultTimer createTimer() {
        return new VaultTimer().onExtensionAdded((timer, extension) -> this.addedExtensions.add((TimeExtension)extension)).onExtensionApplied((timer, extension) -> this.appliedExtensions.add((TimeExtension)extension));
    }

    public void tick(VaultRaid vault, ServerLevel world) {
        if (this.hasExited()) {
            return;
        }
        this.getModifiers().tick(vault, world, PlayerFilter.of(this));
        MinecraftServer srv = world.m_142572_();
        if (vault.getActiveObjectives().stream().noneMatch(objective -> objective.shouldPauseTimer(srv, vault))) {
            this.tickTimer(vault, world, this.getTimer());
        }
        this.tickObjectiveUpdates(vault, world);
        this.getBehaviours().forEach(completion -> {
            if (!this.hasExited()) {
                completion.tick(vault, this, world);
            }
        });
        if (this.hasExited()) {
            return;
        }
        this.getAllObjectives().stream().filter(objective -> objective.isCompleted() && objective.getCompletionTime() < 0).peek(objective -> objective.setCompletionTime(this.getTimer().getRunTime())).forEach(objective -> objective.complete(vault, this, world));
        this.getObjectives().forEach(objective -> objective.tick(vault, PlayerFilter.of(this), world));
    }

    public abstract void tickTimer(VaultRaid var1, ServerLevel var2, VaultTimer var3);

    public abstract void tickObjectiveUpdates(VaultRaid var1, ServerLevel var2);

    public Optional<ServerPlayer> getServerPlayer(MinecraftServer srv) {
        return Optional.ofNullable(srv.m_6846_().m_11259_(this.getPlayerId()));
    }

    public boolean isOnline(MinecraftServer srv) {
        return this.getServerPlayer(srv).isPresent();
    }

    public void runIfPresent(MinecraftServer server, Consumer<ServerPlayer> action) {
        this.getServerPlayer(server).ifPresent(action::accept);
    }

    public void sendIfPresent(MinecraftServer server, Object message) {
        this.runIfPresent(server, playerEntity -> {
            if (playerEntity.f_19853_.m_46472_() != VaultMod.ARENA_KEY) {
                ModNetwork.CHANNEL.sendTo(message, playerEntity.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
        });
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("Id", this.getId().toString());
        nbt.m_128359_("PlayerId", this.getPlayerId().toString());
        nbt.m_128379_("Exited", this.hasExited());
        nbt.m_128365_("Timer", (Tag)this.timer.serializeNBT());
        nbt.m_128365_("AddedExtensions", (Tag)this.addedExtensions.serializeNBT());
        nbt.m_128365_("AppliedExtensions", (Tag)this.appliedExtensions.serializeNBT());
        nbt.m_128365_("Modifiers", (Tag)this.modifiers.serializeNBT());
        nbt.m_128365_("Properties", (Tag)this.properties.serializeNBT());
        nbt.m_128365_("Behaviours", (Tag)this.behaviours.serializeNBT());
        nbt.m_128365_("Objectives", (Tag)this.objectives.serializeNBT());
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.id = new ResourceLocation(nbt.m_128461_("Id"));
        this.playerId = UUID.fromString(nbt.m_128461_("PlayerId"));
        this.exited = nbt.m_128471_("Exited");
        this.timer = this.createTimer();
        this.timer.deserializeNBT(nbt.m_128469_("Timer"));
        this.addedExtensions.deserializeNBT(nbt.m_128437_("AddedExtensions", 10));
        this.appliedExtensions.deserializeNBT(nbt.m_128437_("AppliedExtensions", 10));
        this.modifiers.deserializeNBT(nbt.m_128469_("Modifiers"));
        this.properties.deserializeNBT(nbt.m_128469_("Properties"));
        this.behaviours.deserializeNBT(nbt.m_128437_("Behaviours", 10));
        this.objectives.deserializeNBT(nbt.m_128437_("Objectives", 10));
    }

    public static VaultPlayer fromNBT(CompoundTag nbt) {
        ResourceLocation id = new ResourceLocation(nbt.m_128461_("Id"));
        VaultPlayer player = REGISTRY.getOrDefault(id, () -> null).get();
        if (player == null) {
            VaultMod.LOGGER.error("Player <" + id + "> is not defined.");
            return null;
        }
        try {
            player.deserializeNBT(nbt);
        }
        catch (Exception e) {
            VaultMod.LOGGER.error("Player <" + id + "> with uuid <" + nbt.m_128461_("PlayerId") + "> could not be deserialized.");
            throw e;
        }
        return player;
    }
}

