/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.modifier.spi;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import iskallia.vault.world.vault.modifier.spi.IVaultModifierBehaviorApply;
import iskallia.vault.world.vault.modifier.spi.IVaultModifierTextFormatter;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public abstract class VaultModifier<P>
implements IVaultModifierBehaviorApply {
    private final ResourceLocation id;
    @Expose(deserialize=false)
    @SerializedName(value="properties")
    protected final P properties;
    @Expose(deserialize=false)
    @SerializedName(value="display")
    protected final Display display;
    protected IVaultModifierTextFormatter<P> nameFormatter;
    protected IVaultModifierTextFormatter<P> descriptionFormatter;

    public VaultModifier(ResourceLocation id, P properties, Display display) {
        this.id = id;
        this.properties = properties;
        this.display = display;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public P properties() {
        return this.properties;
    }

    public String getDisplayName() {
        return this.display.getName();
    }

    protected void setNameFormatter(@Nonnull IVaultModifierTextFormatter<P> nameFormatter) {
        this.nameFormatter = nameFormatter;
    }

    public String getDisplayNameFormatted(int modifierStackSize) {
        return Optional.ofNullable(this.nameFormatter).map(formatter -> formatter.format(this.getDisplayName(), this.properties, modifierStackSize)).orElse(this.getDisplayName());
    }

    public TextColor getDisplayTextColor() {
        return this.display.getTextColor();
    }

    public String getDisplayDescription() {
        return this.display.getDescription();
    }

    protected void setDescriptionFormatter(IVaultModifierTextFormatter<P> descriptionFormatter) {
        this.descriptionFormatter = descriptionFormatter;
    }

    public String getDisplayDescriptionFormatted(int modifierStackSize) {
        return this.display.getDescriptionFormatted().map(descriptionFormatted -> Optional.ofNullable(this.descriptionFormatter).map(formatter -> formatter.format((String)descriptionFormatted, this.properties, modifierStackSize)).orElse((String)descriptionFormatted)).orElse(this.getDisplayDescription());
    }

    public Optional<ResourceLocation> getIcon() {
        return this.display.getIcon();
    }

    public Component getNameComponent() {
        HoverEvent hover = new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent(this.getDisplayDescription()));
        return new TextComponent(this.getDisplayName()).m_6270_(Style.f_131099_.m_131148_(this.getDisplayTextColor()).m_131144_(hover));
    }

    public Component getNameComponentFormatted(int modifierStackSize) {
        HoverEvent hover = new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent(this.getDisplayDescriptionFormatted(modifierStackSize)));
        return new TextComponent(this.getDisplayNameFormatted(modifierStackSize)).m_6270_(Style.f_131099_.m_131148_(this.getDisplayTextColor()).m_131144_(hover));
    }

    public static class Display {
        @Expose
        private final String name;
        @Expose
        private final TextColor color;
        @Expose
        private final String description;
        @Expose
        private final String descriptionFormatted;
        @Expose
        private final ResourceLocation icon;

        public Display(String name, TextColor color, String description) {
            this(name, color, description, null, null);
        }

        public Display(String name, TextColor color, String description, @Nullable ResourceLocation icon) {
            this(name, color, description, null, icon);
        }

        public Display(String name, TextColor color, String description, @Nullable String descriptionFormatted) {
            this(name, color, description, descriptionFormatted, null);
        }

        public Display(String name, TextColor color, String description, @Nullable String descriptionFormatted, @Nullable ResourceLocation icon) {
            this.name = name;
            this.color = color;
            this.description = description;
            this.descriptionFormatted = descriptionFormatted;
            this.icon = icon;
        }

        public String getName() {
            return this.name;
        }

        public TextColor getTextColor() {
            return this.color;
        }

        public String getDescription() {
            return this.description;
        }

        public Optional<String> getDescriptionFormatted() {
            return Optional.ofNullable(this.descriptionFormatted);
        }

        public Optional<ResourceLocation> getIcon() {
            return Optional.ofNullable(this.icon);
        }
    }
}

