/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.modifier.modifier;

import com.google.gson.annotations.Expose;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.DeathObjective;
import iskallia.vault.core.vault.player.Completion;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.world.data.PhoenixModifierSnapshotData;
import iskallia.vault.world.vault.modifier.spi.ModifierContext;
import iskallia.vault.world.vault.modifier.spi.VaultModifier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlayerInventoryRestoreModifier
extends VaultModifier<Properties> {
    private static final String RESTORE_FLAG = "the_vault_restore_inventory";

    public PlayerInventoryRestoreModifier(ResourceLocation id, Properties properties, VaultModifier.Display display) {
        super(id, properties, display);
    }

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (!player.m_6084_() || !(player.f_19853_ instanceof ServerLevel)) {
            return;
        }
        if (!player.m_19880_().contains(RESTORE_FLAG)) {
            return;
        }
        ServerLevel world = (ServerLevel)event.player.f_19853_;
        PhoenixModifierSnapshotData data = PhoenixModifierSnapshotData.get(world);
        if (data.hasSnapshot(player)) {
            data.restoreSnapshot(player);
        }
        player.m_20137_(RESTORE_FLAG);
    }

    @Override
    public void onListenerAdd(VirtualWorld world, Vault vault, ModifierContext context, Listener listener) {
        listener.getPlayer().ifPresent(player -> {
            PhoenixModifierSnapshotData snapshotData = PhoenixModifierSnapshotData.get(player.m_183503_());
            if (snapshotData.hasSnapshot((Player)player)) {
                snapshotData.removeSnapshot((Player)player);
            }
            snapshotData.createSnapshot((Player)player);
        });
    }

    @Override
    public void onListenerRemove(VirtualWorld world, Vault vault, ModifierContext context, Listener listener) {
        listener.getPlayer().ifPresent(player -> {
            PhoenixModifierSnapshotData snapshotData = PhoenixModifierSnapshotData.get(player.m_183503_());
            if (snapshotData.hasSnapshot(player.m_142081_())) {
                if (player.m_21224_()) {
                    player.m_19880_().add(RESTORE_FLAG);
                } else {
                    snapshotData.removeSnapshot(player.m_142081_());
                }
            }
        });
        vault.ifPresent(Vault.STATS, stats -> {
            StatCollector statCollector = stats.get(listener);
            if (statCollector == null || statCollector.getCompletion() != Completion.FAILED) {
                return;
            }
            statCollector.modify(StatCollector.EXP_MULTIPLIER, m -> Float.valueOf(m.floatValue() * ((Properties)this.properties).experienceMultiplierOnDeath()));
        });
    }

    @Override
    public void onVaultAdd(VirtualWorld world, Vault vault, ModifierContext context) {
        vault.ifPresent(Vault.OBJECTIVES, objectives -> objectives.forEach(DeathObjective.class, deathObjective -> {
            deathObjective.modify(DeathObjective.KILL_ALL_STACK, i -> i + 1);
            return false;
        }));
    }

    @Override
    public void onVaultRemove(VirtualWorld world, Vault vault, ModifierContext context) {
        vault.ifPresent(Vault.OBJECTIVES, objectives -> objectives.forEach(DeathObjective.class, deathObjective -> {
            deathObjective.modify(DeathObjective.KILL_ALL_STACK, i -> i - 1);
            return false;
        }));
    }

    public static class Properties {
        @Expose
        private final boolean preventsArtifact;
        @Expose
        private final float experienceMultiplierOnDeath;
        @Expose
        private final float experienceMultiplierOnSuccess;

        public Properties(boolean preventsArtifact, float experienceMultiplierOnDeath, float experienceMultiplierOnSuccess) {
            this.preventsArtifact = preventsArtifact;
            this.experienceMultiplierOnDeath = experienceMultiplierOnDeath;
            this.experienceMultiplierOnSuccess = experienceMultiplierOnSuccess;
        }

        public boolean preventsArtifact() {
            return this.preventsArtifact;
        }

        public float experienceMultiplierOnDeath() {
            return this.experienceMultiplierOnDeath;
        }

        public float experienceMultiplierOnSuccess() {
            return this.experienceMultiplierOnSuccess;
        }
    }
}

