/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.modifier.modifier;

import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.world.data.ServerVaults;
import iskallia.vault.world.vault.modifier.spi.EntityAttributeModifier;
import iskallia.vault.world.vault.modifier.spi.ModifierContext;
import iskallia.vault.world.vault.modifier.spi.VaultModifier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

public class PlayerAttributeModifier
extends EntityAttributeModifier<EntityAttributeModifier.Properties> {
    public PlayerAttributeModifier(ResourceLocation id, EntityAttributeModifier.Properties properties, VaultModifier.Display display) {
        super(id, properties, display);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault, ModifierContext context) {
        CommonEvents.PLAYER_TICK.at(TickEvent.Phase.START).register(context.getUUID(), event -> {
            if (!vault.get(Vault.LISTENERS).contains(event.player.m_142081_()) || event.player.m_20194_() == null || event.player.m_183503_().m_46467_() % 10L != 0L) {
                return;
            }
            Player player = event.player;
            synchronized (player) {
                this.applyToEntity((LivingEntity)event.player, context.getUUID());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void on(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.CLIENT || event.player.m_183503_().m_46467_() % 10L != 0L || ServerVaults.isInVault((Entity)event.player)) {
            return;
        }
        Player player = event.player;
        synchronized (player) {
            this.removeFromEntity((LivingEntity)event.player);
        }
    }
}

