/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.modifier.modifier;

import com.google.gson.annotations.Expose;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.util.calc.GrantedEffectHelper;
import iskallia.vault.world.vault.modifier.spi.ModifierContext;
import iskallia.vault.world.vault.modifier.spi.VaultModifier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class MobCurseOnHitModifier
extends VaultModifier<Properties> {
    public MobCurseOnHitModifier(ResourceLocation id, Properties properties, VaultModifier.Display display) {
        super(id, properties, display);
        this.setDescriptionFormatter((t, p, s) -> t.formatted((int)Math.abs(p.onHitApplyChance * (float)s * 100.0f)));
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault, ModifierContext context) {
        CommonEvents.ENTITY_DAMAGE.register(context.getUUID(), event -> {
            LivingEntity patt1252$temp = event.getEntityLiving();
            if (!(patt1252$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt1252$temp;
            if (!(event.getSource().m_7639_() instanceof LivingEntity)) {
                return;
            }
            if (!vault.get(Vault.LISTENERS).contains(player.m_142081_())) {
                return;
            }
            if (world.f_46441_.nextFloat() >= ((Properties)this.properties).onHitApplyChance) {
                return;
            }
            MobEffect effect = ((Properties)this.properties).getEffect();
            if (GrantedEffectHelper.hasImmunity((LivingEntity)player, effect)) {
                return;
            }
            int grantedAmplifier = GrantedEffectHelper.getEffectData((Player)player, player.m_183503_(), effect);
            int amplifier = grantedAmplifier + ((Properties)this.properties).effectAmplifier + 1;
            player.m_7292_(new MobEffectInstance(effect, ((Properties)this.properties).effectDurationTicks, amplifier, true, false));
        });
    }

    public static class Properties {
        @Expose
        private final MobEffect effect;
        @Expose
        private final int effectAmplifier;
        @Expose
        private final int effectDurationTicks;
        @Expose
        private final float onHitApplyChance;

        public Properties(MobEffect effect, int effectAmplifier, int effectDurationTicks, float onHitApplyChance) {
            this.effect = effect;
            this.effectAmplifier = effectAmplifier;
            this.effectDurationTicks = effectDurationTicks;
            this.onHitApplyChance = onHitApplyChance;
        }

        public MobEffect getEffect() {
            return this.effect;
        }

        public int getEffectAmplifier() {
            return this.effectAmplifier;
        }

        public int getEffectDurationTicks() {
            return this.effectDurationTicks;
        }

        public float getOnHitApplyChance() {
            return this.onHitApplyChance;
        }
    }
}

