/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.modifier.modifier;

import com.google.gson.annotations.Expose;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.LootGenerationEvent;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.world.loot.generator.LootGenerator;
import iskallia.vault.core.world.loot.generator.TieredLootTableGenerator;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.world.vault.modifier.spi.ModifierContext;
import iskallia.vault.world.vault.modifier.spi.VaultModifier;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;

public class LootItemRarityModifier
extends VaultModifier<Properties> {
    public LootItemRarityModifier(ResourceLocation id, Properties properties, VaultModifier.Display display) {
        super(id, properties, display);
        this.setDescriptionFormatter((t, p, s) -> t.formatted((int)Math.abs(p.getPercentage() * (double)s * 100.0)));
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault, ModifierContext context) {
        CommonEvents.LOOT_GENERATION.pre().register(context.getUUID(), data -> this.getGenerator(vault, (LootGenerationEvent.Data)data).ifPresent(generator -> {
            generator.itemRarity = (float)((double)generator.itemRarity + ((Properties)this.properties).percentage);
        }));
        CommonEvents.LOOT_GENERATION.post().register(context.getUUID(), data -> this.getGenerator(vault, (LootGenerationEvent.Data)data).ifPresent(generator -> {
            generator.itemRarity = (float)((double)generator.itemRarity - ((Properties)this.properties).percentage);
        }));
    }

    public Optional<TieredLootTableGenerator> getGenerator(Vault vault, LootGenerationEvent.Data data) {
        LootGenerator lootGenerator = data.getGenerator();
        if (!(lootGenerator instanceof TieredLootTableGenerator)) {
            return Optional.empty();
        }
        TieredLootTableGenerator generator = (TieredLootTableGenerator)lootGenerator;
        if (generator.source == null) {
            return Optional.empty();
        }
        if (!vault.get(Vault.LISTENERS).contains(generator.source.m_142081_())) {
            return Optional.empty();
        }
        return Optional.of(generator);
    }

    public static class Properties {
        @Expose
        private final double percentage;

        public Properties(double percentage) {
            this.percentage = percentage;
        }

        public double getPercentage() {
            return this.percentage;
        }
    }
}

