/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.modifier;

import iskallia.vault.util.PlayerFilter;
import iskallia.vault.world.vault.VaultRaid;
import iskallia.vault.world.vault.modifier.VaultModifierStack;
import iskallia.vault.world.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.world.vault.modifier.spi.IVaultModifierBehaviorTick;
import iskallia.vault.world.vault.modifier.spi.IVaultModifierStack;
import iskallia.vault.world.vault.modifier.spi.VaultModifier;
import iskallia.vault.world.vault.player.VaultPlayer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.common.util.INBTSerializable;

public class VaultModifiers
implements INBTSerializable<CompoundTag> {
    private final ActiveModifiers activeModifiers = new ActiveModifiers();
    private final List<VaultModifierTimer> modifierTimers = new ArrayList<VaultModifierTimer>();
    private boolean initialized;
    private static final String TAG_MODIFIERS = "modifiers";
    private static final String TAG_TIMERS = "timers";
    private static final String TAG_INITIALIZED = "initialized";

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized() {
        this.initialized = true;
    }

    public void apply(VaultRaid vault, VaultPlayer player, ServerLevel world, Random random) {
        this.activeModifiers.forEach((IVaultModifierStack modifierStack) -> {});
    }

    public void tick(VaultRaid vault, ServerLevel world, PlayerFilter applyFilter) {
        this.activeModifiers.removeIf(modifierStack -> {
            if (modifierStack.isEmpty()) {
                return true;
            }
            VaultModifier<?> modifier = modifierStack.getModifier();
            if (modifier instanceof IVaultModifierBehaviorTick) {
                IVaultModifierBehaviorTick tickBehavior = (IVaultModifierBehaviorTick)((Object)modifier);
                vault.getPlayers().forEach((? super T vaultPlayer) -> {
                    if (applyFilter.test(vaultPlayer.getPlayerId())) {
                        tickBehavior.tick(vault, (VaultPlayer)vaultPlayer, world, modifierStack.getSize());
                    }
                });
            }
            return false;
        });
        this.modifierTimers.removeIf(modifierTimer -> {
            VaultModifierStack modifierStack = this.activeModifiers.get(modifierTimer.getId());
            if (modifierStack == null) {
                return true;
            }
            VaultModifier<?> modifier = modifierStack.getModifier();
            if (modifierTimer.tick()) {
                MutableComponent removalMsg = new TextComponent("Modifier ").m_130940_(ChatFormatting.GRAY).m_7220_(modifier.getNameComponent()).m_7220_((Component)new TextComponent(" expired.").m_130940_(ChatFormatting.GRAY));
                vault.getPlayers().forEach(arg_0 -> VaultModifiers.lambda$tick$4(applyFilter, world, (Component)removalMsg, arg_0));
                if (modifierStack.shrink(1).isEmpty()) {
                    this.activeModifiers.remove(modifier);
                }
                return true;
            }
            return false;
        });
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_(TAG_MODIFIERS, (Tag)this.activeModifiers.serializeNBT());
        ListTag timerList = new ListTag();
        this.modifierTimers.forEach((? super T modifierTimer) -> timerList.add((Object)modifierTimer.serializeNBT()));
        nbt.m_128365_(TAG_TIMERS, (Tag)timerList);
        nbt.m_128379_(TAG_INITIALIZED, this.isInitialized());
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.activeModifiers.deserializeNBT(nbt.m_128437_(TAG_MODIFIERS, 10));
        this.modifierTimers.clear();
        ListTag timerList = nbt.m_128437_(TAG_TIMERS, 10);
        for (int i = 0; i < timerList.size(); ++i) {
            VaultModifierTimer.deserializeNBT(timerList.m_128728_(i)).ifPresent(this.modifierTimers::add);
        }
        this.initialized = nbt.m_128471_(TAG_INITIALIZED);
    }

    public void encode(FriendlyByteBuf buffer) {
        this.activeModifiers.encode(buffer);
        buffer.writeInt(this.modifierTimers.size());
        this.modifierTimers.forEach((? super T modifierTimer) -> modifierTimer.encode(buffer));
    }

    public static VaultModifiers decode(FriendlyByteBuf buffer) {
        VaultModifiers result = new VaultModifiers();
        result.activeModifiers.decode(buffer);
        int timerCount = buffer.readInt();
        for (int i = 0; i < timerCount; ++i) {
            VaultModifierTimer.decode(buffer).ifPresent(result.modifierTimers::add);
        }
        return result;
    }

    public <T extends VaultModifier<?>> Stream<ActiveModifierStack<T>> stream(Class<T> modifierClass) {
        return this.stream().filter(activeModifierStack -> modifierClass.isAssignableFrom(activeModifierStack.getModifier().getClass())).map(activeModifierStack -> (ActiveModifierStack)activeModifierStack);
    }

    public Stream<IVaultModifierStack> stream() {
        return this.activeModifiers.stream();
    }

    public List<IVaultModifierStack> getModifiers() {
        return this.activeModifiers.getModifiers();
    }

    public void forEach(BiConsumer<Integer, IVaultModifierStack> consumer) {
        int index = 0;
        for (IVaultModifierStack modifierStack : this.getModifiers()) {
            consumer.accept(index, modifierStack);
            ++index;
        }
    }

    public int size() {
        return this.activeModifiers.size();
    }

    public boolean isEmpty() {
        return this.size() <= 0;
    }

    public void addPermanentModifier(VaultModifierStack modifierStack) {
        this.addPermanentModifier(modifierStack.getModifier(), modifierStack.getSize());
    }

    public void addPermanentModifier(ResourceLocation id, int stackSize) {
        VaultModifierRegistry.getOpt(id).ifPresent(vaultModifier -> this.addPermanentModifier((VaultModifier<?>)vaultModifier, stackSize));
    }

    public void addPermanentModifier(VaultModifier<?> modifier, int stackSize) {
        this.activeModifiers.add(modifier, stackSize);
    }

    public void addPermanentModifiers(Collection<VaultModifierStack> modifierStacks) {
        this.activeModifiers.add(modifierStacks);
    }

    public void addTemporaryModifier(VaultModifier<?> modifier, int stackSize, int durationTicks) {
        this.addPermanentModifier(modifier, stackSize);
        if (durationTicks > 0) {
            for (int i = 0; i < stackSize; ++i) {
                this.modifierTimers.add(new VaultModifierTimer(modifier.getId(), durationTicks));
            }
        }
    }

    private static /* synthetic */ void lambda$tick$4(PlayerFilter applyFilter, ServerLevel world, Component removalMsg, VaultPlayer vaultPlayer) {
        if (applyFilter.test(vaultPlayer.getPlayerId())) {
            vaultPlayer.runIfPresent(world.m_142572_(), serverPlayer -> serverPlayer.m_6352_(removalMsg, Util.f_137441_));
        }
    }

    private static class ActiveModifiers
    implements INBTSerializable<ListTag> {
        private final Map<ResourceLocation, VaultModifierStack> activeModifierMap = new HashMap<ResourceLocation, VaultModifierStack>();
        private final List<IVaultModifierStack> activeModifierList = new ArrayList<IVaultModifierStack>();
        private final List<IVaultModifierStack> unmodifiableActiveModifierList = Collections.unmodifiableList(this.activeModifierList);

        public VaultModifierStack get(ResourceLocation id) {
            return this.activeModifierMap.get(id);
        }

        public boolean removeIf(Predicate<IVaultModifierStack> filter) {
            if (this.activeModifierList.removeIf(filter)) {
                this.activeModifierMap.entrySet().removeIf((? super E entry) -> filter.test((IVaultModifierStack)entry.getValue()));
                return true;
            }
            return false;
        }

        public void forEach(Consumer<IVaultModifierStack> action) {
            this.activeModifierList.forEach(action);
        }

        public void remove(VaultModifier<?> modifier) {
            this.activeModifierMap.remove(modifier.getId());
            this.activeModifierList.removeIf((? super E vaultModifierStack) -> vaultModifierStack.getModifier() == modifier);
        }

        public void add(Collection<VaultModifierStack> vaultModifierStacks) {
            for (VaultModifierStack vaultModifierStack : vaultModifierStacks) {
                VaultModifier<?> modifier = vaultModifierStack.getModifier();
                this.activeModifierMap.computeIfAbsent(modifier.getId(), resourceLocation -> VaultModifierStack.of(modifier, 1)).grow(vaultModifierStack.getSize() - 1);
            }
            this.updateModifierList();
        }

        public void add(VaultModifier<?> modifier, int stackSize) {
            this.activeModifierMap.computeIfAbsent(modifier.getId(), resourceLocation -> VaultModifierStack.of(modifier, 1)).grow(stackSize - 1);
            this.updateModifierList();
        }

        public int size() {
            return this.activeModifierMap.size();
        }

        public Stream<IVaultModifierStack> stream() {
            return this.getModifiers().stream();
        }

        public List<IVaultModifierStack> getModifiers() {
            return this.unmodifiableActiveModifierList;
        }

        public ListTag serializeNBT() {
            ListTag modifiersList = new ListTag();
            this.activeModifierMap.values().forEach((? super T modifierStack) -> modifiersList.add((Object)modifierStack.serializeNBT()));
            return modifiersList;
        }

        public void deserializeNBT(ListTag modifierList) {
            this.activeModifierMap.clear();
            this.activeModifierList.clear();
            for (int i = 0; i < modifierList.size(); ++i) {
                VaultModifierStack modifierStack = VaultModifierStack.of(modifierList.m_128728_(i));
                if (modifierStack.isEmpty()) continue;
                this.activeModifierMap.put(modifierStack.getModifierId(), modifierStack);
                this.activeModifierList.add(ActiveModifierStack.of(modifierStack));
            }
            this.updateModifierList();
        }

        public void encode(FriendlyByteBuf buffer) {
            buffer.writeInt(this.activeModifierMap.size());
            this.activeModifierMap.values().forEach((? super T modifierStack) -> modifierStack.encode(buffer));
        }

        public void decode(FriendlyByteBuf buffer) {
            this.activeModifierMap.clear();
            this.activeModifierList.clear();
            ActiveModifiers result = new ActiveModifiers();
            int modifierCount = buffer.readInt();
            for (int i = 0; i < modifierCount; ++i) {
                VaultModifierStack modifierStack = VaultModifierStack.decode(buffer);
                if (modifierStack.isEmpty()) continue;
                result.activeModifierMap.put(modifierStack.getModifierId(), modifierStack);
                result.activeModifierList.add(ActiveModifierStack.of(modifierStack));
            }
            result.updateModifierList();
        }

        private void updateModifierList() {
            this.activeModifierList.clear();
            this.activeModifierList.addAll(this.activeModifierMap.values());
            this.sortModifierList();
        }

        private void sortModifierList() {
            this.activeModifierList.sort(Comparator.comparing(IVaultModifierStack::getSize).reversed());
        }
    }

    private static class VaultModifierTimer {
        private static final String TAG_ID = "id";
        private static final String TAG_DURATION_TICKS = "durationTicks";
        private final ResourceLocation id;
        private int durationTicks;

        private VaultModifierTimer(ResourceLocation id, int durationTicks) {
            this.id = id;
            this.durationTicks = durationTicks;
        }

        private ResourceLocation getId() {
            return this.id;
        }

        private boolean tick() {
            if (this.durationTicks < 0) {
                return false;
            }
            --this.durationTicks;
            return this.durationTicks == 0;
        }

        private CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_(TAG_ID, this.id.toString());
            tag.m_128405_(TAG_DURATION_TICKS, this.durationTicks);
            return tag;
        }

        private static Optional<VaultModifierTimer> deserializeNBT(CompoundTag tag) {
            return VaultModifierRegistry.getOpt(new ResourceLocation(tag.m_128461_(TAG_ID))).map(vaultModifier -> new VaultModifierTimer(vaultModifier.getId(), tag.m_128451_(TAG_DURATION_TICKS)));
        }

        private void encode(FriendlyByteBuf buffer) {
            buffer.m_130085_(this.id);
            buffer.writeInt(this.durationTicks);
        }

        private static Optional<VaultModifierTimer> decode(FriendlyByteBuf buffer) {
            ResourceLocation resourceLocation = buffer.m_130281_();
            int durationTicks = buffer.readInt();
            return VaultModifierRegistry.getOpt(resourceLocation).map(vaultModifier -> new VaultModifierTimer(resourceLocation, durationTicks));
        }
    }

    public static class ActiveModifierStack<T extends VaultModifier<?>>
    implements IVaultModifierStack {
        private final IVaultModifierStack vaultModifierStack;

        public static <T extends VaultModifier<?>> ActiveModifierStack<T> of(IVaultModifierStack vaultModifierStack) {
            return new ActiveModifierStack<T>(vaultModifierStack);
        }

        private ActiveModifierStack(IVaultModifierStack vaultModifierStack) {
            this.vaultModifierStack = vaultModifierStack;
        }

        public T getModifier() {
            return (T)this.vaultModifierStack.getModifier();
        }

        @Override
        public ResourceLocation getModifierId() {
            return this.vaultModifierStack.getModifierId();
        }

        @Override
        public int getSize() {
            return this.vaultModifierStack.getSize();
        }

        @Override
        public boolean isEmpty() {
            return this.vaultModifierStack.isEmpty();
        }
    }
}

