/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.logic.objective.raid.modifier;

import com.google.gson.annotations.Expose;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.world.vault.VaultRaid;
import iskallia.vault.world.vault.logic.objective.raid.ActiveRaid;
import iskallia.vault.world.vault.logic.objective.raid.modifier.RaidModifier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class BlockPlacementModifier
extends RaidModifier {
    @Expose
    private final String block;
    @Expose
    private final int blocksToSpawn;
    @Expose
    private final String blockDescription;

    public BlockPlacementModifier(String name, Block block, int blocksToSpawn, String blockDescription) {
        this(name, block.getRegistryName().toString(), blocksToSpawn, blockDescription);
    }

    public BlockPlacementModifier(String name, String block, int blocksToSpawn, String blockDescription) {
        super(false, true, name);
        this.block = block;
        this.blocksToSpawn = blocksToSpawn;
        this.blockDescription = blockDescription;
    }

    @Override
    public void affectRaidMob(Mob mob, float value) {
    }

    @Override
    public void onVaultRaidFinish(VaultRaid vault, ServerLevel world, BlockPos controller, ActiveRaid raid, float value) {
        BlockState placementState = Registry.f_122824_.m_6612_(new ResourceLocation(this.block)).orElse(Blocks.f_50016_).m_49966_();
        int toPlace = this.blocksToSpawn * Math.round(value);
        AABB placementBox = raid.getRaidBoundingBox();
        for (int i = 0; i < toPlace; ++i) {
            BlockPos at;
            while (!world.m_46859_(at = MiscUtils.getRandomPos(placementBox, rand)) || !world.m_8055_(at.m_7495_()).m_60783_((BlockGetter)world, at, Direction.UP)) {
            }
            world.m_7731_(at, placementState, 2);
        }
    }

    @Override
    public Component getDisplay(float value) {
        int sets = Math.round(value);
        String set = sets > 1 ? "sets" : "set";
        return new TextComponent("+" + sets + " " + set + " of " + this.blockDescription).m_130940_(ChatFormatting.GREEN);
    }
}

