/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.logic.objective.raid;

import iskallia.vault.config.RaidConfig;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.util.MathUtilities;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class RaidPreset {
    private final List<CompoundWaveSpawn> waves = new ArrayList<CompoundWaveSpawn>();

    private RaidPreset() {
    }

    @Nullable
    public static RaidPreset randomFromConfig() {
        RaidConfig.WaveSetup configSetup = ModConfigs.RAID_CONFIG.getRandomWaveSetup();
        if (configSetup == null) {
            return null;
        }
        RaidPreset preset = new RaidPreset();
        for (RaidConfig.CompoundWave wave : configSetup.getWaves()) {
            CompoundWaveSpawn compoundWave = new CompoundWaveSpawn();
            for (RaidConfig.ConfiguredWave waveSpawnSet : wave.getWaveMobs()) {
                compoundWave.waveSpawns.add(WaveSpawn.fromConfig(waveSpawnSet));
            }
            preset.waves.add(compoundWave);
        }
        return preset;
    }

    public int getWaves() {
        return this.waves.size();
    }

    @Nullable
    public CompoundWaveSpawn getWave(int step) {
        if (step < 0 || step >= this.waves.size()) {
            return null;
        }
        return this.waves.get(step);
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        ListTag waveTag = new ListTag();
        this.waves.forEach(wave -> waveTag.add((Object)wave.serialize()));
        tag.m_128365_("waves", (Tag)waveTag);
        return tag;
    }

    public static RaidPreset deserialize(CompoundTag tag) {
        RaidPreset preset = new RaidPreset();
        ListTag waveTag = tag.m_128437_("waves", 10);
        for (int i = 0; i < waveTag.size(); ++i) {
            preset.waves.add(CompoundWaveSpawn.deserialize(waveTag.m_128728_(i)));
        }
        return preset;
    }

    public static class CompoundWaveSpawn {
        private final List<WaveSpawn> waveSpawns = new ArrayList<WaveSpawn>();

        public List<WaveSpawn> getWaveSpawns() {
            return this.waveSpawns;
        }

        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            ListTag waveTag = new ListTag();
            this.waveSpawns.forEach(wave -> waveTag.add((Object)wave.serialize()));
            tag.m_128365_("waves", (Tag)waveTag);
            return tag;
        }

        public static CompoundWaveSpawn deserialize(CompoundTag tag) {
            CompoundWaveSpawn compound = new CompoundWaveSpawn();
            ListTag waveTag = tag.m_128437_("waves", 10);
            for (int i = 0; i < waveTag.size(); ++i) {
                compound.waveSpawns.add(WaveSpawn.deserialize(waveTag.m_128728_(i)));
            }
            return compound;
        }
    }

    public static class WaveSpawn {
        private final int mobCount;
        private final String mobPool;

        private WaveSpawn(int mobCount, String mobPool) {
            this.mobCount = mobCount;
            this.mobPool = mobPool;
        }

        public static WaveSpawn fromConfig(RaidConfig.ConfiguredWave configuredWave) {
            return new WaveSpawn(MathUtilities.getRandomInt(configuredWave.getMin(), configuredWave.getMax() + 1), configuredWave.getMobPool());
        }

        public int getMobCount() {
            return this.mobCount;
        }

        public String getMobPool() {
            return this.mobPool;
        }

        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("mobCount", this.mobCount);
            tag.m_128359_("mobPool", this.mobPool);
            return tag;
        }

        public static WaveSpawn deserialize(CompoundTag tag) {
            return new WaveSpawn(tag.m_128451_("mobCount"), tag.m_128461_("mobPool"));
        }
    }
}

