/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.logic.objective.raid;

import iskallia.vault.block.VaultRaidControllerBlock;
import iskallia.vault.world.vault.logic.objective.raid.ActiveRaid;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.ZombieEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class RaidEventListener {
    public static void onDeath(LivingDeathEvent event) {
        BlockPos at;
        LivingEntity died = event.getEntityLiving();
        Level world = died.m_20193_();
        ActiveRaid raid = RaidEventListener.getRaidAt((LevelAccessor)world, at = died.m_142538_());
        if (raid == null) {
            return;
        }
        raid.getActiveEntities().remove(died.m_142081_());
        if (raid.getActiveEntities().isEmpty() && raid.hasNextWave()) {
            raid.setStartDelay(100);
        }
    }

    public static void onSpawn(ZombieEvent.SummonAidEvent event) {
        if (RaidEventListener.isInLockedRaidRoom((LevelAccessor)event.getWorld(), event.getSummoner().m_142538_())) {
            event.setResult(Event.Result.DENY);
        }
    }

    public static void onBreak(BlockEvent.BreakEvent event) {
        if (RaidEventListener.isInLockedRaidRoom(event.getWorld(), event.getPos())) {
            event.setCanceled(true);
        }
    }

    public static void onPlace(BlockEvent.EntityPlaceEvent event) {
        if (RaidEventListener.isInLockedRaidRoom(event.getWorld(), event.getPos())) {
            event.setCanceled(true);
        }
    }

    public static void onFluidPlace(BlockEvent.FluidPlaceBlockEvent event) {
        if (RaidEventListener.isInLockedRaidRoom(event.getWorld(), event.getPos())) {
            event.setCanceled(true);
        }
    }

    public static void onInteract(PlayerInteractEvent event) {
        ItemStack interacted;
        if (event instanceof PlayerInteractEvent.RightClickBlock && (interacted = event.getWorld().m_8055_(event.getPos())).m_60734_() instanceof VaultRaidControllerBlock) {
            return;
        }
        interacted = event.getItemStack();
        if (event instanceof PlayerInteractEvent.RightClickItem) {
            UseAnim action = interacted.m_41780_();
            if (action == UseAnim.EAT || action == UseAnim.DRINK) {
                return;
            }
            if (RaidEventListener.isWhitelistedItem(interacted)) {
                return;
            }
        }
        if (RaidEventListener.isInLockedRaidRoom((LevelAccessor)event.getWorld(), event.getPos())) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.FAIL);
        }
    }

    private static boolean isWhitelistedItem(ItemStack interacted) {
        if (interacted.m_41619_()) {
            return false;
        }
        ResourceLocation key = interacted.m_41720_().getRegistryName();
        if (key.m_135827_().equals("dankstorage") && key.m_135815_().startsWith("dank_")) {
            return true;
        }
        if (key.toString().equals("quark:pickarang") || key.toString().equals("quark:flamerang")) {
            return true;
        }
        return key.m_135827_().equals("simplybackpacks");
    }

    private static boolean isInLockedRaidRoom(LevelAccessor world, BlockPos pos) {
        return false;
    }

    private static ActiveRaid getRaidAt(LevelAccessor world, BlockPos pos) {
        return null;
    }
}

