/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.logic.objective.raid;

import com.google.common.collect.Lists;
import iskallia.vault.block.entity.VaultRaidControllerTileEntity;
import iskallia.vault.config.entry.SingleItemEntry;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.VaultGoalMessage;
import iskallia.vault.util.MathUtilities;
import iskallia.vault.util.PlayerFilter;
import iskallia.vault.util.data.WeightedList;
import iskallia.vault.world.gen.decorator.BreadcrumbFeature;
import iskallia.vault.world.gen.structure.VaultJigsawHelper;
import iskallia.vault.world.vault.VaultRaid;
import iskallia.vault.world.vault.gen.VaultGenerator;
import iskallia.vault.world.vault.gen.piece.VaultPiece;
import iskallia.vault.world.vault.gen.piece.VaultRaidRoom;
import iskallia.vault.world.vault.logic.objective.VaultModifierVotingSession;
import iskallia.vault.world.vault.logic.objective.VaultObjective;
import iskallia.vault.world.vault.logic.objective.raid.ActiveRaid;
import iskallia.vault.world.vault.logic.objective.raid.modifier.FloatingItemModifier;
import iskallia.vault.world.vault.logic.objective.raid.modifier.ModifierDoublingModifier;
import iskallia.vault.world.vault.logic.objective.raid.modifier.RaidModifier;
import iskallia.vault.world.vault.logic.task.VaultTask;
import iskallia.vault.world.vault.modifier.modifier.ChanceCatalystModifier;
import iskallia.vault.world.vault.modifier.modifier.PlayerInventoryRestoreModifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraftforge.network.NetworkDirection;

public class RaidChallengeObjective
extends VaultObjective {
    private final LinkedHashMap<RaidModifier, Float> modifierValues = new LinkedHashMap();
    private int completedRaids = 0;
    private int targetRaids = -1;
    private boolean started = false;
    private VaultModifierVotingSession session = null;

    public RaidChallengeObjective(ResourceLocation id) {
        super(id, VaultTask.EMPTY, VaultTask.EMPTY);
    }

    @Override
    @Nonnull
    public BlockState getObjectiveRelevantBlock(VaultRaid vault, ServerLevel world, BlockPos pos) {
        return Blocks.f_50016_.m_49966_();
    }

    @Override
    @Nonnull
    public Supplier<? extends VaultGenerator> getVaultGenerator() {
        return VaultRaid.RAID_CHALLENGE_GENERATOR;
    }

    @Override
    @Nullable
    public LootTable getRewardLootTable(VaultRaid vault, Function<ResourceLocation, LootTable> tblResolver) {
        return null;
    }

    @Override
    public boolean shouldPauseTimer(MinecraftServer srv, VaultRaid vault) {
        return !this.started;
    }

    @Override
    public Component getObjectiveDisplayName() {
        return new TextComponent("Raid").m_130940_(ChatFormatting.RED);
    }

    @Override
    @Nullable
    public Component getObjectiveTargetDescription(int amount) {
        return amount < 0 ? null : new TextComponent("Raids to complete: ").m_7220_((Component)new TextComponent(String.valueOf(amount)).m_130940_(ChatFormatting.RED));
    }

    @Override
    public void setObjectiveTargetCount(int amount) {
        this.targetRaids = amount;
    }

    @Override
    public Component getVaultName() {
        return new TextComponent("Vault Raid");
    }

    public int getCompletedRaids() {
        return this.completedRaids;
    }

    @Nullable
    public VaultModifierVotingSession getVotingSession() {
        return this.session;
    }

    public void addModifier(RaidModifier modifier, float value) {
        if (modifier instanceof ModifierDoublingModifier) {
            this.modifierValues.forEach(this::addModifier);
            return;
        }
        for (RaidModifier existing : this.modifierValues.keySet()) {
            if (!existing.getName().equals(modifier.getName())) continue;
            float existingValue = this.modifierValues.get(existing).floatValue();
            this.modifierValues.put(modifier, Float.valueOf(existingValue + value));
            return;
        }
        this.modifierValues.put(modifier, Float.valueOf(value));
    }

    public Map<RaidModifier, Float> getAllModifiers() {
        return Collections.unmodifiableMap(this.modifierValues);
    }

    public <T extends RaidModifier> Map<T, Float> getModifiersOfType(Class<T> modifierClass) {
        return this.modifierValues.entrySet().stream().filter(modifierTpl -> modifierClass.isAssignableFrom(((RaidModifier)modifierTpl.getKey()).getClass())).map(tpl -> tpl).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public LinkedHashMap<RaidModifier, Float> getModifiers(boolean positive) {
        LinkedHashMap<RaidModifier, Float> modifiers = new LinkedHashMap<RaidModifier, Float>();
        this.modifierValues.forEach((modifier, value) -> {
            if (positive && modifier.isPositive() || !positive && !modifier.isPositive()) {
                modifiers.put((RaidModifier)modifier, (Float)value);
            }
        });
        return modifiers;
    }

    @Override
    public void tick(VaultRaid vault, PlayerFilter filter, ServerLevel world) {
        super.tick(vault, filter, world);
        MinecraftServer srv = world.m_142572_();
        ActiveRaid raid = vault.getActiveRaid();
        if (raid != null) {
            this.started = true;
        }
        if (this.session != null) {
            this.session.tick();
            if (this.session.isFinished()) {
                this.session.finish(vault, world);
                this.session = null;
            }
        }
        this.sendRaidMessage(vault, filter, srv, raid);
    }

    private void sendRaidMessage(VaultRaid vault, PlayerFilter filter, MinecraftServer srv, @Nullable ActiveRaid raid) {
        int wave = raid == null ? 0 : raid.getWave();
        int totalWaves = raid == null ? 0 : raid.getTotalWaves();
        int mobs = raid == null ? 0 : raid.getAliveEntities();
        int totalMobs = raid == null ? 0 : raid.getTotalWaveEntities();
        int startDelay = raid == null ? 0 : raid.getStartDelay();
        ArrayList positives = new ArrayList();
        ArrayList negatives = new ArrayList();
        this.modifierValues.forEach((modifier, value) -> {
            Component display = modifier.getDisplay(value.floatValue());
            if (modifier.isPositive()) {
                positives.add(display);
            } else {
                negatives.add(display);
            }
        });
        vault.getPlayers().stream().filter(vPlayer -> filter.test(vPlayer.getPlayerId())).forEach(vPlayer -> vPlayer.runIfPresent(srv, playerEntity -> {
            VaultGoalMessage pkt = VaultGoalMessage.raidChallenge(wave, totalWaves, mobs, totalMobs, startDelay, this.completedRaids, this.targetRaids, positives, negatives, this.session);
            ModNetwork.CHANNEL.sendTo((Object)pkt, playerEntity.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }));
    }

    public void onRaidStart(VaultRaid vault, ServerLevel world, ActiveRaid raid, BlockPos controller) {
        BlockEntity te = world.m_7702_(controller);
        if (!(te instanceof VaultRaidControllerTileEntity)) {
            return;
        }
        VaultRaidControllerTileEntity raidController = (VaultRaidControllerTileEntity)te;
        raidController.getRaidModifiers().forEach((modifierName, value) -> {
            RaidModifier mod = ModConfigs.RAID_MODIFIER_CONFIG.getByName((String)modifierName);
            if (mod != null) {
                this.addModifier(mod, value.floatValue());
            }
        });
        if (this.session == null && ModConfigs.RAID_EVENT_CONFIG.isEnabled() && rand.nextFloat() < ModConfigs.RAID_EVENT_CONFIG.getViewerVoteChance()) {
            this.session = VaultModifierVotingSession.create();
        }
    }

    public void onRaidFinish(VaultRaid vault, ServerLevel world, ActiveRaid raid, BlockPos controller) {
        VaultRaidRoom raidRoom;
        RaidModifier modifier2;
        ++this.completedRaids;
        if (this.targetRaids >= 0 && this.completedRaids >= this.targetRaids) {
            this.setCompleted();
            return;
        }
        if (this.completedRaids % 10 == 0 && (modifier2 = ModConfigs.RAID_MODIFIER_CONFIG.getByName("artifactFragment")) != null) {
            boolean canGetArtifact;
            boolean bl = canGetArtifact = !vault.hasActiveModifierFor(PlayerFilter.any(), PlayerInventoryRestoreModifier.class, m -> ((PlayerInventoryRestoreModifier.Properties)m.properties()).preventsArtifact());
            if (canGetArtifact) {
                this.addModifier(modifier2, MathUtilities.randomFloat(0.02f, 0.05f));
            }
        }
        if ((raidRoom = (VaultRaidRoom)vault.getGenerator().getPiecesAt(controller, VaultRaidRoom.class).stream().findFirst().orElse(null)) == null) {
            return;
        }
        for (Direction direction : Direction.values()) {
            if (direction.m_122434_() == Direction.Axis.Y || !VaultJigsawHelper.canExpand(vault, raidRoom, direction)) continue;
            VaultJigsawHelper.expandVault(vault, world, raidRoom, direction, VaultJigsawHelper.getRaidChallengeRoom());
        }
        raidRoom.setRaidFinished();
        this.getAllModifiers().forEach((modifier, value) -> modifier.onVaultRaidFinish(vault, world, controller, raid, value.floatValue()));
        FloatingItemModifier catalystPlacement = new FloatingItemModifier("", 4, new WeightedList<SingleItemEntry>().add(new SingleItemEntry((ItemLike)ModItems.VAULT_CATALYST_FRAGMENT), 1), "");
        vault.withActiveModifiersFor(PlayerFilter.any(), ChanceCatalystModifier.class, (chanceCatalystModifier, stackSize) -> catalystPlacement.onVaultRaidFinish(vault, world, controller, raid, 1.0f));
        BreadcrumbFeature.generateVaultBreadcrumb(vault, world, Lists.newArrayList((Object[])new VaultPiece[]{raidRoom}));
    }

    @Override
    public boolean isCompleted() {
        return super.isCompleted();
    }

    @Override
    public boolean preventsMobSpawning() {
        return true;
    }

    @Override
    public boolean preventsInfluences() {
        return true;
    }

    @Override
    public boolean preventsNormalMonsterDrops() {
        return true;
    }

    @Override
    public boolean preventsCatalystFragments() {
        return true;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        ListTag modifiers = new ListTag();
        this.modifierValues.forEach((modifier, value) -> {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("name", modifier.getName());
            nbt.m_128350_("value", value.floatValue());
            modifiers.add((Object)nbt);
        });
        tag.m_128365_("raidModifiers", (Tag)modifiers);
        tag.m_128405_("completedRaids", this.completedRaids);
        if (this.targetRaids >= 0) {
            tag.m_128405_("targetRaids", this.targetRaids);
        }
        tag.m_128379_("started", this.started);
        if (this.session != null) {
            tag.m_128365_("votingSession", (Tag)this.session.serialize());
        }
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        ListTag modifiers = nbt.m_128437_("raidModifiers", 10);
        for (int i = 0; i < modifiers.size(); ++i) {
            CompoundTag modifierTag = modifiers.m_128728_(i);
            RaidModifier modifier = ModConfigs.RAID_MODIFIER_CONFIG.getByName(modifierTag.m_128461_("name"));
            if (modifier == null) continue;
            float val = modifierTag.m_128457_("value");
            this.modifierValues.put(modifier, Float.valueOf(val));
        }
        this.completedRaids = nbt.m_128451_("completedRaids");
        if (nbt.m_128425_("targetRaids", 3)) {
            this.targetRaids = nbt.m_128451_("targetRaids");
        }
        this.started = nbt.m_128471_("started");
        if (nbt.m_128425_("votingSession", 10)) {
            this.session = VaultModifierVotingSession.deserialize(nbt.m_128469_("votingSession"));
        }
    }
}

