/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.logic.objective.raid;

import com.mojang.math.Vector3f;
import iskallia.vault.config.RaidConfig;
import iskallia.vault.entity.LegacyEntityScaler;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.util.nbt.NBTHelper;
import iskallia.vault.world.data.PlayerVaultStatsData;
import iskallia.vault.world.vault.VaultRaid;
import iskallia.vault.world.vault.gen.piece.VaultRoom;
import iskallia.vault.world.vault.logic.objective.raid.RaidChallengeObjective;
import iskallia.vault.world.vault.logic.objective.raid.RaidPreset;
import iskallia.vault.world.vault.logic.objective.raid.modifier.MonsterAmountModifier;
import iskallia.vault.world.vault.logic.objective.raid.modifier.MonsterLevelModifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;

public class ActiveRaid {
    private static final Random rand = new Random();
    private final BlockPos controller;
    private final AABB raidBox;
    private final RaidPreset preset;
    private int wave = -1;
    private int startDelay = 200;
    private final List<UUID> activeEntities = new ArrayList<UUID>();
    private int totalWaveEntities = 0;
    private final List<UUID> participatingPlayers = new ArrayList<UUID>();

    private ActiveRaid(BlockPos controller, AABB raidBox, RaidPreset preset) {
        this.controller = controller;
        this.raidBox = raidBox;
        this.preset = preset;
    }

    @Nullable
    public static ActiveRaid create(VaultRaid vault, ServerLevel world, BlockPos controller) {
        RaidPreset preset = RaidPreset.randomFromConfig();
        if (preset == null) {
            return null;
        }
        VaultRoom room = vault.getGenerator().getPiecesAt(controller, VaultRoom.class).stream().findFirst().orElse(null);
        if (room == null) {
            return null;
        }
        AABB raidBox = AABB.m_82321_((BoundingBox)room.getBoundingBox());
        ActiveRaid raid = new ActiveRaid(controller, raidBox, preset);
        world.m_45976_(Player.class, raidBox).forEach(player -> raid.participatingPlayers.add(player.m_142081_()));
        vault.getActiveObjective(RaidChallengeObjective.class).ifPresent(raidObjective -> raidObjective.onRaidStart(vault, world, raid, controller));
        raid.playSoundToPlayers((EntityGetter)world, SoundEvents.f_11868_, 1.0f, 0.7f);
        return raid;
    }

    public void tick(VaultRaid vault, ServerLevel world) {
        if (this.activeEntities.isEmpty() && this.startDelay <= 0) {
            ++this.wave;
            RaidPreset.CompoundWaveSpawn wave = this.preset.getWave(this.wave);
            if (wave != null) {
                this.spawnWave(wave, vault, world);
            }
        }
        if (this.startDelay > 0) {
            --this.startDelay;
        }
        this.activeEntities.removeIf(entityUid -> {
            Entity e = world.m_8791_(entityUid);
            if (!(e instanceof Mob)) {
                return true;
            }
            Mob mob = (Mob)e;
            mob.m_21530_();
            if (!vault.getActiveObjective(RaidChallengeObjective.class).isPresent()) {
                mob.m_146915_(true);
            }
            if (!(mob.m_5448_() instanceof Player)) {
                List players = this.participatingPlayers.stream().map(arg_0 -> ((ServerLevel)world).m_46003_(arg_0)).filter(Objects::nonNull).filter(player -> this.raidBox.m_82400_(10.0).m_82390_(player.m_20182_())).collect(Collectors.toList());
                if (!players.isEmpty()) {
                    Player player2 = (Player)MiscUtils.getRandomEntry(players, rand);
                    mob.m_6710_((LivingEntity)player2);
                }
            }
            return false;
        });
    }

    public void spawnWave(RaidPreset.CompoundWaveSpawn wave, VaultRaid vault, ServerLevel world) {
        int participantLevel = -1;
        for (Player player : world.m_45976_(Player.class, this.getRaidBoundingBox())) {
            int playerLevel = PlayerVaultStatsData.get(world).getVaultStats(player).getVaultLevel();
            if (participantLevel == -1) {
                participantLevel = playerLevel;
                continue;
            }
            if (participantLevel <= playerLevel) continue;
            participantLevel = playerLevel;
        }
        if (participantLevel == -1) {
            participantLevel = vault.getProperties().getBase(VaultRaid.LEVEL).orElse(0);
        }
        int scalingLevel = participantLevel;
        int playerCount = this.participatingPlayers.size();
        wave.getWaveSpawns().forEach(spawn -> {
            RaidConfig.MobPool pool = ModConfigs.RAID_CONFIG.getPool(spawn.getMobPool(), scalingLevel);
            if (pool == null) {
                return;
            }
            int spawnCount = spawn.getMobCount();
            spawnCount = (int)((double)spawnCount * ((1.0 + vault.getActiveObjective(RaidChallengeObjective.class).map(raidObjective -> raidObjective.getModifiersOfType(MonsterAmountModifier.class).values().stream().mapToDouble(Float::doubleValue).sum()).orElse(0.0)) * (double)playerCount));
            spawnCount = (int)((float)spawnCount * ModConfigs.RAID_CONFIG.getMobCountMultiplier(scalingLevel));
            for (int i = 0; i < spawnCount; ++i) {
                Entity spawned;
                Vector3f center;
                Vector3f randomPos;
                BlockPos spawnAt;
                String mobType = pool.getRandomMob();
                EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(mobType));
                if (type == null || !type.m_20654_() || (spawnAt = MiscUtils.getEmptyNearby((LevelReader)world, new BlockPos((double)(randomPos = MiscUtils.getRandomCirclePosition(center = new Vector3f((float)this.controller.m_123341_() + 0.5f, (float)this.controller.m_123342_(), (float)this.controller.m_123343_() + 0.5f), new Vector3f(0.0f, 1.0f, 0.0f), 8.0f + rand.nextFloat() * 6.0f)).m_122239_(), (double)randomPos.m_122260_(), (double)randomPos.m_122269_())).orElse(BlockPos.f_121853_)).equals((Object)BlockPos.f_121853_) || !((spawned = type.m_20592_(world, null, null, spawnAt, MobSpawnType.EVENT, true, false)) instanceof Mob)) continue;
                Mob mob = (Mob)spawned;
                this.processSpawnedMob(mob, vault, scalingLevel);
                this.activeEntities.add(mob.m_142081_());
            }
        });
        this.totalWaveEntities = this.activeEntities.size();
        this.playSoundToPlayers((EntityGetter)world, SoundEvents.f_12355_, 64.0f, 1.0f);
    }

    private void processSpawnedMob(Mob mob, VaultRaid vault, int level) {
        mob.m_21530_();
        LegacyEntityScaler.setScaledEquipmentLegacy((LivingEntity)mob, vault, level += vault.getActiveObjective(RaidChallengeObjective.class).map(raidObjective -> raidObjective.getModifiersOfType(MonsterLevelModifier.class).entrySet().stream().mapToInt(entry -> ((MonsterLevelModifier)entry.getKey()).getLevelAdded(((Float)entry.getValue()).floatValue())).sum()).orElse(0).intValue(), new Random(), LegacyEntityScaler.Type.MOB);
        LegacyEntityScaler.setScaled((Entity)mob);
        vault.getActiveObjective(RaidChallengeObjective.class).ifPresent(raidObjective -> raidObjective.getAllModifiers().forEach((modifier, value) -> modifier.affectRaidMob(mob, value.floatValue())));
    }

    public boolean isFinished() {
        return this.wave >= 0 && this.preset.getWave(this.wave) == null;
    }

    List<UUID> getActiveEntities() {
        return this.activeEntities;
    }

    public boolean isPlayerInRaid(Player player) {
        return this.isPlayerInRaid(player.m_142081_());
    }

    public boolean isPlayerInRaid(UUID playerId) {
        return this.participatingPlayers.contains(playerId);
    }

    public AABB getRaidBoundingBox() {
        return this.raidBox;
    }

    public int getWave() {
        return this.wave;
    }

    public int getTotalWaves() {
        return this.preset.getWaves();
    }

    public int getAliveEntities() {
        return this.activeEntities.size();
    }

    public int getTotalWaveEntities() {
        return this.totalWaveEntities;
    }

    public int getStartDelay() {
        return this.startDelay;
    }

    void setStartDelay(int startDelay) {
        this.startDelay = startDelay;
    }

    boolean hasNextWave() {
        return this.preset.getWave(this.wave + 1) != null;
    }

    public void finish(VaultRaid raid, ServerLevel world) {
        raid.getActiveObjective(RaidChallengeObjective.class).ifPresent(raidChallenge -> raidChallenge.onRaidFinish(raid, world, this, this.controller));
        this.playSoundToPlayers((EntityGetter)world, SoundEvents.f_12496_, 0.7f, 0.5f);
    }

    private void playSoundToPlayers(EntityGetter world, SoundEvent event, float volume, float pitch) {
        this.participatingPlayers.forEach(playerId -> {
            Player player = world.m_46003_(playerId);
            if (player instanceof ServerPlayer) {
                ClientboundSoundPacket pkt = new ClientboundSoundPacket(event, SoundSource.BLOCKS, player.m_20185_(), player.m_20186_(), player.m_20189_(), volume, pitch);
                ((ServerPlayer)player).f_8906_.m_141995_((Packet)pkt);
            }
        });
    }

    public BlockPos getController() {
        return this.controller;
    }

    public void serialize(CompoundTag tag) {
        tag.m_128365_("pos", (Tag)NBTHelper.serializeBlockPos(this.controller));
        tag.m_128365_("boxFrom", (Tag)NBTHelper.serializeBlockPos(new BlockPos(this.raidBox.f_82288_, this.raidBox.f_82289_, this.raidBox.f_82290_)));
        tag.m_128365_("boxTo", (Tag)NBTHelper.serializeBlockPos(new BlockPos(this.raidBox.f_82291_, this.raidBox.f_82292_, this.raidBox.f_82293_)));
        tag.m_128405_("wave", this.wave);
        tag.m_128365_("waves", (Tag)this.preset.serialize());
        tag.m_128405_("startDelay", this.startDelay);
        tag.m_128405_("totalWaveEntities", this.totalWaveEntities);
        NBTHelper.writeCollection(tag, "entities", this.activeEntities, StringTag.class, uuid -> StringTag.m_129297_((String)uuid.toString()));
        NBTHelper.writeCollection(tag, "players", this.participatingPlayers, StringTag.class, uuid -> StringTag.m_129297_((String)uuid.toString()));
    }

    public static ActiveRaid deserializeNBT(CompoundTag nbt) {
        BlockPos controller = NBTHelper.deserializeBlockPos(nbt.m_128469_("pos"));
        BlockPos from = NBTHelper.deserializeBlockPos(nbt.m_128469_("boxFrom"));
        BlockPos to = NBTHelper.deserializeBlockPos(nbt.m_128469_("boxTo"));
        RaidPreset waves = RaidPreset.deserialize(nbt.m_128469_("waves"));
        ActiveRaid raid = new ActiveRaid(controller, new AABB(from, to), waves);
        raid.startDelay = nbt.m_128451_("startDelay");
        raid.wave = nbt.m_128451_("wave");
        raid.totalWaveEntities = nbt.m_128451_("totalWaveEntities");
        raid.activeEntities.addAll(NBTHelper.readList(nbt, "entities", StringTag.class, idString -> UUID.fromString(idString.m_7916_())));
        raid.participatingPlayers.addAll(NBTHelper.readList(nbt, "players", StringTag.class, idString -> UUID.fromString(idString.m_7916_())));
        return raid;
    }
}

