/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.logic.objective.architect.processor;

import iskallia.vault.util.MiscUtils;
import iskallia.vault.world.vault.VaultRaid;
import iskallia.vault.world.vault.gen.piece.VaultObelisk;
import iskallia.vault.world.vault.gen.piece.VaultPiece;
import iskallia.vault.world.vault.logic.VaultSpawner;
import iskallia.vault.world.vault.logic.objective.architect.processor.VaultPieceProcessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;

public class VaultSpawnerSpawningPostProcessor
extends VaultPieceProcessor {
    private final int blocksPerSpawn;

    public VaultSpawnerSpawningPostProcessor(int blocksPerSpawn) {
        this.blocksPerSpawn = blocksPerSpawn;
    }

    @Override
    public void postProcess(VaultRaid vault, ServerLevel world, VaultPiece piece, Direction generatedDirection) {
        if (piece instanceof VaultObelisk) {
            return;
        }
        vault.getProperties().getBase(VaultRaid.LEVEL).ifPresent(vaultLevel -> {
            AABB box = AABB.m_82321_((BoundingBox)piece.getBoundingBox());
            float size = (float)((box.f_82291_ - box.f_82288_) * (box.f_82292_ - box.f_82289_) * (box.f_82293_ - box.f_82290_));
            float runs = size / (float)this.blocksPerSpawn;
            while (!(!(runs > 0.0f) || runs < 1.0f && rand.nextFloat() >= runs)) {
                runs -= 1.0f;
                LivingEntity spawned = null;
                while (spawned == null) {
                    BlockPos pos = MiscUtils.getRandomPos(box, rand);
                    spawned = VaultSpawner.spawnMob(vault, world, vaultLevel, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), rand);
                }
            }
        });
    }
}

