/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.logic.objective.architect.processor;

import iskallia.vault.entity.entity.FloatingItemEntity;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.util.data.WeightedList;
import iskallia.vault.world.vault.VaultRaid;
import iskallia.vault.world.vault.gen.piece.VaultObelisk;
import iskallia.vault.world.vault.gen.piece.VaultPiece;
import iskallia.vault.world.vault.logic.objective.architect.processor.VaultPieceProcessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;

public class FloatingItemPostProcessor
extends VaultPieceProcessor {
    private final int blocksPerSpawn;
    private final WeightedList<ItemStack> itemList;

    public FloatingItemPostProcessor(int blocksPerSpawn, WeightedList<ItemStack> itemList) {
        this.blocksPerSpawn = blocksPerSpawn;
        this.itemList = itemList;
    }

    @Override
    public void postProcess(VaultRaid vault, ServerLevel world, VaultPiece piece, Direction generatedDirection) {
        if (piece instanceof VaultObelisk) {
            return;
        }
        AABB box = AABB.m_82321_((BoundingBox)piece.getBoundingBox());
        float size = (float)((box.f_82291_ - box.f_82288_) * (box.f_82292_ - box.f_82289_) * (box.f_82293_ - box.f_82290_));
        float runs = size / (float)this.blocksPerSpawn;
        while (!(!(runs > 0.0f) || runs < 1.0f && rand.nextFloat() >= runs)) {
            runs -= 1.0f;
            boolean placed = false;
            while (!placed) {
                BlockPos pos = MiscUtils.getRandomPos(box, rand);
                BlockState state = world.m_8055_(pos);
                if (!state.m_60795_()) continue;
                placed = true;
                ItemStack stack = this.itemList.getRandom(rand);
                if (stack == null) continue;
                FloatingItemEntity itemEntity = FloatingItemEntity.create((Level)world, pos, stack.m_41777_());
                world.m_7967_((Entity)itemEntity);
            }
        }
    }
}

