/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.logic.objective.architect.processor;

import iskallia.vault.util.MiscUtils;
import iskallia.vault.world.vault.VaultRaid;
import iskallia.vault.world.vault.gen.piece.VaultObelisk;
import iskallia.vault.world.vault.gen.piece.VaultPiece;
import iskallia.vault.world.vault.logic.objective.architect.processor.VaultPieceProcessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;

public class BlockPlacementPostProcessor
extends VaultPieceProcessor {
    private final BlockState toPlace;
    private final int blocksPerSpawn;

    public BlockPlacementPostProcessor(BlockState toPlace, int blocksPerSpawn) {
        this.toPlace = toPlace;
        this.blocksPerSpawn = blocksPerSpawn;
    }

    @Override
    public void postProcess(VaultRaid vault, ServerLevel world, VaultPiece piece, Direction generatedDirection) {
        if (piece instanceof VaultObelisk) {
            return;
        }
        AABB box = AABB.m_82321_((BoundingBox)piece.getBoundingBox());
        float size = (float)((box.f_82291_ - box.f_82288_) * (box.f_82292_ - box.f_82289_) * (box.f_82293_ - box.f_82290_));
        float runs = size / (float)this.blocksPerSpawn;
        while (!(!(runs > 0.0f) || runs < 1.0f && rand.nextFloat() >= runs)) {
            runs -= 1.0f;
            boolean placed = false;
            while (!placed) {
                BlockPos pos = MiscUtils.getRandomPos(box, rand);
                BlockState state = world.m_8055_(pos);
                if (!state.m_60795_() || !world.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)world, pos, Direction.UP) || !world.m_7731_(pos, this.toPlace, 2)) continue;
                placed = true;
            }
        }
    }
}

