/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.logic.objective.architect;

import iskallia.vault.block.entity.StabilizerTileEntity;
import iskallia.vault.util.CodecUtils;
import iskallia.vault.world.vault.logic.objective.architect.DirectionChoice;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;

public class VotingSession {
    private static final int VOTING_DURATION = 410;
    private final BlockPos stabilizerPos;
    private final Set<String> voted = new HashSet<String>();
    private final List<DirectionChoice> directions = new ArrayList<DirectionChoice>();
    private int voteTicks;

    VotingSession(BlockPos stabilizerPos, Collection<DirectionChoice> directions) {
        this.stabilizerPos = stabilizerPos;
        this.voteTicks = 410;
        this.directions.addAll(directions);
    }

    VotingSession(CompoundTag tag) {
        this.stabilizerPos = CodecUtils.readNBT(BlockPos.f_121852_, tag, "pos", BlockPos.f_121853_);
        this.voteTicks = tag.m_128451_("voteTicks");
        ListTag directions = tag.m_128437_("directions", 10);
        for (int i = 0; i < directions.size(); ++i) {
            this.directions.add(new DirectionChoice(directions.m_128728_(i)));
        }
    }

    void acceptVote(String voter, Direction dir) {
        if (this.voted.add(voter)) {
            for (DirectionChoice choice : this.directions) {
                if (choice.getDirection() != dir) continue;
                choice.addVote();
            }
        }
    }

    void tick(ServerLevel world) {
        if (!this.isFinished()) {
            BlockEntity tile;
            --this.voteTicks;
            if (world.m_46805_(this.getStabilizerPos()) && (tile = world.m_7702_(this.getStabilizerPos())) instanceof StabilizerTileEntity) {
                ((StabilizerTileEntity)tile).setActive();
            }
        }
    }

    public BlockPos getStabilizerPos() {
        return this.stabilizerPos;
    }

    public boolean isFinished() {
        return this.voteTicks <= 0;
    }

    public int getTotalVoteTicks() {
        return 410;
    }

    public int getRemainingVoteTicks() {
        return this.voteTicks;
    }

    public List<DirectionChoice> getDirections() {
        return this.directions;
    }

    public float getChoicePercentage(DirectionChoice choice) {
        float total = 0.0f;
        for (DirectionChoice anyChoice : this.getDirections()) {
            total += (float)anyChoice.getVotes();
        }
        return (float)choice.getVotes() / total;
    }

    public DirectionChoice getVotedDirection() {
        ArrayList<DirectionChoice> choices = new ArrayList<DirectionChoice>(this.getDirections());
        Collections.shuffle(choices);
        DirectionChoice votedChoice = null;
        for (DirectionChoice choice : choices) {
            if (votedChoice != null && choice.getVotes() <= votedChoice.getVotes()) continue;
            votedChoice = choice;
        }
        return votedChoice;
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        CodecUtils.writeNBT(BlockPos.f_121852_, this.stabilizerPos, tag, "pos");
        tag.m_128405_("voteTicks", this.voteTicks);
        ListTag directions = new ListTag();
        for (DirectionChoice choice : this.directions) {
            directions.add((Object)choice.serialize());
        }
        tag.m_128365_("directions", (Tag)directions);
        return tag;
    }

    public static VotingSession deserialize(CompoundTag tag) {
        return new VotingSession(tag);
    }
}

