/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.logic.objective.architect;

import iskallia.vault.init.ModConfigs;
import iskallia.vault.world.vault.logic.objective.architect.modifier.VoteModifier;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import org.apache.commons.lang3.StringUtils;

public class DirectionChoice {
    private final Direction direction;
    private final ChatFormatting chatColor;
    private final List<String> modifiers = new ArrayList<String>();
    private int votes;

    DirectionChoice(Direction direction) {
        this.direction = direction;
        this.chatColor = DirectionChoice.getDirectionColor(this.direction);
        this.votes = 10;
    }

    DirectionChoice(CompoundTag tag) {
        this.direction = Direction.m_122402_((String)tag.m_128461_("direction"));
        this.chatColor = DirectionChoice.getDirectionColor(this.direction);
        this.votes = tag.m_128451_("votes");
        ListTag modifierList = tag.m_128437_("modifiers", 8);
        for (int i = 0; i < modifierList.size(); ++i) {
            this.modifiers.add(modifierList.m_128778_(i));
        }
    }

    public void addVote() {
        ++this.votes;
    }

    public int getVotes() {
        return this.votes;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public ChatFormatting getChatColor() {
        return this.chatColor;
    }

    public Component getDirectionDisplay() {
        return this.getDirectionDisplay(null);
    }

    public Component getDirectionDisplay(@Nullable String prefix) {
        String directionName = (prefix == null ? "" : prefix) + StringUtils.capitalize((String)this.getDirection().m_122433_());
        return new TextComponent(directionName).m_130940_(this.getChatColor());
    }

    public void addModifier(VoteModifier modifier) {
        this.modifiers.add(modifier.getName());
    }

    public List<VoteModifier> getModifiers() {
        ArrayList<VoteModifier> modifierList = new ArrayList<VoteModifier>();
        this.modifiers.forEach(modifierStr -> {
            VoteModifier modifier = ModConfigs.ARCHITECT_EVENT.getModifier((String)modifierStr);
            if (modifier != null) {
                modifierList.add(modifier);
            }
        });
        return modifierList;
    }

    CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("direction", this.direction.m_122433_());
        tag.m_128405_("votes", this.votes);
        ListTag modifierList = new ListTag();
        this.modifiers.forEach(modifier -> modifierList.add((Object)StringTag.m_129297_((String)modifier)));
        tag.m_128365_("modifiers", (Tag)modifierList);
        return tag;
    }

    public static int getVOffset(Direction dir) {
        return 33 + (dir.ordinal() - 2) * 9;
    }

    private static ChatFormatting getDirectionColor(Direction dir) {
        if (dir != null) {
            switch (dir) {
                case NORTH: {
                    return ChatFormatting.RED;
                }
                case SOUTH: {
                    return ChatFormatting.AQUA;
                }
                case WEST: {
                    return ChatFormatting.GOLD;
                }
                case EAST: {
                    return ChatFormatting.GREEN;
                }
            }
        }
        return ChatFormatting.WHITE;
    }
}

