/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.logic.objective.architect;

import com.google.common.collect.Iterables;
import iskallia.vault.block.VaultCrateBlock;
import iskallia.vault.config.LegacyLootTablesConfig;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.nbt.VListNBT;
import iskallia.vault.network.message.VaultGoalMessage;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.util.PlayerFilter;
import iskallia.vault.util.nbt.NBTHelper;
import iskallia.vault.world.gen.decorator.BreadcrumbFeature;
import iskallia.vault.world.gen.structure.VaultJigsawHelper;
import iskallia.vault.world.vault.VaultRaid;
import iskallia.vault.world.vault.gen.VaultGenerator;
import iskallia.vault.world.vault.gen.piece.VaultPiece;
import iskallia.vault.world.vault.gen.piece.VaultRoom;
import iskallia.vault.world.vault.logic.VaultBossSpawner;
import iskallia.vault.world.vault.logic.objective.VaultObjective;
import iskallia.vault.world.vault.logic.objective.architect.DirectionChoice;
import iskallia.vault.world.vault.logic.objective.architect.VotingSession;
import iskallia.vault.world.vault.logic.objective.architect.modifier.RandomVoteModifier;
import iskallia.vault.world.vault.logic.objective.architect.modifier.VoteModifier;
import iskallia.vault.world.vault.logic.task.VaultTask;
import iskallia.vault.world.vault.player.VaultPlayer;
import iskallia.vault.world.vault.player.VaultRunner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkDirection;

public class ArchitectObjective
extends VaultObjective {
    private final List<VotingSession> completedSessions = new ArrayList<VotingSession>();
    private VotingSession activeSession = null;
    private boolean votingLocked = false;
    private int totalRequiredVotes;
    private int voteDowntimeTicks = 400;
    private int ticksUntilNextVote = 0;
    private UUID bossId = null;
    private boolean isBossDead = false;
    private final VListNBT<BlockPos, CompoundTag> exitPortalLocations = VListNBT.ofCodec(BlockPos.f_121852_, BlockPos.f_121853_);
    private boolean collidedWithExitPortal = false;

    public ArchitectObjective(ResourceLocation id) {
        super(id, VaultTask.EMPTY, VaultTask.EMPTY);
        this.totalRequiredVotes = ModConfigs.ARCHITECT_EVENT.getRandomTotalRequiredPolls();
    }

    public boolean createVotingSession(ServerLevel world, BlockPos origin) {
        if (this.activeSession != null || this.ticksUntilNextVote > 0 || this.isVotingLocked()) {
            return false;
        }
        Object thisRaid = null;
        return false;
    }

    @Nullable
    public VotingSession getActiveSession() {
        return this.activeSession;
    }

    public void handleVote(String sender, Direction dir) {
        if (this.activeSession == null) {
            return;
        }
        this.activeSession.acceptVote(sender, dir);
    }

    @Override
    public boolean shouldPauseTimer(MinecraftServer srv, VaultRaid vault) {
        return super.shouldPauseTimer(srv, vault) || this.activeSession == null && this.completedSessions.isEmpty();
    }

    @Override
    public void tick(VaultRaid vault, PlayerFilter filter, ServerLevel world) {
        super.tick(vault, filter, world);
        MinecraftServer srv = world.m_142572_();
        vault.getPlayers().stream().filter(vPlayer -> filter.test(vPlayer.getPlayerId())).forEach(vPlayer -> vPlayer.runIfPresent(srv, playerEntity -> {
            VaultGoalMessage pkt = VaultGoalMessage.architectEvent(this.getCompletedPercent(), this.ticksUntilNextVote, this.voteDowntimeTicks, this.activeSession);
            ModNetwork.CHANNEL.sendTo((Object)pkt, playerEntity.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }));
        if (this.isCompleted()) {
            return;
        }
        if (this.ticksUntilNextVote > 0) {
            --this.ticksUntilNextVote;
        }
        if (this.activeSession != null) {
            this.activeSession.tick(world);
            if (this.activeSession.isFinished()) {
                this.finishVote(vault, this.activeSession, world);
                this.completedSessions.add(this.activeSession);
                this.activeSession = null;
                if (!this.isVotingLocked()) {
                    this.ticksUntilNextVote = this.voteDowntimeTicks;
                }
            }
        }
        if (!this.exitPortalLocations.isEmpty()) {
            vault.getPlayers().stream().filter(vPlayer -> filter.test(vPlayer.getPlayerId())).forEach(vPlayer -> vPlayer.runIfPresent(srv, sPlayer -> {
                BlockPos pos = sPlayer.m_142538_();
                if (this.exitPortalLocations.contains(pos)) {
                    this.collidedWithExitPortal = true;
                    this.spawnBossLoot(vault, pos, (VaultPlayer)vPlayer, world, false);
                }
            }));
        }
        if (this.bossId != null && this.isBossDead) {
            this.setCompleted();
        }
        if (!this.exitPortalLocations.isEmpty() && this.collidedWithExitPortal) {
            this.setCompleted();
        }
    }

    private void finishVote(VaultRaid vault, VotingSession session, ServerLevel world) {
        vault.getGenerator().getPiecesAt(session.getStabilizerPos(), VaultRoom.class).stream().findFirst().ifPresent(room -> {
            DirectionChoice choice = session.getVotedDirection();
            ArrayList modifiers = new ArrayList();
            choice.getModifiers().forEach(modifier -> {
                if (modifier instanceof RandomVoteModifier) {
                    modifiers.add(((RandomVoteModifier)modifier).rollModifier());
                } else {
                    modifiers.add(modifier);
                }
            });
            StructurePoolElement roomPiece = modifiers.stream().map(modifier -> modifier.getSpecialRoom(this, vault)).filter(Objects::nonNull).findFirst().orElse(null);
            List<VaultPiece> generatedPieces = VaultJigsawHelper.expandVault(vault, world, room, choice.getDirection(), roomPiece);
            BreadcrumbFeature.generateVaultBreadcrumb(vault, world, generatedPieces);
            List postProcessors = modifiers.stream().map(modifier -> modifier.getPostProcessor(this, vault)).filter(Objects::nonNull).collect(Collectors.toList());
            generatedPieces.forEach(piece -> postProcessors.forEach(processor -> processor.postProcess(vault, world, (VaultPiece)piece, choice.getDirection())));
            modifiers.forEach(modifier -> modifier.onApply(this, vault, world));
            choice.getModifiers().forEach(modifier -> this.voteDowntimeTicks += modifier.getVoteLockDurationChangeSeconds() * 20);
            this.voteDowntimeTicks = Math.max(0, this.voteDowntimeTicks);
            ClientboundSetTitleTextPacket titlePacket = new ClientboundSetTitleTextPacket(choice.getDirectionDisplay());
            VoteModifier displayModifier = (VoteModifier)Iterables.getFirst(modifiers, null);
            ClientboundSetSubtitleTextPacket subtitlePacket = displayModifier != null ? new ClientboundSetSubtitleTextPacket(displayModifier.getDescription()) : null;
            vault.getPlayers().forEach(vPlayer -> vPlayer.runIfPresent(world.m_142572_(), sPlayer -> {
                sPlayer.f_8906_.m_141995_((Packet)titlePacket);
                if (subtitlePacket != null) {
                    sPlayer.f_8906_.m_141995_((Packet)subtitlePacket);
                }
            }));
        });
    }

    public void buildPortal(List<BlockPos> portalLocations) {
        this.exitPortalLocations.addAll((Collection<BlockPos>)portalLocations);
    }

    public void spawnBoss(VaultRaid vault, ServerLevel world, BlockPos pos) {
        LivingEntity boss = VaultBossSpawner.spawnBossLegacy(vault, world, pos);
        this.bossId = boss.m_142081_();
    }

    private boolean onBossKill(LivingEntity boss) {
        if (this.isBossDead || !boss.m_142081_().equals(this.bossId)) {
            return false;
        }
        this.isBossDead = true;
        return true;
    }

    private void dropBossCrate(LivingEntity boss, DamageSource killSrc, ServerLevel world, VaultRaid vault) {
        Optional<UUID> source = Optional.ofNullable(killSrc.m_7639_()).map(Entity::m_142081_);
        Optional killer = source.flatMap(vault::getPlayer);
        Optional host = vault.getProperties().getBase(VaultRaid.HOST).flatMap(vault::getPlayer);
        if (killer.isPresent()) {
            this.spawnBossLoot(vault, boss.m_142538_(), (VaultPlayer)killer.get(), world, true);
        } else if (host.isPresent() && host.get() instanceof VaultRunner) {
            this.spawnBossLoot(vault, boss.m_142538_(), (VaultPlayer)host.get(), world, true);
        } else {
            vault.getPlayers().stream().filter(player -> player instanceof VaultRunner).findFirst().ifPresent(player -> this.spawnBossLoot(vault, boss.m_142538_(), (VaultPlayer)player, world, true));
        }
    }

    public void spawnBossLoot(VaultRaid vault, BlockPos bossPos, VaultPlayer player, ServerLevel world, boolean isBossKill) {
        player.runIfPresent(world.m_142572_(), playerEntity -> {
            LootContext.Builder builder = new LootContext.Builder(world).m_78977_(world.f_46441_).m_78972_(LootContextParams.f_81455_, playerEntity).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)bossPos)).m_78972_(LootContextParams.f_81457_, (Object)DamageSource.m_19344_((Player)playerEntity)).m_78984_(LootContextParams.f_81458_, playerEntity).m_78984_(LootContextParams.f_81459_, playerEntity).m_78972_(LootContextParams.f_81456_, playerEntity).m_78963_(playerEntity.m_36336_());
            LootContext ctx = builder.m_78975_(LootContextParamSets.f_81415_);
            this.spawnRewardCrate(world, (Vec3i)bossPos, vault, ctx);
            for (int i = 1; i < vault.getPlayers().size(); ++i) {
                if (!(rand.nextFloat() < 0.5f)) continue;
                this.spawnRewardCrate(world, (Vec3i)bossPos, vault, ctx);
            }
            MiscUtils.broadcast(isBossKill ? this.getBossKillMessage((Player)playerEntity) : this.getEscapeMessage((Player)playerEntity));
            vault.getPlayers().forEach(anyVPlayer -> anyVPlayer.runIfPresent(world.m_142572_(), anySPlayer -> MiscUtils.broadcast(this.getCompletionMessage((Player)anySPlayer))));
        });
    }

    @Override
    protected void addSpecialLoot(ServerLevel world, VaultRaid vault, LootContext context, NonNullList<ItemStack> stacks) {
        super.addSpecialLoot(world, vault, context, stacks);
    }

    private Component getBossKillMessage(Player player) {
        MutableComponent msgContainer = new TextComponent("").m_130940_(ChatFormatting.WHITE);
        MutableComponent playerName = player.m_5446_().m_6881_();
        playerName.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)9974168)));
        return msgContainer.m_7220_((Component)playerName).m_130946_(" defeated Boss!");
    }

    private Component getEscapeMessage(Player player) {
        MutableComponent msgContainer = new TextComponent("").m_130940_(ChatFormatting.WHITE);
        MutableComponent playerName = player.m_5446_().m_6881_();
        playerName.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)9974168)));
        return msgContainer.m_7220_((Component)playerName).m_130946_(" successfully escaped from the Vault!");
    }

    private Component getCompletionMessage(Player player) {
        MutableComponent msgContainer = new TextComponent("").m_130940_(ChatFormatting.WHITE);
        MutableComponent playerName = player.m_5446_().m_6881_();
        playerName.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)9974168)));
        return msgContainer.m_7220_((Component)playerName).m_130946_(" finished building a Vault!");
    }

    private void spawnRewardCrate(ServerLevel world, Vec3i pos, VaultRaid vault, LootContext context) {
        NonNullList<ItemStack> stacks = this.createLoot(world, vault, context);
        ItemStack crate = VaultCrateBlock.getCrateWithLoot(VaultCrateBlock.Type.BOSS, stacks);
        ItemEntity item = new ItemEntity((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), crate);
        item.m_32060_();
        world.m_7967_((Entity)item);
        this.crates.add(new VaultObjective.Crate((List<ItemStack>)stacks));
    }

    public int getTicksUntilNextVote() {
        return this.ticksUntilNextVote;
    }

    public float getCompletedPercent() {
        return Mth.m_14036_((float)((float)this.completedSessions.size() / (float)this.totalRequiredVotes), (float)0.0f, (float)1.0f);
    }

    public void setVotingLocked() {
        this.votingLocked = true;
    }

    public boolean isVotingLocked() {
        return this.votingLocked;
    }

    @Override
    public void setObjectiveTargetCount(int amount) {
        this.totalRequiredVotes = amount;
    }

    @Override
    @Nullable
    public Component getObjectiveTargetDescription(int amount) {
        return new TextComponent("Required amount of votes: ").m_7220_((Component)new TextComponent(String.valueOf(amount)).m_130940_(ChatFormatting.AQUA));
    }

    @Override
    @Nonnull
    public BlockState getObjectiveRelevantBlock(VaultRaid vault, ServerLevel world, BlockPos pos) {
        return ModBlocks.STABILIZER.m_49966_();
    }

    @Override
    @Nullable
    public LootTable getRewardLootTable(VaultRaid vault, Function<ResourceLocation, LootTable> tblResolver) {
        int level = vault.getProperties().getBase(VaultRaid.LEVEL).orElse(0);
        LegacyLootTablesConfig.Level config = ModConfigs.LOOT_TABLES.getForLevel(level);
        return null;
    }

    @Override
    public Component getObjectiveDisplayName() {
        return new TextComponent("Build a Vault").m_130940_(ChatFormatting.AQUA);
    }

    @Override
    public Component getVaultName() {
        return new TextComponent("Architect Vault");
    }

    @Override
    @Nonnull
    public Supplier<? extends VaultGenerator> getVaultGenerator() {
        return VaultRaid.ARCHITECT_GENERATOR;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        if (this.activeSession != null) {
            tag.m_128365_("activeSession", (Tag)this.activeSession.serialize());
        }
        ListTag sessions = new ListTag();
        for (VotingSession session : this.completedSessions) {
            sessions.add((Object)session.serialize());
        }
        tag.m_128365_("completedSessions", (Tag)sessions);
        tag.m_128405_("totalRequiredVotes", this.totalRequiredVotes);
        tag.m_128405_("voteDowntimeTicks", this.voteDowntimeTicks);
        tag.m_128405_("ticksUntilNextVote", this.ticksUntilNextVote);
        tag.m_128379_("votingLocked", this.votingLocked);
        NBTHelper.writeOptional(tag, "bossId", this.bossId, (nbt, uuid) -> nbt.m_128362_("bossId", uuid));
        tag.m_128379_("isBossDead", this.isBossDead);
        tag.m_128365_("exitPortalLocations", (Tag)this.exitPortalLocations.serializeNBT());
        tag.m_128379_("collidedWithExitPortal", this.collidedWithExitPortal);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        this.activeSession = tag.m_128425_("activeSession", 10) ? new VotingSession(tag.m_128469_("activeSession")) : null;
        this.completedSessions.clear();
        ListTag sessions = tag.m_128437_("completedSessions", 10);
        for (int i = 0; i < sessions.size(); ++i) {
            this.completedSessions.add(new VotingSession(sessions.m_128728_(i)));
        }
        this.totalRequiredVotes = tag.m_128451_("totalRequiredVotes");
        this.voteDowntimeTicks = tag.m_128451_("voteDowntimeTicks");
        this.ticksUntilNextVote = tag.m_128451_("ticksUntilNextVote");
        this.votingLocked = tag.m_128471_("votingLocked");
        this.bossId = NBTHelper.readOptional(tag, "bossId", nbt -> nbt.m_128342_("bossId"));
        this.isBossDead = tag.m_128471_("isBossDead");
        this.exitPortalLocations.deserializeNBT(tag.m_128437_("exitPortalLocations", 10));
        this.collidedWithExitPortal = tag.m_128471_("collidedWithExitPortal");
    }
}

