/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.logic.objective.ancient;

import iskallia.vault.block.CryoChamberBlock;
import iskallia.vault.block.VaultCrateBlock;
import iskallia.vault.block.entity.AncientCryoChamberTileEntity;
import iskallia.vault.config.LegacyLootTablesConfig;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.VaultGoalMessage;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.util.PlayerFilter;
import iskallia.vault.world.data.ScheduledItemDropData;
import iskallia.vault.world.vault.VaultRaid;
import iskallia.vault.world.vault.gen.layout.DenseSquareRoomLayout;
import iskallia.vault.world.vault.gen.layout.VaultRoomLayoutGenerator;
import iskallia.vault.world.vault.logic.objective.VaultObjective;
import iskallia.vault.world.vault.logic.objective.ancient.AncientEternalArchive;
import iskallia.vault.world.vault.logic.objective.ancient.AncientEternalReference;
import iskallia.vault.world.vault.logic.task.VaultTask;
import iskallia.vault.world.vault.player.VaultPlayer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkDirection;

public class AncientObjective
extends VaultObjective {
    public static final int MAX_ANCIENTS = 4;
    private int generatedIdentifier = 0;
    private final List<AncientEternalReference> identifiers = new ArrayList<AncientEternalReference>();
    private final List<String> foundEternals = new ArrayList<String>();
    private final Set<BlockPos> placedEternals = new HashSet<BlockPos>();

    public AncientObjective(ResourceLocation id) {
        super(id, VaultTask.EMPTY, VaultTask.EMPTY);
    }

    @Override
    public void initialize(MinecraftServer srv, VaultRaid vault) {
        vault.getProperties().getBase(VaultRaid.HOST).ifPresent(id -> {
            List<AncientEternalReference> ancients = AncientEternalArchive.getAncients(srv, id);
            for (int i = 0; i < Math.min(ancients.size(), 4); ++i) {
                this.identifiers.add(ancients.get(i));
            }
        });
    }

    @Override
    @Nonnull
    public BlockState getObjectiveRelevantBlock(VaultRaid vault, ServerLevel world, BlockPos pos) {
        return (BlockState)ModBlocks.CRYO_CHAMBER.m_49966_().m_61124_(CryoChamberBlock.CHAMBER_STATE, (Comparable)((Object)CryoChamberBlock.ChamberState.RUSTY));
    }

    @Override
    public void postProcessObjectiveRelevantBlock(ServerLevel world, BlockPos pos) {
        if (this.generatedIdentifier >= this.identifiers.size()) {
            return;
        }
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof AncientCryoChamberTileEntity) {
            world.m_7731_(pos.m_7494_(), (BlockState)((BlockState)ModBlocks.CRYO_CHAMBER.m_49966_().m_61124_(CryoChamberBlock.HALF, (Comparable)DoubleBlockHalf.UPPER)).m_61124_(CryoChamberBlock.CHAMBER_STATE, (Comparable)((Object)CryoChamberBlock.ChamberState.RUSTY)), 3);
            AncientEternalReference identifier = this.identifiers.get(this.generatedIdentifier);
            AncientCryoChamberTileEntity cryoChamber = (AncientCryoChamberTileEntity)te;
            cryoChamber.setEternalName(identifier.getName());
            this.placedEternals.add(pos);
            ++this.generatedIdentifier;
        }
    }

    @Override
    public int modifyObjectiveCount(int objectives) {
        return this.identifiers.size();
    }

    @Override
    public void notifyBail(VaultRaid vault, VaultPlayer player, ServerLevel world) {
        if (!this.foundEternals.isEmpty()) {
            this.setCompleted();
            player.runIfPresent(world.m_142572_(), sPlayer -> {
                ScheduledItemDropData.get(world).addDrop((Player)sPlayer, this.getRewardCrate((ServerPlayer)sPlayer, vault));
                TextComponent ct = new TextComponent("");
                ct.m_7220_((Component)sPlayer.m_5446_().m_6881_().m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)9974168))));
                ct.m_130946_(" rescued ");
                for (int i = 0; i < this.foundEternals.size(); ++i) {
                    if (i != 0) {
                        ct.m_130946_(", ");
                    }
                    ct.m_7220_((Component)new TextComponent(this.foundEternals.get(i)).m_130940_(ChatFormatting.GOLD));
                }
                ct.m_130946_("!");
                MiscUtils.broadcast((Component)ct);
            });
        }
    }

    private ItemStack getRewardCrate(ServerPlayer sPlayer, VaultRaid vault) {
        ServerLevel world = sPlayer.m_183503_();
        BlockPos pos = sPlayer.m_142538_();
        LootContext.Builder builder = new LootContext.Builder(world).m_78977_(world.f_46441_).m_78972_(LootContextParams.f_81455_, (Object)sPlayer).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_78963_(sPlayer.m_36336_());
        LootContext ctx = builder.m_78975_(LootContextParamSets.f_81411_);
        NonNullList<ItemStack> stacks = this.createLoot(world, vault, ctx);
        ItemStack crate = VaultCrateBlock.getCrateWithLoot(VaultCrateBlock.Type.BOSS, stacks);
        this.crates.add(new VaultObjective.Crate((List<ItemStack>)stacks));
        return crate;
    }

    @Override
    @Nullable
    public LootTable getRewardLootTable(VaultRaid vault, Function<ResourceLocation, LootTable> tblResolver) {
        int level = vault.getProperties().getBase(VaultRaid.LEVEL).orElse(0);
        LegacyLootTablesConfig.Level config = ModConfigs.LOOT_TABLES.getForLevel(level);
        return null;
    }

    @Override
    protected void addSpecialLoot(ServerLevel world, VaultRaid vault, LootContext context, NonNullList<ItemStack> stacks) {
        int level = vault.getProperties().getBase(VaultRaid.LEVEL).orElse(0);
        LegacyLootTablesConfig.Level config = ModConfigs.LOOT_TABLES.getForLevel(level);
        LootTable ancientTable = world.m_142572_().m_129898_().m_79217_(config.getAncientEternalBonusBox());
        for (String eternalName : this.foundEternals) {
            NonNullList ancientLoot = NonNullList.m_122779_();
            ancientLoot.addAll((Collection)ancientTable.m_79129_(context));
            Collections.shuffle(ancientLoot);
            ItemStack box = new ItemStack((ItemLike)Items.f_42229_);
            ContainerHelper.m_18973_((CompoundTag)box.m_41698_("BlockEntityTag"), (NonNullList)ancientLoot);
            box.m_41714_((Component)new TextComponent(eternalName).m_130940_(ChatFormatting.GOLD));
            stacks.add((Object)box);
        }
    }

    @Override
    public Component getVaultName() {
        return new TextComponent("Ancient Vault").m_130940_(ChatFormatting.DARK_AQUA);
    }

    @Override
    public Component getObjectiveDisplayName() {
        return new TextComponent("Ancient Vault").m_130940_(ChatFormatting.DARK_AQUA);
    }

    @Override
    @Nullable
    public VaultRoomLayoutGenerator getCustomLayout() {
        return new DenseSquareRoomLayout(19);
    }

    @Override
    public int getVaultTimerStart(int vaultTime) {
        return 18000;
    }

    @Override
    public boolean preventsEatingExtensionFruit(MinecraftServer srv, VaultRaid vault) {
        return true;
    }

    @Override
    public void tick(VaultRaid vault, PlayerFilter filter, ServerLevel world) {
        super.tick(vault, filter, world);
        MinecraftServer srv = world.m_142572_();
        vault.getPlayers().stream().filter(vPlayer -> filter.test(vPlayer.getPlayerId())).forEach(vPlayer -> vPlayer.runIfPresent(srv, playerEntity -> {
            VaultGoalMessage pkt = VaultGoalMessage.ancientsHunt(this.identifiers.size(), this.foundEternals.size());
            ModNetwork.CHANNEL.sendTo((Object)pkt, playerEntity.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }));
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        ListTag ancients = new ListTag();
        this.identifiers.forEach(ancient -> ancients.add((Object)ancient.serialize()));
        tag.m_128365_("ancients", (Tag)ancients);
        ListTag placed = new ListTag();
        this.placedEternals.forEach(pos -> {
            CompoundTag posTag = new CompoundTag();
            posTag.m_128405_("x", pos.m_123341_());
            posTag.m_128405_("y", pos.m_123342_());
            posTag.m_128405_("z", pos.m_123343_());
            placed.add((Object)posTag);
        });
        tag.m_128365_("placed", (Tag)placed);
        ListTag found = new ListTag();
        this.foundEternals.forEach(name -> found.add((Object)StringTag.m_129297_((String)name)));
        tag.m_128365_("found", (Tag)found);
        tag.m_128405_("generatedIdentifier", this.generatedIdentifier);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        this.identifiers.clear();
        ListTag ancients = tag.m_128437_("ancients", 10);
        for (int i = 0; i < ancients.size(); ++i) {
            CompoundTag ancientTag = ancients.m_128728_(i);
            this.identifiers.add(AncientEternalReference.deserialize(ancientTag));
        }
        this.placedEternals.clear();
        ListTag placed = tag.m_128437_("placed", 10);
        for (int i = 0; i < placed.size(); ++i) {
            CompoundTag posTag = placed.m_128728_(i);
            this.placedEternals.add(new BlockPos(posTag.m_128451_("x"), posTag.m_128451_("y"), posTag.m_128451_("z")));
        }
        this.foundEternals.clear();
        ListTag found = tag.m_128437_("found", 8);
        for (int i = 0; i < found.size(); ++i) {
            this.foundEternals.add(found.m_128778_(i));
        }
        this.generatedIdentifier = tag.m_128451_("generatedIdentifier");
    }
}

