/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.logic.objective;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import iskallia.vault.block.item.LootStatueBlockItem;
import iskallia.vault.config.LegacyLootTablesConfig;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.nbt.VListNBT;
import iskallia.vault.util.PlayerFilter;
import iskallia.vault.world.data.EternalsData;
import iskallia.vault.world.vault.VaultRaid;
import iskallia.vault.world.vault.gen.VaultGenerator;
import iskallia.vault.world.vault.gen.layout.VaultRoomLayoutGenerator;
import iskallia.vault.world.vault.logic.task.IVaultTask;
import iskallia.vault.world.vault.logic.task.VaultTask;
import iskallia.vault.world.vault.modifier.VaultModifiers;
import iskallia.vault.world.vault.modifier.modifier.ChanceArtifactModifier;
import iskallia.vault.world.vault.modifier.modifier.PlayerInventoryRestoreModifier;
import iskallia.vault.world.vault.modifier.spi.AbstractChanceModifier;
import iskallia.vault.world.vault.player.VaultPlayer;
import iskallia.vault.world.vault.player.VaultRunner;
import iskallia.vault.world.vault.time.VaultTimer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class VaultObjective
implements INBTSerializable<CompoundTag>,
IVaultTask {
    public static final BiMap<ResourceLocation, Supplier<? extends VaultObjective>> REGISTRY = HashBiMap.create();
    public static final float COOP_DOUBLE_CRATE_CHANCE = 0.5f;
    protected static final Random rand = new Random();
    private ResourceLocation id;
    private VaultTask onTick;
    private VaultTask onComplete;
    private boolean completed;
    private int completionTime = -1;
    protected VListNBT<Crate, CompoundTag> crates = VListNBT.of(Crate::new);

    protected VaultObjective() {
    }

    public VaultObjective(ResourceLocation id, VaultTask onTick, VaultTask onComplete) {
        this.id = id;
        this.onTick = onTick;
        this.onComplete = onComplete;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public void initialize(MinecraftServer srv, VaultRaid vault) {
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public int getCompletionTime() {
        return this.completionTime;
    }

    public void setCompleted() {
        this.completed = true;
    }

    public void setCompletionTime(int completionTime) {
        this.completionTime = completionTime;
    }

    public void setObjectiveTargetCount(int amount) {
    }

    @Nullable
    public Component getObjectiveTargetDescription(int amount) {
        return null;
    }

    @Nonnull
    public abstract BlockState getObjectiveRelevantBlock(VaultRaid var1, ServerLevel var2, BlockPos var3);

    public void postProcessObjectiveRelevantBlock(ServerLevel world, BlockPos pos) {
    }

    @Nullable
    public abstract LootTable getRewardLootTable(VaultRaid var1, Function<ResourceLocation, LootTable> var2);

    public abstract Component getObjectiveDisplayName();

    @Nonnull
    public Supplier<? extends VaultGenerator> getVaultGenerator() {
        return VaultRaid.SINGLE_STAR;
    }

    @Nullable
    public VaultRoomLayoutGenerator getCustomLayout() {
        return null;
    }

    public Component getVaultName() {
        return new TextComponent("Vault");
    }

    @Deprecated
    public int getMaxObjectivePlacements() {
        return 10;
    }

    public int modifyObjectiveCount(int objectives) {
        return objectives;
    }

    public Collection<Crate> getCrates() {
        return this.crates;
    }

    public boolean shouldPauseTimer(MinecraftServer srv, VaultRaid vault) {
        return vault.getPlayers().stream().noneMatch(vPlayer -> vPlayer.isOnline(srv));
    }

    public int getVaultTimerStart(int vaultTime) {
        return vaultTime;
    }

    public boolean preventsEatingExtensionFruit(MinecraftServer srv, VaultRaid vault) {
        return this.isCompleted();
    }

    public boolean preventsMobSpawning() {
        return false;
    }

    public boolean preventsTrappedChests() {
        return false;
    }

    public boolean preventsInfluences() {
        return false;
    }

    public boolean preventsNormalMonsterDrops() {
        return false;
    }

    public boolean preventsCatalystFragments() {
        return false;
    }

    public void notifyBail(VaultRaid vault, VaultPlayer player, ServerLevel world) {
    }

    public void tick(VaultRaid vault, PlayerFilter filter, ServerLevel world) {
        if (this.isCompleted()) {
            return;
        }
        vault.getPlayers().forEach(vPlayer -> {
            if (filter.test(vPlayer.getPlayerId())) {
                this.onTick.execute(vault, (VaultPlayer)vPlayer, world);
            }
        });
    }

    @Override
    public void execute(VaultRaid vault, VaultPlayer player, ServerLevel world) {
        this.onComplete.execute(vault, player, world);
    }

    public void complete(VaultRaid vault, VaultPlayer player, ServerLevel world) {
        this.onComplete.execute(vault, player, world);
    }

    public void complete(VaultRaid vault, ServerLevel world) {
        vault.getPlayers().forEach(player -> this.onComplete.execute(vault, (VaultPlayer)player, world));
    }

    public VaultObjective thenTick(VaultTask task) {
        this.onTick = this.onTick == VaultTask.EMPTY ? task : this.onTick.then(task);
        return this;
    }

    public VaultObjective thenComplete(VaultTask task) {
        this.onComplete = this.onComplete == VaultTask.EMPTY ? task : this.onComplete.then(task);
        return this;
    }

    protected NonNullList<ItemStack> createLoot(ServerLevel world, VaultRaid vault, LootContext context) {
        LootTable rewardLootTable = this.getRewardLootTable(vault, arg_0 -> ((LootTables)world.m_142572_().m_129898_()).m_79217_(arg_0));
        if (rewardLootTable == null) {
            return NonNullList.m_122779_();
        }
        NonNullList stacks = NonNullList.m_122779_();
        NonNullList specialLoot = NonNullList.m_122779_();
        this.addSpecialLoot(world, vault, context, (NonNullList<ItemStack>)specialLoot);
        stacks.addAll((Collection)rewardLootTable.m_79129_(context));
        vault.getPlayers().stream().filter(player -> player instanceof VaultRunner).findAny().ifPresent(vPlayer -> {
            VaultTimer timer = vPlayer.getTimer();
            float pTimeLeft = Mth.m_14036_((float)(1.0f - (float)timer.getRunTime() / (float)timer.getTotalTime()), (float)0.0f, (float)1.0f);
            ArrayList additionalLoot = new ArrayList();
            additionalLoot.addAll(rewardLootTable.m_79129_(context));
            additionalLoot.addAll(rewardLootTable.m_79129_(context));
            int rolls = Math.round((float)additionalLoot.size() * pTimeLeft);
            if (rolls > 0) {
                stacks.addAll(additionalLoot.subList(0, rolls));
            }
        });
        stacks.removeIf(ItemStack::m_41619_);
        for (int i = 0; i < stacks.size() - 54 + specialLoot.size(); ++i) {
            stacks.remove(world.f_46441_.nextInt(stacks.size()));
        }
        stacks.addAll((Collection)specialLoot);
        Collections.shuffle(stacks);
        return stacks;
    }

    protected void addSpecialLoot(ServerLevel world, VaultRaid vault, LootContext context, NonNullList<ItemStack> stacks) {
        boolean cannotGetArtifact;
        int level = vault.getProperties().getBase(VaultRaid.LEVEL).orElse(0);
        LegacyLootTablesConfig.Level config = ModConfigs.LOOT_TABLES.getForLevel(level);
        int eternals = EternalsData.get(world).getTotalEternals();
        if (eternals > 0) {
            stacks.add((Object)new ItemStack((ItemLike)ModItems.ETERNAL_SOUL, Math.min(world.f_46441_.nextInt(eternals) + 1, 64)));
        }
        if (vault.getProperties().getBase(VaultRaid.IS_RAFFLE).orElse(false).booleanValue()) {
            String name = vault.getProperties().getValue(VaultRaid.PLAYER_BOSS_NAME);
            stacks.add((Object)LootStatueBlockItem.getStatueBlockItem(name));
            if (world.f_46441_.nextInt(4) != 0) {
                // empty if block
            }
        }
        if (!(cannotGetArtifact = vault.hasActiveModifierFor(PlayerFilter.any(), PlayerInventoryRestoreModifier.class, m -> ((PlayerInventoryRestoreModifier.Properties)m.properties()).preventsArtifact())) && config != null) {
            float chance = config.getArtifactChance();
            for (VaultModifiers.ActiveModifierStack<ChanceArtifactModifier> activeModifier : vault.getActiveModifiersFor(PlayerFilter.any(), ChanceArtifactModifier.class)) {
                chance += ((AbstractChanceModifier.Properties)activeModifier.getModifier().properties()).getChance() * (float)activeModifier.getSize();
            }
            if (vault.getProperties().getBaseOrDefault(VaultRaid.COW_VAULT, false).booleanValue()) {
                chance *= 2.0f;
            }
            if (world.m_5822_().nextFloat() < chance) {
                stacks.add((Object)new ItemStack((ItemLike)ModItems.UNIDENTIFIED_ARTIFACT));
            }
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("Id", this.getId().toString());
        nbt.m_128379_("Completed", this.isCompleted());
        nbt.m_128365_("OnTick", (Tag)this.onTick.serializeNBT());
        nbt.m_128365_("OnComplete", (Tag)this.onComplete.serializeNBT());
        if (this.getCompletionTime() != -1) {
            nbt.m_128405_("CompletionTime", this.getCompletionTime());
        }
        nbt.m_128365_("Crates", (Tag)this.crates.serializeNBT());
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.id = new ResourceLocation(nbt.m_128461_("Id"));
        this.completed = nbt.m_128471_("Completed");
        this.onTick = VaultTask.fromNBT(nbt.m_128469_("OnTick"));
        this.onComplete = VaultTask.fromNBT(nbt.m_128469_("OnComplete"));
        if (nbt.m_128425_("CompletionTime", 3)) {
            this.completionTime = nbt.m_128451_("CompletionTime");
        }
        this.crates.deserializeNBT(nbt.m_128437_("Crates", 10));
    }

    public static VaultObjective fromNBT(CompoundTag nbt) {
        VaultObjective objective = (VaultObjective)((Supplier)REGISTRY.get((Object)new ResourceLocation(nbt.m_128461_("Id")))).get();
        objective.deserializeNBT(nbt);
        return objective;
    }

    @Nullable
    public static VaultObjective getObjective(ResourceLocation key) {
        return (VaultObjective)((Supplier)REGISTRY.getOrDefault((Object)key, () -> null)).get();
    }

    public static <T extends VaultObjective> Supplier<T> register(Supplier<T> objective) {
        REGISTRY.put((Object)((VaultObjective)objective.get()).getId(), objective);
        return objective;
    }

    public static class Crate
    implements INBTSerializable<CompoundTag> {
        private List<ItemStack> contents = new ArrayList<ItemStack>();

        private Crate() {
        }

        public Crate(List<ItemStack> contents) {
            this.contents = contents;
        }

        public List<ItemStack> getContents() {
            return this.contents;
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            ListTag contentsList = new ListTag();
            this.contents.forEach(stack -> contentsList.add((Object)stack.m_41739_(new CompoundTag())));
            nbt.m_128365_("Contents", (Tag)contentsList);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.contents.clear();
            ListTag contentsList = nbt.m_128437_("Contents", 10);
            contentsList.stream().map(inbt -> (CompoundTag)inbt).forEach(compoundNBT -> this.contents.add(ItemStack.m_41712_((CompoundTag)compoundNBT)));
        }
    }
}

