/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.logic.objective;

import iskallia.vault.init.ModConfigs;
import iskallia.vault.world.vault.VaultRaid;
import iskallia.vault.world.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.world.vault.modifier.spi.VaultModifier;
import iskallia.vault.world.vault.player.VaultPlayer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;

public class VaultModifierVotingSession {
    private int votingDuration = 600;
    private final LinkedHashMap<ResourceLocation, Integer> modifierOptions = new LinkedHashMap();
    private final Set<String> votedPlayers = new HashSet<String>();

    public static VaultModifierVotingSession create() {
        VaultModifierVotingSession session = new VaultModifierVotingSession();
        Random rand = new Random();
        int amount = 2 + (rand.nextFloat() < 0.2f ? 1 : 0);
        for (int i = 0; i < amount; ++i) {
            ResourceLocation modifierId;
            while (session.modifierOptions.containsKey(modifierId = ModConfigs.RAID_EVENT_CONFIG.getRandomModifier().getId())) {
            }
            session.modifierOptions.put(modifierId, 0);
        }
        return session;
    }

    public List<ResourceLocation> getModifierIds() {
        return new ArrayList<ResourceLocation>(this.modifierOptions.keySet());
    }

    public List<VaultModifier> getModifiers() {
        return this.getModifierIds().stream().map(VaultModifierRegistry::getOpt).flatMap(Optional::stream).collect(Collectors.toList());
    }

    public int getVotingDuration() {
        return this.votingDuration;
    }

    public void addVote(String player, String modifierName) {
        if (this.votedPlayers.contains(player)) {
            return;
        }
        VaultModifier vaultModifier = VaultModifierRegistry.getAll().filter(group -> group.getDisplayName().equalsIgnoreCase(modifierName)).findFirst().orElse(null);
        if (vaultModifier == null) {
            return;
        }
        ResourceLocation modifierId = vaultModifier.getId();
        if (!this.modifierOptions.containsKey(modifierId)) {
            return;
        }
        int amount = this.modifierOptions.getOrDefault(modifierId, 0);
        this.modifierOptions.put(modifierId, amount + 1);
        this.votedPlayers.add(player);
    }

    public void tick() {
        --this.votingDuration;
    }

    public boolean isFinished() {
        return this.votingDuration <= 0;
    }

    public void finish(VaultRaid vault, ServerLevel world) {
        ResourceLocation voted = this.getVotedModifier();
        if (voted == null) {
            return;
        }
        VaultModifier modifier = VaultModifierRegistry.getOpt(voted).orElse(null);
        if (modifier == null) {
            return;
        }
        int minutes = ModConfigs.RAID_EVENT_CONFIG.getTemporaryModifierMinutes();
        MutableComponent ct = new TextComponent("Added ").m_130940_(ChatFormatting.GRAY).m_7220_(modifier.getNameComponent()).m_7220_((Component)new TextComponent(" for ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)new TextComponent(minutes + " minutes!").m_130940_(ChatFormatting.GOLD));
        vault.getModifiers().addTemporaryModifier(modifier, 1, minutes * 60 * 20);
        vault.getPlayers().forEach(arg_0 -> VaultModifierVotingSession.lambda$finish$2(world, (Component)ct, arg_0));
    }

    @Nullable
    public ResourceLocation getVotedModifier() {
        ArrayList<ResourceLocation> modifiers = new ArrayList<ResourceLocation>(this.modifierOptions.keySet());
        Collections.shuffle(modifiers);
        int max = -1;
        ResourceLocation selectedModifier = null;
        for (ResourceLocation modifier : modifiers) {
            int amount = this.modifierOptions.getOrDefault(modifier, 0);
            if (amount <= max) continue;
            selectedModifier = modifier;
            max = amount;
        }
        return selectedModifier;
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("votingDuration", this.votingDuration);
        CompoundTag votes = new CompoundTag();
        this.modifierOptions.forEach((resourceLocation, integer) -> votes.m_128405_(resourceLocation.toString(), integer.intValue()));
        tag.m_128365_("votes", (Tag)votes);
        ListTag players = new ListTag();
        this.votedPlayers.forEach(player -> players.add((Object)StringTag.m_129297_((String)player)));
        tag.m_128365_("players", (Tag)players);
        return tag;
    }

    public static VaultModifierVotingSession deserialize(CompoundTag tag) {
        VaultModifierVotingSession session = new VaultModifierVotingSession();
        session.votingDuration = tag.m_128451_("votingDuration");
        CompoundTag votes = tag.m_128469_("votes");
        votes.m_128431_().forEach(key -> session.modifierOptions.put(new ResourceLocation(key), votes.m_128451_(key)));
        ListTag players = tag.m_128437_("players", 8);
        for (int i = 0; i < players.size(); ++i) {
            session.votedPlayers.add(players.m_128778_(i));
        }
        return session;
    }

    private static /* synthetic */ void lambda$finish$2(ServerLevel world, Component ct, VaultPlayer vPlayer) {
        vPlayer.runIfPresent(world.m_142572_(), sPlayer -> sPlayer.m_6352_(ct, Util.f_137441_));
    }
}

