/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.logic.objective;

import iskallia.vault.block.VaultCrateBlock;
import iskallia.vault.config.LegacyLootTablesConfig;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.BossMusicMessage;
import iskallia.vault.network.message.VaultGoalMessage;
import iskallia.vault.util.PlayerFilter;
import iskallia.vault.world.data.DiscoveredModelsData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import iskallia.vault.world.vault.VaultRaid;
import iskallia.vault.world.vault.logic.objective.VaultObjective;
import iskallia.vault.world.vault.logic.task.VaultTask;
import iskallia.vault.world.vault.player.VaultPlayer;
import iskallia.vault.world.vault.player.VaultRunner;
import iskallia.vault.world.vault.time.VaultTimer;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.network.NetworkDirection;

public class SummonAndKillBossObjective
extends VaultObjective {
    protected int progressCount;
    protected int targetCount = rand.nextInt(4) + 3;
    protected UUID bossId = null;
    protected Component bossName = null;
    protected Vec3 bossPos = null;
    protected boolean isBossDead = false;

    public SummonAndKillBossObjective(ResourceLocation id) {
        super(id, VaultTask.EMPTY, VaultTask.EMPTY);
    }

    public boolean allObelisksClicked() {
        return this.progressCount >= this.targetCount;
    }

    public void addObelisk() {
        ++this.progressCount;
    }

    public UUID getBossId() {
        return this.bossId;
    }

    public boolean isBossDead() {
        return this.isBossDead;
    }

    public boolean isBossSpawned() {
        return this.bossId != null;
    }

    public Component getBossName() {
        return this.bossName;
    }

    public Vec3 getBossPos() {
        return this.bossPos;
    }

    public void setBoss(LivingEntity boss) {
        this.bossId = boss.m_142081_();
    }

    @Override
    public void setObjectiveTargetCount(int amount) {
        this.targetCount = amount;
    }

    @Override
    @Nullable
    public Component getObjectiveTargetDescription(int amount) {
        return new TextComponent("Required Obelisks: ").m_7220_((Component)new TextComponent(String.valueOf(amount)).m_130940_(ChatFormatting.GOLD));
    }

    @Override
    @Nonnull
    public BlockState getObjectiveRelevantBlock(VaultRaid vault, ServerLevel world, BlockPos pos) {
        return ModBlocks.OBELISK.m_49966_();
    }

    @Override
    @Nullable
    public LootTable getRewardLootTable(VaultRaid vault, Function<ResourceLocation, LootTable> tblResolver) {
        int level = vault.getProperties().getBase(VaultRaid.LEVEL).orElse(0);
        LegacyLootTablesConfig.Level config = ModConfigs.LOOT_TABLES.getForLevel(level);
        return null;
    }

    @Override
    public Component getObjectiveDisplayName() {
        return new TextComponent("Kill the Boss").m_130940_(ChatFormatting.GOLD);
    }

    @Override
    public void tick(VaultRaid vault, PlayerFilter filter, ServerLevel world) {
        super.tick(vault, filter, world);
        if (this.isCompleted()) {
            return;
        }
        vault.getPlayers().stream().filter(vPlayer -> filter.test(vPlayer.getPlayerId())).forEach(vPlayer -> {
            vPlayer.runIfPresent(world.m_142572_(), playerEntity -> {
                VaultGoalMessage pkt = this.allObelisksClicked() ? VaultGoalMessage.killBossGoal() : VaultGoalMessage.obeliskGoal(this.progressCount, this.targetCount);
                ModNetwork.CHANNEL.sendTo((Object)pkt, playerEntity.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            });
            if (this.isBossSpawned()) {
                vPlayer.sendIfPresent(world.m_142572_(), new BossMusicMessage(true));
            }
        });
        if (this.isBossDead) {
            this.setCompleted();
        }
    }

    @Override
    public void complete(VaultRaid vault, VaultPlayer player, ServerLevel world) {
        super.complete(vault, player, world);
        player.sendIfPresent(world.m_142572_(), new BossMusicMessage(false));
        player.sendIfPresent(world.m_142572_(), VaultGoalMessage.clear());
    }

    @Override
    public void complete(VaultRaid vault, ServerLevel world) {
        super.complete(vault, world);
        vault.getPlayers().forEach(player -> {
            player.sendIfPresent(world.m_142572_(), new BossMusicMessage(false));
            player.sendIfPresent(world.m_142572_(), VaultGoalMessage.clear());
        });
    }

    public void spawnBossLoot(VaultRaid vault, VaultPlayer player, ServerLevel world) {
        player.runIfPresent(world.m_142572_(), playerEntity -> {
            LootContext.Builder builder = new LootContext.Builder(world).m_78977_(world.f_46441_).m_78972_(LootContextParams.f_81455_, playerEntity).m_78972_(LootContextParams.f_81460_, (Object)this.getBossPos()).m_78972_(LootContextParams.f_81457_, (Object)DamageSource.m_19344_((Player)playerEntity)).m_78984_(LootContextParams.f_81458_, playerEntity).m_78984_(LootContextParams.f_81459_, playerEntity).m_78972_(LootContextParams.f_81456_, playerEntity).m_78963_(playerEntity.m_36336_());
            LootContext ctx = builder.m_78975_(LootContextParamSets.f_81415_);
            this.dropBossCrate(world, vault, player, ctx);
            for (int i = 1; i < vault.getPlayers().size(); ++i) {
                if (!(rand.nextFloat() < 0.5f)) continue;
                this.dropBossCrate(world, vault, player, ctx);
            }
            world.m_142572_().m_6846_().m_11264_(this.getBossKillMessage((Player)playerEntity), ChatType.CHAT, player.getPlayerId());
        });
    }

    private Component getBossKillMessage(Player player) {
        MutableComponent msgContainer = new TextComponent("").m_130940_(ChatFormatting.WHITE);
        MutableComponent playerName = player.m_5446_().m_6881_();
        playerName.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)9974168)));
        return msgContainer.m_7220_((Component)playerName).m_130946_(" defeated ").m_7220_(this.getBossName()).m_130946_("!");
    }

    private void dropBossCrate(ServerLevel world, VaultRaid vault, VaultPlayer rewardPlayer, LootContext context) {
        NonNullList<ItemStack> stacks = this.createLoot(world, vault, context);
        vault.getProperties().getBase(VaultRaid.IS_RAFFLE).ifPresent(isRaffle -> {
            if (!isRaffle.booleanValue()) {
                return;
            }
            vault.getPlayers().stream().filter(player -> player instanceof VaultRunner).min(Comparator.comparing(vPlayer -> vPlayer.getTimer().getTimeLeft())).ifPresent(vPlayer -> {
                VaultTimer timer = vPlayer.getTimer();
                PlayerVaultStatsData data = PlayerVaultStatsData.get(world);
                if (timer.getRunTime() < data.getFastestVaultTime().getTickCount()) {
                    vPlayer.runIfPresent(world.m_142572_(), sPlayer -> data.updateFastestVaultTime((Player)sPlayer, timer.getRunTime()));
                }
            });
        });
        BlockPos dropPos = rewardPlayer.getServerPlayer(world.m_142572_()).map(Entity::m_142538_).orElse(new BlockPos(this.getBossPos()));
        ItemStack crate = VaultCrateBlock.getCrateWithLoot(VaultCrateBlock.Type.BOSS, stacks);
        ItemEntity item = new ItemEntity((Level)world, (double)dropPos.m_123341_(), (double)dropPos.m_123342_(), (double)dropPos.m_123343_(), crate);
        item.m_32060_();
        world.m_7967_((Entity)item);
        this.crates.add(new VaultObjective.Crate((List<ItemStack>)stacks));
    }

    protected void onBossDeath(LivingDeathEvent event, VaultRaid vault, ServerLevel world, boolean dropCrate) {
        boolean isCowVault;
        MinecraftServer srv = world.m_142572_();
        LivingEntity boss = event.getEntityLiving();
        if (!boss.m_142081_().equals(this.getBossId())) {
            return;
        }
        this.bossName = boss.m_7770_();
        this.bossPos = boss.m_20182_();
        this.isBossDead = true;
        if (dropCrate) {
            Optional<UUID> source = Optional.ofNullable(event.getSource().m_7639_()).map(Entity::m_142081_);
            Optional killer = source.flatMap(vault::getPlayer);
            Optional host = vault.getProperties().getBase(VaultRaid.HOST).flatMap(vault::getPlayer);
            if (killer.isPresent()) {
                this.spawnBossLoot(vault, (VaultPlayer)killer.get(), world);
            } else if (host.isPresent() && host.get() instanceof VaultRunner) {
                this.spawnBossLoot(vault, (VaultPlayer)host.get(), world);
            } else {
                vault.getPlayers().stream().filter(player -> player instanceof VaultRunner).findFirst().ifPresent(player -> this.spawnBossLoot(vault, (VaultPlayer)player, world));
            }
        }
        if (isCowVault = vault.getProperties().getBaseOrDefault(VaultRaid.COW_VAULT, false).booleanValue()) {
            DiscoveredModelsData discoveredModelsData = DiscoveredModelsData.get(world);
            vault.getPlayers().forEach(vPlayer -> vPlayer.runIfPresent(srv, serverPlayer -> discoveredModelsData.discoverAllArmorPieceAndBroadcast((Player)serverPlayer, ModDynamicModels.Armor.HELL_COW)));
        }
    }

    public static boolean isBossInVault(VaultRaid vault, LivingEntity entity) {
        List<SummonAndKillBossObjective> matchingObjectives = vault.getPlayers().stream().map(player -> player.getActiveObjective(SummonAndKillBossObjective.class)).flatMap(Optional::stream).filter(o -> !o.isCompleted()).filter(SummonAndKillBossObjective::allObelisksClicked).filter(o -> o.getBossId().equals(entity.m_142081_())).toList();
        vault.getActiveObjective(SummonAndKillBossObjective.class).ifPresent(matchingObjectives::add);
        return matchingObjectives.stream().anyMatch(o -> entity.m_142081_().equals(o.getBossId()));
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        nbt.m_128405_("ProgressCount", this.progressCount);
        nbt.m_128405_("TargetCount", this.targetCount);
        if (this.getBossId() != null) {
            nbt.m_128359_("BossId", this.getBossId().toString());
        }
        if (this.getBossName() != null) {
            nbt.m_128359_("BossName", Component.Serializer.m_130703_((Component)this.getBossName()));
        }
        if (this.getBossPos() != null) {
            nbt.m_128347_("BossPosX", this.getBossPos().m_7096_());
            nbt.m_128347_("BossPosY", this.getBossPos().m_7098_());
            nbt.m_128347_("BossPosZ", this.getBossPos().m_7094_());
        }
        nbt.m_128379_("IsBossDead", this.isBossDead());
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        this.progressCount = nbt.m_128451_("ProgressCount");
        this.targetCount = nbt.m_128451_("TargetCount");
        if (nbt.m_128425_("BossId", 8)) {
            this.bossId = UUID.fromString(nbt.m_128461_("BossId"));
        }
        if (nbt.m_128425_("BossName", 8)) {
            this.bossName = Component.Serializer.m_130701_((String)nbt.m_128461_("BossName"));
        }
        this.bossPos = new Vec3(nbt.m_128459_("BossPosX"), nbt.m_128459_("BossPosY"), nbt.m_128459_("BossPosZ"));
        this.isBossDead = nbt.m_128471_("IsBossDead");
    }
}

