/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.logic.objective;

import iskallia.vault.config.LegacyLootTablesConfig;
import iskallia.vault.config.VaultModifierPoolsConfig;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.nbt.VListNBT;
import iskallia.vault.network.message.BossMusicMessage;
import iskallia.vault.network.message.VaultGoalMessage;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.util.PlayerFilter;
import iskallia.vault.world.vault.VaultRaid;
import iskallia.vault.world.vault.logic.objective.VaultObjective;
import iskallia.vault.world.vault.logic.task.VaultTask;
import iskallia.vault.world.vault.modifier.spi.VaultModifier;
import iskallia.vault.world.vault.player.VaultPlayer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraftforge.network.NetworkDirection;

public class SummonAndKillAllBossesObjective
extends VaultObjective {
    protected int progressCount;
    protected int bossesCount;
    protected int targetCount = 10;
    protected VListNBT<UUID, StringTag> bosses = VListNBT.ofUUID();

    public SummonAndKillAllBossesObjective(ResourceLocation id) {
        super(id, VaultTask.EMPTY, VaultTask.EMPTY);
    }

    public boolean allObelisksClicked() {
        return this.progressCount >= this.targetCount;
    }

    public boolean allBossesDefeated() {
        return this.bossesCount >= this.targetCount;
    }

    public void addObelisk() {
        ++this.progressCount;
    }

    public void completeBoss(VaultRaid vault, ServerLevel world, UUID uuid) {
        if (!this.bosses.remove(uuid)) {
            return;
        }
        ++this.bossesCount;
        if (this.bossesCount >= this.targetCount) {
            return;
        }
        int level = vault.getProperties().getValue(VaultRaid.LEVEL);
        Set<VaultModifier<?>> modifiers = ModConfigs.VAULT_MODIFIER_POOLS.getRandom(rand, level, VaultModifierPoolsConfig.ModifierPoolType.FINAL_TENOS_ADDS, this.getId());
        ArrayList modifierList = new ArrayList(modifiers);
        Collections.shuffle(modifierList);
        VaultModifier<?> modifier = MiscUtils.getRandomEntry(modifierList, rand);
        if (modifier != null) {
            MutableComponent ct = new TextComponent("Added ").m_130940_(ChatFormatting.GRAY).m_7220_(modifier.getNameComponent());
            vault.getModifiers().addPermanentModifier(modifier, 1);
            vault.getPlayers().forEach(arg_0 -> SummonAndKillAllBossesObjective.lambda$completeBoss$1(world, (Component)ct, arg_0));
        }
    }

    public void addBoss(LivingEntity boss) {
        this.bosses.add(boss.m_142081_());
    }

    @Override
    public void setObjectiveTargetCount(int amount) {
        this.targetCount = amount;
    }

    @Override
    @Nullable
    public Component getObjectiveTargetDescription(int amount) {
        return new TextComponent("Find Obelisks: ").m_7220_((Component)new TextComponent(String.valueOf(amount)).m_130940_(ChatFormatting.GOLD));
    }

    @Override
    @Nonnull
    public BlockState getObjectiveRelevantBlock(VaultRaid vault, ServerLevel world, BlockPos pos) {
        return ModBlocks.OBELISK.m_49966_();
    }

    @Override
    @Nullable
    public LootTable getRewardLootTable(VaultRaid vault, Function<ResourceLocation, LootTable> tblResolver) {
        int level = vault.getProperties().getBase(VaultRaid.LEVEL).orElse(0);
        LegacyLootTablesConfig.Level config = ModConfigs.LOOT_TABLES.getForLevel(level);
        return null;
    }

    @Override
    public Component getObjectiveDisplayName() {
        return new TextComponent("Kill all Bosses").m_130940_(ChatFormatting.GOLD);
    }

    @Override
    public void tick(VaultRaid vault, PlayerFilter filter, ServerLevel world) {
        super.tick(vault, filter, world);
        if (this.isCompleted()) {
            return;
        }
        vault.getPlayers().stream().filter(vPlayer -> filter.test(vPlayer.getPlayerId())).forEach(vPlayer -> vPlayer.runIfPresent(world.m_142572_(), playerEntity -> {
            VaultGoalMessage pkt = this.allObelisksClicked() ? VaultGoalMessage.killBossGoal() : VaultGoalMessage.obeliskGoal(this.progressCount, this.targetCount);
            ModNetwork.CHANNEL.sendTo((Object)pkt, playerEntity.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }));
        if (this.allBossesDefeated()) {
            this.setCompleted();
        }
    }

    @Override
    public void complete(VaultRaid vault, VaultPlayer player, ServerLevel world) {
        super.complete(vault, player, world);
        player.sendIfPresent(world.m_142572_(), new BossMusicMessage(false));
        player.sendIfPresent(world.m_142572_(), VaultGoalMessage.clear());
    }

    @Override
    public void complete(VaultRaid vault, ServerLevel world) {
        super.complete(vault, world);
        vault.getPlayers().forEach(player -> {
            player.sendIfPresent(world.m_142572_(), new BossMusicMessage(false));
            player.sendIfPresent(world.m_142572_(), VaultGoalMessage.clear());
        });
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        nbt.m_128405_("ProgressCount", this.progressCount);
        nbt.m_128405_("TargetCount", this.targetCount);
        nbt.m_128405_("BossesCount", this.bossesCount);
        nbt.m_128365_("Bosses", (Tag)this.bosses.serializeNBT());
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        this.progressCount = nbt.m_128451_("ProgressCount");
        this.targetCount = nbt.m_128451_("TargetCount");
        this.bossesCount = nbt.m_128451_("BossesCount");
        this.bosses.deserializeNBT(nbt.m_128437_("Bosses", 9));
    }

    private static /* synthetic */ void lambda$completeBoss$1(ServerLevel world, Component ct, VaultPlayer vPlayer) {
        vPlayer.runIfPresent(world.m_142572_(), sPlayer -> sPlayer.m_6352_(ct, Util.f_137441_));
    }
}

