/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.logic.objective;

import iskallia.vault.block.VaultCrateBlock;
import iskallia.vault.config.LegacyLootTablesConfig;
import iskallia.vault.config.LegacyScavengerHuntConfig;
import iskallia.vault.container.ScavengerChestContainer;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.item.BasicScavengerItem;
import iskallia.vault.network.message.VaultGoalMessage;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.util.PlayerFilter;
import iskallia.vault.world.vault.VaultRaid;
import iskallia.vault.world.vault.logic.objective.VaultObjective;
import iskallia.vault.world.vault.logic.task.VaultTask;
import iskallia.vault.world.vault.player.VaultPlayer;
import iskallia.vault.world.vault.player.VaultRunner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.registries.ForgeRegistries;

public class LegacyScavengerHuntObjective
extends VaultObjective {
    public static final int INVENTORY_SIZE = 45;
    private final ChestWatcher chestWatcher = new ChestWatcher();
    private final Inventory inventoryMirror = new Inventory();
    private final List<ItemSubmission> submissions = new ArrayList<ItemSubmission>();
    private int requiredSubmissions;
    private NonNullList<ItemStack> chestInventory = NonNullList.m_122780_((int)45, (Object)ItemStack.f_41583_);

    public LegacyScavengerHuntObjective(ResourceLocation id) {
        this(id, ModConfigs.LEGACY_SCAVENGER_HUNT.getTotalRequiredItems());
    }

    private LegacyScavengerHuntObjective(ResourceLocation id, int requiredSubmissions) {
        super(id, VaultTask.EMPTY, VaultTask.EMPTY);
        this.requiredSubmissions = requiredSubmissions;
    }

    public Container getScavengerChestInventory() {
        return this.inventoryMirror;
    }

    public ChestWatcher getChestWatcher() {
        return this.chestWatcher;
    }

    private Stream<ItemSubmission> getActiveSubmissionsFilter() {
        return this.getAllSubmissions().stream().filter(submission -> !submission.isFinished());
    }

    public List<ItemSubmission> getActiveSubmissions() {
        return this.getActiveSubmissionsFilter().collect(Collectors.toList());
    }

    public List<ItemSubmission> getAllSubmissions() {
        return Collections.unmodifiableList(this.submissions);
    }

    public Predicate<LegacyScavengerHuntConfig.ItemEntry> getGenerationDropFilter() {
        List<ItemSubmission> submissions = this.getActiveSubmissions();
        return entry -> {
            Item generatedItem = entry.getItem();
            for (ItemSubmission submission : submissions) {
                if (!generatedItem.equals(submission.getRequiredItem())) continue;
                return true;
            }
            return false;
        };
    }

    public boolean trySubmitItem(UUID vaultIdentifier, ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        if (!vaultIdentifier.equals(BasicScavengerItem.getVaultIdentifier(stack))) {
            return false;
        }
        Item providedItem = stack.m_41720_();
        boolean addedItem = this.getActiveSubmissionsFilter().filter(submission -> providedItem.equals(submission.requiredItem)).findFirst().map(submission -> {
            int add = Math.min(stack.m_41613_(), submission.requiredAmount - submission.currentAmount);
            submission.currentAmount += add;
            stack.m_41774_(add);
            return true;
        }).orElse(false);
        if (this.getAllSubmissions().stream().filter(ItemSubmission::isFinished).count() >= (long)this.requiredSubmissions) {
            this.setCompleted();
        }
        return addedItem;
    }

    @Override
    public void setObjectiveTargetCount(int amount) {
        this.requiredSubmissions = amount;
    }

    @Override
    @Nullable
    public Component getObjectiveTargetDescription(int amount) {
        return new TextComponent("Total required Item Types: ").m_7220_((Component)new TextComponent(String.valueOf(amount)).m_130940_(ChatFormatting.GREEN));
    }

    @Override
    @Nonnull
    public BlockState getObjectiveRelevantBlock(VaultRaid vault, ServerLevel world, BlockPos pos) {
        return ModBlocks.SCAVENGER_CHEST.m_49966_();
    }

    @Override
    @Nullable
    public LootTable getRewardLootTable(VaultRaid vault, Function<ResourceLocation, LootTable> tblResolver) {
        int level = vault.getProperties().getBase(VaultRaid.LEVEL).orElse(0);
        LegacyLootTablesConfig.Level config = ModConfigs.LOOT_TABLES.getForLevel(level);
        return config != null ? tblResolver.apply(config.getScavengerCrate()) : LootTable.f_79105_;
    }

    @Override
    public Component getObjectiveDisplayName() {
        return new TextComponent("Scavenger Hunt").m_130940_(ChatFormatting.GREEN);
    }

    @Override
    public Component getVaultName() {
        return new TextComponent("Scavenger Vault");
    }

    @Override
    public void tick(VaultRaid vault, PlayerFilter filter, ServerLevel world) {
        ItemSubmission newEntry;
        super.tick(vault, filter, world);
        MinecraftServer srv = world.m_142572_();
        vault.getPlayers().stream().filter(vPlayer -> filter.test(vPlayer.getPlayerId())).forEach(vPlayer -> vPlayer.runIfPresent(srv, playerEntity -> {
            VaultGoalMessage pkt = VaultGoalMessage.scavengerHunt(this.getActiveSubmissions());
            ModNetwork.CHANNEL.sendTo((Object)pkt, playerEntity.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }));
        if (this.isCompleted()) {
            return;
        }
        long activeSubmissions = this.getActiveSubmissionsFilter().count();
        if (world.m_46467_() % 20L == 0L) {
            boolean addedAnyItem = vault.getProperties().getBase(VaultRaid.IDENTIFIER).map(identifier -> {
                boolean addedItem = false;
                NonNullList<ItemStack> inventory = this.chestInventory;
                for (int slot = 0; slot < inventory.size(); ++slot) {
                    ItemStack stack = (ItemStack)inventory.get(slot);
                    if (stack.m_41619_() || !this.trySubmitItem((UUID)identifier, stack)) continue;
                    this.chestInventory.set(slot, (Object)stack);
                    this.updateOpenContainers(srv, vault, slot, stack);
                    addedItem = true;
                }
                return addedItem;
            }).orElse(false);
            if (activeSubmissions > this.getActiveSubmissionsFilter().count()) {
                vault.getPlayers().forEach(vPlayer -> vPlayer.runIfPresent(srv, sPlayer -> world.m_5594_(null, sPlayer.m_142538_(), SoundEvents.f_12275_, SoundSource.BLOCKS, 1.0f, 1.0f)));
            } else if (addedAnyItem) {
                vault.getPlayers().forEach(vPlayer -> vPlayer.runIfPresent(srv, sPlayer -> world.m_5594_(null, sPlayer.m_142538_(), SoundEvents.f_12210_, SoundSource.PLAYERS, 1.1f, 1.4f)));
            }
        }
        if (this.isCompleted()) {
            this.spawnRewards(world, vault);
        }
        if (this.getAllSubmissions().size() < this.requiredSubmissions && (newEntry = this.getNewEntry(vault)) != null) {
            this.submissions.add(newEntry);
        }
    }

    private void updateOpenContainers(MinecraftServer srv, VaultRaid vault, int slot, ItemStack stack) {
        vault.getPlayers().forEach(vPlayer -> vPlayer.runIfPresent(srv, sPlayer -> {
            if (sPlayer.f_36096_ instanceof ScavengerChestContainer) {
                sPlayer.f_36096_.m_182406_(slot, 0, stack);
                sPlayer.f_8906_.m_141995_((Packet)new ClientboundContainerSetSlotPacket(sPlayer.f_36096_.f_38840_, 0, slot, stack));
            }
        }));
    }

    @Override
    public void complete(VaultRaid vault, VaultPlayer player, ServerLevel world) {
        super.complete(vault, player, world);
        player.sendIfPresent(world.m_142572_(), VaultGoalMessage.clear());
    }

    @Override
    public void complete(VaultRaid vault, ServerLevel world) {
        super.complete(vault, world);
        vault.getPlayers().forEach(player -> player.sendIfPresent(world.m_142572_(), VaultGoalMessage.clear()));
    }

    public void spawnRewards(ServerLevel world, VaultRaid vault) {
        VaultPlayer rewardPlayer = vault.getProperties().getBase(VaultRaid.HOST).flatMap(vault::getPlayer).filter(vPlayer -> vPlayer instanceof VaultRunner).orElseGet(() -> vault.getPlayers().stream().filter(vPlayer -> vPlayer instanceof VaultRunner).findAny().orElse(null));
        if (rewardPlayer == null) {
            return;
        }
        rewardPlayer.runIfPresent(world.m_142572_(), sPlayer -> {
            BlockPos pos = sPlayer.m_142538_();
            LootContext.Builder builder = new LootContext.Builder(world).m_78977_(world.f_46441_).m_78972_(LootContextParams.f_81455_, sPlayer).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_78963_(sPlayer.m_36336_());
            LootContext ctx = builder.m_78975_(LootContextParamSets.f_81411_);
            this.dropRewardCrate(world, vault, pos, ctx);
            for (int i = 1; i < vault.getPlayers().size(); ++i) {
                if (!(rand.nextFloat() < 0.5f)) continue;
                this.dropRewardCrate(world, vault, pos, ctx);
            }
            MutableComponent msgContainer = new TextComponent("").m_130940_(ChatFormatting.WHITE);
            MutableComponent playerName = sPlayer.m_5446_().m_6881_();
            playerName.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)9974168)));
            MiscUtils.broadcast((Component)msgContainer.m_7220_((Component)playerName).m_130946_(" finished a Scavenger Hunt!"));
        });
    }

    private void dropRewardCrate(ServerLevel world, VaultRaid vault, BlockPos pos, LootContext context) {
        NonNullList<ItemStack> stacks = this.createLoot(world, vault, context);
        ItemStack crate = VaultCrateBlock.getCrateWithLoot(VaultCrateBlock.Type.SCAVENGER, stacks);
        ItemEntity item = new ItemEntity((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), crate);
        item.m_32060_();
        world.m_7967_((Entity)item);
        this.crates.add(new VaultObjective.Crate((List<ItemStack>)stacks));
    }

    @Nullable
    private ItemSubmission getNewEntry(VaultRaid vault) {
        List currentItems = this.submissions.stream().map(submission -> submission.requiredItem).collect(Collectors.toList());
        int players = vault.getPlayers().size();
        int level = vault.getProperties().getBase(VaultRaid.LEVEL).orElse(0);
        float multiplier = 1.0f + (float)(players - 1) * 0.5f;
        LegacyScavengerHuntConfig.ItemEntry newEntry = ModConfigs.LEGACY_SCAVENGER_HUNT.getRandomRequiredItem(currentItems::contains);
        if (newEntry == null) {
            return null;
        }
        LegacyScavengerHuntConfig.SourceType sourceType = ModConfigs.LEGACY_SCAVENGER_HUNT.getRequirementSource(newEntry.createItemStack());
        switch (sourceType) {
            case MOB: {
                multiplier *= 1.0f + (float)level / 100.0f;
                break;
            }
            case CHEST: {
                multiplier *= 1.0f + (float)level / 100.0f / 1.5f;
            }
        }
        return ItemSubmission.fromConfigEntry(newEntry, multiplier);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        ListTag list = new ListTag();
        for (ItemSubmission submission : this.submissions) {
            list.add((Object)submission.serialize());
        }
        tag.m_128365_("submissions", (Tag)list);
        tag.m_128405_("requiredSubmissions", this.requiredSubmissions);
        ListTag inventoryList = new ListTag();
        for (int slot = 0; slot < this.chestInventory.size(); ++slot) {
            ItemStack stack = (ItemStack)this.chestInventory.get(slot);
            if (stack.m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("slot", slot);
            itemTag.m_128365_("item", (Tag)stack.serializeNBT());
            inventoryList.add((Object)itemTag);
        }
        tag.m_128365_("inventory", (Tag)inventoryList);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        this.submissions.clear();
        ListTag list = tag.m_128437_("submissions", 10);
        for (int index = 0; index < list.size(); ++index) {
            this.submissions.add(ItemSubmission.deserialize(list.m_128728_(index)));
        }
        this.requiredSubmissions = tag.m_128451_("requiredSubmissions");
        this.chestInventory = NonNullList.m_122780_((int)45, (Object)ItemStack.f_41583_);
        ListTag inventoryList = tag.m_128437_("inventory", 10);
        for (int i = 0; i < inventoryList.size(); ++i) {
            CompoundTag itemTag = inventoryList.m_128728_(i);
            int slot = itemTag.m_128451_("slot");
            ItemStack stack = ItemStack.m_41712_((CompoundTag)itemTag.m_128469_("item"));
            this.chestInventory.set(slot, (Object)stack);
        }
    }

    public class ChestWatcher
    implements ContainerListener {
        public void m_7934_(AbstractContainerMenu container, int slotId, ItemStack stack) {
            if (slotId >= 0 && slotId < 45) {
                LegacyScavengerHuntObjective.this.chestInventory.set(slotId, (Object)stack);
            }
        }

        public void m_142153_(AbstractContainerMenu pContainerMenu, int pDataSlotIndex, int pValue) {
        }
    }

    private class Inventory
    implements Container {
        private Inventory() {
        }

        public int m_6643_() {
            return LegacyScavengerHuntObjective.this.chestInventory.size();
        }

        public boolean m_7983_() {
            return LegacyScavengerHuntObjective.this.chestInventory.isEmpty();
        }

        public ItemStack m_8020_(int index) {
            return (ItemStack)LegacyScavengerHuntObjective.this.chestInventory.get(index);
        }

        public ItemStack m_7407_(int index, int count) {
            return ContainerHelper.m_18969_(LegacyScavengerHuntObjective.this.chestInventory, (int)index, (int)count);
        }

        public ItemStack m_8016_(int index) {
            ItemStack existing = this.m_8020_(index);
            this.m_6836_(index, ItemStack.f_41583_);
            return existing;
        }

        public void m_6836_(int index, ItemStack stack) {
            LegacyScavengerHuntObjective.this.chestInventory.set(index, (Object)stack);
        }

        public void m_6596_() {
        }

        public boolean m_6542_(Player player) {
            return true;
        }

        public void m_6211_() {
            LegacyScavengerHuntObjective.this.chestInventory.clear();
        }
    }

    public static class ItemSubmission {
        private final Item requiredItem;
        private final int requiredAmount;
        private int currentAmount = 0;

        public ItemSubmission(Item requiredItem, int requiredAmount) {
            this.requiredItem = requiredItem;
            this.requiredAmount = requiredAmount;
        }

        private static ItemSubmission fromConfigEntry(LegacyScavengerHuntConfig.ItemEntry entry, float multiplyAmount) {
            return new ItemSubmission(entry.getItem(), Mth.m_14167_((float)((float)entry.getRandomAmount() * multiplyAmount)));
        }

        public boolean isFinished() {
            return this.currentAmount >= this.requiredAmount;
        }

        public Item getRequiredItem() {
            return this.requiredItem;
        }

        public int getRequiredAmount() {
            return this.requiredAmount;
        }

        public int getCurrentAmount() {
            return this.currentAmount;
        }

        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("item", this.requiredItem.getRegistryName().toString());
            tag.m_128405_("required", this.requiredAmount);
            tag.m_128405_("current", this.currentAmount);
            return tag;
        }

        public static ItemSubmission deserialize(CompoundTag tag) {
            Item requiredItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(tag.m_128461_("item")));
            int requiredAmount = tag.m_128451_("required");
            int currentAmount = tag.m_128451_("current");
            ItemSubmission submitted = new ItemSubmission(requiredItem, requiredAmount);
            submitted.currentAmount = currentAmount;
            return submitted;
        }
    }
}

