/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.logic.objective;

import iskallia.vault.block.VaultCrateBlock;
import iskallia.vault.config.LegacyLootTablesConfig;
import iskallia.vault.config.VaultModifierPoolsConfig;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.VaultGoalMessage;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.util.PlayerFilter;
import iskallia.vault.world.data.DiscoveredModelsData;
import iskallia.vault.world.gen.decorator.BreadcrumbFeature;
import iskallia.vault.world.gen.structure.VaultJigsawHelper;
import iskallia.vault.world.vault.VaultRaid;
import iskallia.vault.world.vault.gen.layout.SingularVaultRoomLayout;
import iskallia.vault.world.vault.gen.layout.SpiralHelper;
import iskallia.vault.world.vault.gen.layout.VaultRoomLayoutGenerator;
import iskallia.vault.world.vault.gen.piece.VaultPiece;
import iskallia.vault.world.vault.gen.piece.VaultRoom;
import iskallia.vault.world.vault.logic.objective.VaultObjective;
import iskallia.vault.world.vault.logic.task.VaultTask;
import iskallia.vault.world.vault.modifier.modifier.ChanceArtifactModifier;
import iskallia.vault.world.vault.modifier.modifier.PlayerInventoryRestoreModifier;
import iskallia.vault.world.vault.modifier.modifier.PlayerNoExitModifier;
import iskallia.vault.world.vault.modifier.modifier.VaultTimeModifier;
import iskallia.vault.world.vault.modifier.spi.VaultModifier;
import iskallia.vault.world.vault.player.VaultPlayer;
import iskallia.vault.world.vault.player.VaultRunner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkDirection;

public class CakeHuntObjective
extends VaultObjective {
    private int maxCakeCount = 22 + rand.nextInt(9);
    private int cakeCount = 0;
    private float modifierChance = 0.75f;
    private VaultModifierPoolsConfig.ModifierPoolType poolType = VaultModifierPoolsConfig.ModifierPoolType.DEFAULT;

    public CakeHuntObjective(ResourceLocation id) {
        super(id, VaultTask.EMPTY, VaultTask.EMPTY);
    }

    public void setModifierChance(float modifierChance) {
        this.modifierChance = modifierChance;
    }

    public void setPoolType(VaultModifierPoolsConfig.ModifierPoolType poolType) {
        this.poolType = poolType;
    }

    public void expandVault(ServerLevel world, BlockPos cakePos, VaultRaid vault) {
        vault.getGenerator().getPiecesAt(cakePos, VaultRoom.class).stream().findAny().ifPresent(room -> vault.getProperties().getBase(VaultRaid.START_FACING).ifPresent(vaultDir -> {
            ++this.cakeCount;
            if (this.cakeCount < this.maxCakeCount) {
                this.addRandomModifier(vault, world);
                Vec3i curr = SpiralHelper.getSpiralPosition(this.cakeCount - 1, vaultDir.m_122427_(), Rotation.COUNTERCLOCKWISE_90);
                Vec3i next = SpiralHelper.getSpiralPosition(this.cakeCount, vaultDir.m_122427_(), Rotation.COUNTERCLOCKWISE_90);
                Direction direction = Direction.m_122372_((float)(next.m_123341_() - curr.m_123341_()), (float)0.0f, (float)(next.m_123343_() - curr.m_123343_()));
                List<VaultPiece> generatedPieces = VaultJigsawHelper.expandVault(vault, world, room, direction);
                generatedPieces.stream().filter(piece -> piece instanceof VaultRoom).findFirst().ifPresent(newRoomPiece -> this.ensureCakeIsPresent(world, (VaultRoom)newRoomPiece));
                BreadcrumbFeature.generateVaultBreadcrumb(vault, world, generatedPieces);
            }
        }));
    }

    private void addRandomModifier(VaultRaid vault, ServerLevel sWorld) {
        if (sWorld.m_5822_().nextFloat() >= this.modifierChance) {
            return;
        }
        int level = vault.getProperties().getValue(VaultRaid.LEVEL);
        Set<VaultModifier<?>> modifiers = ModConfigs.VAULT_MODIFIER_POOLS.getRandom(rand, level, this.poolType, null);
        modifiers.removeIf(mod -> mod instanceof PlayerNoExitModifier);
        modifiers.removeIf(mod -> mod instanceof VaultTimeModifier);
        modifiers.removeIf(mod -> mod instanceof PlayerInventoryRestoreModifier);
        if (sWorld.m_5822_().nextFloat() < 0.65f) {
            modifiers.removeIf(mod -> mod instanceof ChanceArtifactModifier);
        }
        ArrayList modifierList = new ArrayList(modifiers);
        Collections.shuffle(modifierList);
        VaultModifier<?> modifier = MiscUtils.getRandomEntry(modifierList, rand);
        if (modifier != null) {
            MutableComponent ct = new TextComponent("Added ").m_130940_(ChatFormatting.GRAY).m_7220_(modifier.getNameComponent());
            vault.getModifiers().addPermanentModifier(modifier, 1);
            vault.getPlayers().forEach(arg_0 -> CakeHuntObjective.lambda$addRandomModifier$9(sWorld, (Component)ct, arg_0));
        }
    }

    private void spawnRewards(ServerLevel world, VaultRaid vault) {
        VaultPlayer rewardPlayer = vault.getProperties().getBase(VaultRaid.HOST).flatMap(vault::getPlayer).filter(vPlayer -> vPlayer instanceof VaultRunner).orElseGet(() -> vault.getPlayers().stream().filter(vPlayer -> vPlayer instanceof VaultRunner).findAny().orElse(null));
        if (rewardPlayer == null) {
            return;
        }
        rewardPlayer.runIfPresent(world.m_142572_(), sPlayer -> {
            BlockPos pos = sPlayer.m_142538_();
            LootContext.Builder builder = new LootContext.Builder(world).m_78977_(world.f_46441_).m_78972_(LootContextParams.f_81455_, sPlayer).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_78963_(sPlayer.m_36336_());
            LootContext ctx = builder.m_78975_(LootContextParamSets.f_81411_);
            this.dropRewardCrate(world, vault, pos, ctx);
            for (int i = 1; i < vault.getPlayers().size(); ++i) {
                if (!(rand.nextFloat() < 0.5f)) continue;
                this.dropRewardCrate(world, vault, pos, ctx);
            }
            MutableComponent msgContainer = new TextComponent("").m_130940_(ChatFormatting.WHITE);
            MutableComponent playerName = sPlayer.m_5446_().m_6881_();
            playerName.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)9974168)));
            MiscUtils.broadcast((Component)msgContainer.m_7220_((Component)playerName).m_130946_(" finished a Cake Hunt!"));
        });
    }

    private void dropRewardCrate(ServerLevel world, VaultRaid vault, BlockPos pos, LootContext context) {
        NonNullList<ItemStack> stacks = this.createLoot(world, vault, context);
        ItemStack crate = VaultCrateBlock.getCrateWithLoot(VaultCrateBlock.Type.CAKE, stacks);
        ItemEntity item = new ItemEntity((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), crate);
        item.m_32060_();
        world.m_7967_((Entity)item);
        this.crates.add(new VaultObjective.Crate((List<ItemStack>)stacks));
    }

    @Override
    protected void addSpecialLoot(ServerLevel world, VaultRaid vault, LootContext context, NonNullList<ItemStack> stacks) {
        super.addSpecialLoot(world, vault, context, stacks);
        int amt = Math.max(rand.nextInt(this.maxCakeCount), rand.nextInt(this.maxCakeCount));
        for (int i = 0; i < amt; ++i) {
            stacks.add((Object)new ItemStack((ItemLike)Items.f_42502_));
        }
    }

    @Override
    public void tick(VaultRaid vault, PlayerFilter filter, ServerLevel world) {
        super.tick(vault, filter, world);
        MinecraftServer srv = world.m_142572_();
        vault.getPlayers().stream().filter(vPlayer -> filter.test(vPlayer.getPlayerId())).forEach(vPlayer -> vPlayer.runIfPresent(srv, playerEntity -> {
            VaultGoalMessage pkt = VaultGoalMessage.cakeHunt(this.maxCakeCount, this.cakeCount);
            ModNetwork.CHANNEL.sendTo((Object)pkt, playerEntity.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }));
        vault.getGenerator().getPieces(VaultRoom.class).forEach(room -> this.ensureCakeIsPresent(world, (VaultRoom)room));
        if (this.cakeCount >= this.maxCakeCount) {
            this.setCompleted();
            this.spawnRewards(world, vault);
            DiscoveredModelsData discoveredModelsData = DiscoveredModelsData.get(world);
            vault.getPlayers().forEach(vPlayer -> vPlayer.runIfPresent(srv, serverPlayer -> discoveredModelsData.discoverRandomArmorPieceAndBroadcast((Player)serverPlayer, ModDynamicModels.Armor.CAKE, world.m_5822_())));
        } else if (world.m_46467_() % 300L == 0L) {
            vault.getPlayers().stream().filter(vPlayer -> filter.test(vPlayer.getPlayerId())).forEach(vPlayer -> vPlayer.runIfPresent(srv, playerEntity -> vault.getGenerator().getPiecesAt(playerEntity.m_142538_(), VaultRoom.class).stream().findFirst().ifPresent(room -> {
                if (room.isCakeEaten()) {
                    return;
                }
                BlockPos cakePos = room.getCakePos();
                if (cakePos == null) {
                    return;
                }
                int bDst = (int)Mth.m_14116_((float)((float)playerEntity.m_142538_().m_123331_((Vec3i)cakePos)));
                MutableComponent dist = new TextComponent("Distance to cake: " + bDst + "m").m_130940_(ChatFormatting.GRAY);
                playerEntity.m_5661_((Component)dist, true);
            })));
        }
    }

    private void ensureCakeIsPresent(ServerLevel world, VaultRoom room) {
        if (room.isCakeEaten()) {
            return;
        }
        BoundingBox roomBox = room.getBoundingBox();
        if (room.getCakePos() == null) {
            BlockPos at;
            for (int xx = roomBox.m_162395_(); xx <= roomBox.m_162399_(); ++xx) {
                for (int yy = roomBox.m_162396_(); yy <= roomBox.m_162400_(); ++yy) {
                    for (int zz = roomBox.m_162398_(); zz <= roomBox.m_162401_(); ++zz) {
                        BlockPos pos = new BlockPos(xx, yy, zz);
                        BlockState state = world.m_8055_(pos);
                        if (!(state.m_60734_() instanceof CakeBlock)) continue;
                        world.m_7471_(pos, false);
                    }
                }
            }
            while (!(world.m_46859_(at = MiscUtils.getRandomPos(roomBox, rand)) && world.m_8055_(at.m_7495_()).m_60783_((BlockGetter)world, at, Direction.UP) && world.m_46859_(at.m_7494_()))) {
            }
            world.m_7731_(at, Blocks.f_50145_.m_49966_(), 2);
            room.setCakePos(at);
        } else {
            BlockPos at;
            for (int xx = roomBox.m_162395_(); xx <= roomBox.m_162399_(); ++xx) {
                for (int yy = roomBox.m_162396_(); yy <= roomBox.m_162400_(); ++yy) {
                    for (int zz = roomBox.m_162398_(); zz <= roomBox.m_162401_(); ++zz) {
                        BlockPos pos = new BlockPos(xx, yy, zz);
                        BlockState state = world.m_8055_(pos);
                        if (!(state.m_60734_() instanceof CakeBlock)) continue;
                        return;
                    }
                }
            }
            while (!(world.m_46859_(at = MiscUtils.getRandomPos(roomBox, rand)) && world.m_8055_(at.m_7495_()).m_60783_((BlockGetter)world, at, Direction.UP) && world.m_46859_(at.m_7494_()))) {
            }
            world.m_7731_(at, Blocks.f_50145_.m_49966_(), 2);
            room.setCakePos(at);
        }
    }

    @Override
    @Nonnull
    public BlockState getObjectiveRelevantBlock(VaultRaid vault, ServerLevel world, BlockPos pos) {
        return Blocks.f_50016_.m_49966_();
    }

    @Override
    @Nullable
    public LootTable getRewardLootTable(VaultRaid vault, Function<ResourceLocation, LootTable> tblResolver) {
        int level = vault.getProperties().getBase(VaultRaid.LEVEL).orElse(0);
        LegacyLootTablesConfig.Level config = ModConfigs.LOOT_TABLES.getForLevel(level);
        return null;
    }

    @Override
    public Component getObjectiveDisplayName() {
        return new TextComponent("Cake Hunt").m_130940_(ChatFormatting.DARK_PURPLE);
    }

    @Override
    public void setObjectiveTargetCount(int amount) {
        this.maxCakeCount = amount;
    }

    @Override
    @Nullable
    public Component getObjectiveTargetDescription(int amount) {
        return new TextComponent("Cakes needed to be found: ").m_7220_((Component)new TextComponent(String.valueOf(amount)).m_130940_(ChatFormatting.DARK_PURPLE));
    }

    @Override
    @Nullable
    public VaultRoomLayoutGenerator getCustomLayout() {
        return new SingularVaultRoomLayout();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128405_("maxCakeCount", this.maxCakeCount);
        tag.m_128405_("cakeCount", this.cakeCount);
        tag.m_128350_("modifierChance", this.modifierChance);
        tag.m_128405_("poolType", this.poolType.ordinal());
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        this.maxCakeCount = nbt.m_128451_("maxCakeCount");
        this.cakeCount = nbt.m_128451_("cakeCount");
        this.modifierChance = nbt.m_128457_("modifierChance");
        if (nbt.m_128425_("poolType", 3)) {
            this.poolType = VaultModifierPoolsConfig.ModifierPoolType.values()[nbt.m_128451_("poolType")];
        }
    }

    private static /* synthetic */ void lambda$addRandomModifier$9(ServerLevel sWorld, Component ct, VaultPlayer vPlayer) {
        vPlayer.runIfPresent(sWorld.m_142572_(), sPlayer -> sPlayer.m_6352_(ct, Util.f_137441_));
    }
}

