/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.logic.condition;

import iskallia.vault.world.vault.VaultRaid;
import iskallia.vault.world.vault.player.VaultPlayer;
import java.util.Objects;
import net.minecraft.server.level.ServerLevel;

@FunctionalInterface
public interface IVaultCondition {
    public boolean test(VaultRaid var1, VaultPlayer var2, ServerLevel var3);

    default public IVaultCondition negate() {
        return (vault, player, world) -> !this.test(vault, player, world);
    }

    default public IVaultCondition and(IVaultCondition other) {
        Objects.requireNonNull(other);
        return (vault, player, world) -> this.test(vault, player, world) && other.test(vault, player, world);
    }

    default public IVaultCondition or(IVaultCondition other) {
        Objects.requireNonNull(other);
        return (vault, player, world) -> this.test(vault, player, world) || other.test(vault, player, world);
    }

    default public IVaultCondition xor(IVaultCondition other) {
        Objects.requireNonNull(other);
        return (vault, player, world) -> {
            boolean a = this.test(vault, player, world);
            boolean b = other.test(vault, player, world);
            return !a && b || a && !b;
        };
    }
}

