/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.logic;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.JsonAdapter;
import iskallia.vault.entity.LegacyEntityScaler;
import iskallia.vault.entity.entity.AggressiveCowEntity;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.nbt.VListNBT;
import iskallia.vault.nbt.VMapNBT;
import iskallia.vault.util.gson.IgnoreEmpty;
import iskallia.vault.world.vault.VaultRaid;
import iskallia.vault.world.vault.logic.VaultCowOverrides;
import iskallia.vault.world.vault.logic.objective.VaultObjective;
import iskallia.vault.world.vault.logic.task.IVaultTask;
import iskallia.vault.world.vault.player.VaultPlayer;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntUnaryOperator;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.INBTSerializable;

public class VaultSpawner
implements INBTSerializable<CompoundTag>,
IVaultTask {
    private Config config = new Config();
    private Config oldConfig = new Config();
    private VMapNBT<Integer, Config> configHistory = VMapNBT.ofInt(new LinkedHashMap(), Config::new);
    private VListNBT<UUID, StringTag> spawnedMobIds = VListNBT.ofUUID();

    public Config getConfig() {
        return this.config;
    }

    public VaultSpawner configure(Config config) {
        return this.configure(oldConfig -> config);
    }

    public VaultSpawner configure(UnaryOperator<Config> operator) {
        this.oldConfig = this.config.copy();
        this.config = (Config)operator.apply(this.config);
        return this;
    }

    public int getMaxMobs() {
        return this.getConfig().getStartMaxMobs() + this.getConfig().getExtraMaxMobs();
    }

    public VaultSpawner addMaxMobs(int amount) {
        return this.configure(config -> config.withExtraMaxMobs(i -> i + amount));
    }

    @Override
    public void execute(VaultRaid vault, VaultPlayer player, ServerLevel world) {
        if (!this.config.equals(this.oldConfig)) {
            this.configHistory.put(player.getTimer().getRunTime(), this.config.copy());
            this.oldConfig = this.config;
        }
        if (!world.m_46469_().m_46207_(GameRules.f_46134_)) {
            return;
        }
        if (vault.getAllObjectives().stream().anyMatch(VaultObjective::preventsMobSpawning)) {
            return;
        }
        player.runIfPresent(world.m_142572_(), playerEntity -> {
            this.updateMobIds(world, (ServerPlayer)playerEntity);
            if (this.spawnedMobIds.size() > this.getMaxMobs() || this.getConfig().getMaxDistance() <= 0.0) {
                return;
            }
            for (int i = 0; i < 50 && this.spawnedMobIds.size() < this.getMaxMobs(); ++i) {
                this.attemptSpawn(vault, world, player, world.m_5822_());
            }
        });
    }

    protected void updateMobIds(ServerLevel world, ServerPlayer player) {
        this.spawnedMobIds = this.spawnedMobIds.stream().map(arg_0 -> ((ServerLevel)world).m_8791_(arg_0)).filter(Objects::nonNull).filter(entity -> {
            double despawnDistance;
            double distanceSq = entity.m_20280_((Entity)player);
            if (distanceSq > (despawnDistance = this.getConfig().getDespawnDistance()) * despawnDistance) {
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
                return false;
            }
            return true;
        }).map(Entity::m_142081_).collect(Collectors.toCollection(VListNBT::ofUUID));
    }

    protected void attemptSpawn(VaultRaid vault, ServerLevel world, VaultPlayer player, Random random) {
        player.runIfPresent(world.m_142572_(), playerEntity -> {
            double min = this.getConfig().getMinDistance();
            double max = this.getConfig().getMaxDistance();
            double angle = Math.PI * 2 * random.nextDouble();
            double distance = Math.sqrt(random.nextDouble() * (max * max - min * min) + min * min);
            int x = (int)Math.ceil(distance * Math.cos(angle));
            int z = (int)Math.ceil(distance * Math.sin(angle));
            double xzRadius = Math.sqrt(x * x + z * z);
            double yRange = Math.sqrt(max * max - xzRadius * xzRadius);
            int y = random.nextInt((int)Math.ceil(yRange) * 2 + 1) - (int)Math.ceil(yRange);
            BlockPos pos = playerEntity.m_142538_();
            int level = player.getProperties().getBase(VaultRaid.LEVEL).orElse(0);
            LivingEntity spawned = VaultSpawner.spawnMob(vault, world, level, pos.m_123341_() + x, pos.m_123342_() + y, pos.m_123343_() + z, random);
            if (spawned != null) {
                this.spawnedMobIds.add(spawned.m_142081_());
            }
        });
    }

    @Nullable
    public static LivingEntity spawnMob(VaultRaid vault, ServerLevel world, int vaultLevel, int x, int y, int z, Random random) {
        BlockState state;
        AggressiveCowEntity replaced;
        Object entity = VaultSpawner.createMob(world, vaultLevel, random);
        if (vault.getProperties().getBaseOrDefault(VaultRaid.COW_VAULT, false).booleanValue() && (replaced = VaultCowOverrides.replaceVaultEntity(vault, entity, world)) != null) {
            entity = replaced;
        }
        if (!(state = world.m_8055_(new BlockPos(x, y - 1, z))).m_60643_((BlockGetter)world, new BlockPos(x, y - 1, z), entity.m_6095_())) {
            return null;
        }
        AABB entityBox = entity.m_6095_().m_20585_((double)x + 0.5, (double)y, (double)z + 0.5);
        if (!world.m_45772_(entityBox)) {
            return null;
        }
        entity.m_7678_((double)((float)x + 0.5f), (double)((float)y + 0.2f), (double)((float)z + 0.5f), (float)(random.nextDouble() * 2.0 * Math.PI), 0.0f);
        if (entity instanceof Mob) {
            ((Mob)entity).m_21373_();
            ((Mob)entity).m_6518_((ServerLevelAccessor)world, new DifficultyInstance(Difficulty.PEACEFUL, 13000L, 0L, 0.0f), MobSpawnType.STRUCTURE, null, null);
        }
        LegacyEntityScaler.setScaledEquipmentLegacy(entity, vault, vaultLevel, random, LegacyEntityScaler.Type.MOB);
        LegacyEntityScaler.setScaled((Entity)entity);
        world.m_8847_((Entity)entity);
        return entity;
    }

    private static LivingEntity createMob(ServerLevel world, int vaultLevel, Random random) {
        return ModConfigs.VAULT_MOBS.getForLevel((int)vaultLevel).MOB_POOL.getRandom(random).orElseThrow().create((Level)world);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Config", (Tag)this.getConfig().serializeNBT());
        nbt.m_128365_("ConfigHistory", (Tag)this.configHistory.serializeNBT());
        nbt.m_128365_("SpawnedMobsIds", (Tag)this.spawnedMobIds.serializeNBT());
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.config.deserializeNBT(nbt.m_128469_("Config"));
        this.configHistory.deserializeNBT(nbt.m_128437_("ConfigHistory", 10));
        this.spawnedMobIds.deserializeNBT(nbt.m_128437_("SpawnedMobsIds", 8));
    }

    public static VaultSpawner fromNBT(CompoundTag nbt) {
        VaultSpawner spawner = new VaultSpawner();
        spawner.deserializeNBT(nbt);
        return spawner;
    }

    public static class Config
    implements INBTSerializable<CompoundTag> {
        @Expose
        @JsonAdapter(value=IgnoreEmpty.IntegerAdapter.class)
        private int startMaxMobs;
        @Expose
        @JsonAdapter(value=IgnoreEmpty.IntegerAdapter.class)
        private int extraMaxMobs;
        @Expose
        @JsonAdapter(value=IgnoreEmpty.DoubleAdapter.class)
        private double minDistance;
        @Expose
        @JsonAdapter(value=IgnoreEmpty.DoubleAdapter.class)
        private double maxDistance;
        @Expose
        @JsonAdapter(value=IgnoreEmpty.DoubleAdapter.class)
        private double despawnDistance;

        public Config() {
        }

        public Config(int startMaxMobs, int extraMaxMobs, double minDistance, double maxDistance, double despawnDistance) {
            this.startMaxMobs = startMaxMobs;
            this.extraMaxMobs = extraMaxMobs;
            this.minDistance = minDistance;
            this.maxDistance = maxDistance;
            this.despawnDistance = despawnDistance;
        }

        public int getStartMaxMobs() {
            return this.startMaxMobs;
        }

        public int getExtraMaxMobs() {
            return this.extraMaxMobs;
        }

        public double getMinDistance() {
            return this.minDistance;
        }

        public double getMaxDistance() {
            return this.maxDistance;
        }

        public double getDespawnDistance() {
            return this.despawnDistance;
        }

        public Config withStartMaxMobs(int startMaxMobs) {
            return new Config(startMaxMobs, this.extraMaxMobs, this.minDistance, this.maxDistance, this.despawnDistance);
        }

        public Config withExtraMaxMobs(int extraMaxMobs) {
            return new Config(this.startMaxMobs, extraMaxMobs, this.minDistance, this.maxDistance, this.despawnDistance);
        }

        public Config withMinDistance(double minDistance) {
            return new Config(this.startMaxMobs, this.extraMaxMobs, minDistance, this.maxDistance, this.despawnDistance);
        }

        public Config withMaxDistance(double maxDistance) {
            return new Config(this.startMaxMobs, this.extraMaxMobs, this.minDistance, maxDistance, this.despawnDistance);
        }

        public Config withDespawnDistance(double despawnDistance) {
            return new Config(this.startMaxMobs, this.extraMaxMobs, this.minDistance, this.maxDistance, despawnDistance);
        }

        public Config withStartMaxMobs(IntUnaryOperator operator) {
            return new Config(operator.applyAsInt(this.startMaxMobs), this.extraMaxMobs, this.minDistance, this.maxDistance, this.despawnDistance);
        }

        public Config withExtraMaxMobs(IntUnaryOperator operator) {
            return new Config(this.startMaxMobs, operator.applyAsInt(this.extraMaxMobs), this.minDistance, this.maxDistance, this.despawnDistance);
        }

        public Config withMinDistance(DoubleUnaryOperator operator) {
            return new Config(this.startMaxMobs, this.extraMaxMobs, operator.applyAsDouble(this.minDistance), this.maxDistance, this.despawnDistance);
        }

        public Config withMaxDistance(DoubleUnaryOperator operator) {
            return new Config(this.startMaxMobs, this.extraMaxMobs, this.minDistance, operator.applyAsDouble(this.maxDistance), this.despawnDistance);
        }

        public Config withDespawnDistance(DoubleUnaryOperator operator) {
            return new Config(this.startMaxMobs, this.extraMaxMobs, this.minDistance, this.maxDistance, operator.applyAsDouble(this.despawnDistance));
        }

        public Config copy() {
            return new Config(this.startMaxMobs, this.extraMaxMobs, this.minDistance, this.maxDistance, this.despawnDistance);
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_("StartMaxMobs", this.startMaxMobs);
            nbt.m_128405_("ExtraMaxMobs", this.extraMaxMobs);
            nbt.m_128347_("MinDistance", this.minDistance);
            nbt.m_128347_("MaxDistance", this.maxDistance);
            nbt.m_128347_("DespawnDistance", this.despawnDistance);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.startMaxMobs = nbt.m_128451_("StartMaxMobs");
            this.extraMaxMobs = nbt.m_128451_("ExtraMaxMobs");
            this.minDistance = nbt.m_128459_("MinDistance");
            this.maxDistance = nbt.m_128459_("MaxDistance");
            this.despawnDistance = nbt.m_128459_("DespawnDistance");
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Config)) {
                return false;
            }
            Config config = (Config)other;
            return this.getStartMaxMobs() == config.getStartMaxMobs() && this.getExtraMaxMobs() == config.getExtraMaxMobs() && this.getMinDistance() == config.getMinDistance() && this.getMaxDistance() == config.getMaxDistance() && this.getDespawnDistance() == config.getDespawnDistance();
        }

        public int hashCode() {
            return Objects.hash(this.getStartMaxMobs(), this.getExtraMaxMobs(), this.getMinDistance(), this.getMaxDistance(), this.getDespawnDistance());
        }

        public static Config fromNBT(CompoundTag nbt) {
            Config config = new Config();
            config.deserializeNBT(nbt);
            return config;
        }
    }
}

