/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.logic;

import iskallia.vault.entity.entity.VaultSandEntity;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.SandEventContributorMessage;
import iskallia.vault.network.message.SandEventUpdateMessage;
import iskallia.vault.world.vault.VaultRaid;
import iskallia.vault.world.vault.logic.task.IVaultTask;
import iskallia.vault.world.vault.player.VaultPlayer;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.network.NetworkDirection;

public class VaultSandEvent
implements INBTSerializable<CompoundTag>,
IVaultTask {
    private static final Random rand = new Random();
    private final Map<UUID, SandProgress> playerProgress = new HashMap<UUID, SandProgress>();

    @Override
    public void execute(VaultRaid vault, VaultPlayer player, ServerLevel world) {
        if (world.m_46467_() % 10L == 0L) {
            player.runIfPresent(world.m_142572_(), this::sendUpdate);
        }
    }

    public void addSand(ServerPlayer player, String contributor, ChatFormatting contributorColor, int amount, Supplier<Boolean> onSandFilled) {
        SandProgress progress = this.playerProgress.computeIfAbsent(player.m_142081_(), uuid -> new SandProgress());
        int requiredTotal = ModConfigs.SAND_EVENT.getRedemptionsRequiredPerSand((Player)player);
        int current = (int)((float)requiredTotal * progress.fillPercent);
        int newAmount = current + amount;
        if (newAmount > requiredTotal) {
            if (onSandFilled.get().booleanValue()) {
                progress.fillPercent = 0.0f;
                ++progress.spawnedSands;
                player.m_183503_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 0.6f, 1.0f);
            }
        } else {
            progress.fillPercent = Math.min((float)newAmount / (float)requiredTotal, 1.0f);
        }
        this.sendUpdate(player, progress);
        MutableComponent display = new TextComponent(contributor).m_130940_(contributorColor);
        ModNetwork.CHANNEL.sendTo((Object)new SandEventContributorMessage((Component)display), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public void pickupSand(ServerPlayer player) {
        SandProgress progress = this.playerProgress.computeIfAbsent(player.m_142081_(), uuid -> new SandProgress());
        ++progress.collectedSands;
        this.sendUpdate(player, progress);
    }

    private void sendUpdate(ServerPlayer sPlayer) {
        SandProgress progress = this.playerProgress.computeIfAbsent(sPlayer.m_142081_(), uuid -> new SandProgress());
        this.sendUpdate(sPlayer, progress);
    }

    private void sendUpdate(ServerPlayer sPlayer, SandProgress progress) {
        ModNetwork.CHANNEL.sendTo((Object)progress.makeUpdatePacket(), sPlayer.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static boolean spawnSand(ServerLevel world, ServerPlayer player) {
        float min = ModConfigs.SAND_EVENT.getMinDistance();
        float max = ModConfigs.SAND_EVENT.getMaxDistance();
        BlockPos offset = player.m_142538_();
        for (int attempts = 100000; attempts > 0; --attempts) {
            BlockState state;
            int z;
            int y;
            int x = Math.round(min + rand.nextFloat() * (max - min)) * (rand.nextBoolean() ? 1 : -1);
            BlockPos pos = offset.m_142082_(x, y = Math.round(rand.nextFloat() * 30.0f) * (rand.nextBoolean() ? 1 : -1), z = Math.round(min + rand.nextFloat() * (max - min)) * (rand.nextBoolean() ? 1 : -1));
            if (!world.isAreaLoaded(pos, 1) || !(state = world.m_8055_(pos)).m_60795_()) continue;
            world.m_7967_((Entity)VaultSandEntity.create((Level)world, pos));
            return true;
        }
        return false;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        this.playerProgress.forEach((uuid, progress) -> nbt.m_128365_(uuid.toString(), (Tag)progress.serialize()));
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.playerProgress.clear();
        for (String key : nbt.m_128431_()) {
            UUID playerUUID;
            try {
                playerUUID = UUID.fromString(key);
            }
            catch (IllegalArgumentException exc) {
                continue;
            }
            CompoundTag tag = nbt.m_128469_(key);
            this.playerProgress.put(playerUUID, SandProgress.deserialize(tag));
        }
    }

    private static class SandProgress {
        private float fillPercent = 0.0f;
        private int spawnedSands = 0;
        private int collectedSands = 0;

        private SandProgress() {
        }

        private CompoundTag serialize() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128350_("fillPercent", this.fillPercent);
            nbt.m_128405_("spawnedSands", this.spawnedSands);
            nbt.m_128405_("collectedSands", this.collectedSands);
            return nbt;
        }

        private static SandProgress deserialize(CompoundTag nbt) {
            SandProgress progress = new SandProgress();
            progress.fillPercent = nbt.m_128457_("fillPercent");
            progress.spawnedSands = nbt.m_128451_("spawnedSands");
            progress.collectedSands = nbt.m_128451_("collectedSands");
            return progress;
        }

        private SandEventUpdateMessage makeUpdatePacket() {
            return new SandEventUpdateMessage(this.fillPercent, this.spawnedSands, this.collectedSands);
        }
    }
}

