/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.logic;

import iskallia.vault.config.VaultModifierPoolsConfig;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.world.data.InventorySnapshotData;
import iskallia.vault.world.data.PlayerFavourData;
import iskallia.vault.world.data.VaultRaidData;
import iskallia.vault.world.vault.VaultRaid;
import iskallia.vault.world.vault.gen.piece.VaultPortal;
import iskallia.vault.world.vault.logic.VaultSpawner;
import iskallia.vault.world.vault.logic.behaviour.VaultBehaviour;
import iskallia.vault.world.vault.logic.objective.CakeHuntObjective;
import iskallia.vault.world.vault.logic.task.IVaultTask;
import iskallia.vault.world.vault.player.VaultPlayer;
import iskallia.vault.world.vault.player.VaultRunner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.INBTSerializable;

public class VaultLobby
implements INBTSerializable<CompoundTag>,
IVaultTask {
    protected List<Branch> branches = new ArrayList<Branch>();
    public InventorySnapshotData snapshots = new InventorySnapshotData(){

        @Override
        protected boolean shouldSnapshotItem(Player player, ItemStack stack) {
            return true;
        }

        @Override
        public void createSnapshot(Player player) {
            this.snapshotData.put(player.m_142081_(), new InventorySnapshotData.Builder(player).setStackFilter(this::shouldSnapshotItem).replaceExisting().createSnapshot());
            this.m_77762_();
        }
    };

    public Branch getOrCreate(UUID portal, Supplier<Branch> supplier) {
        Optional<Branch> opt = this.branches.stream().filter(g -> g.portalId.equals(portal)).findFirst();
        if (!opt.isPresent()) {
            Branch branch = supplier.get();
            this.branches.add(branch);
            opt = Optional.of(branch);
        }
        return opt.get();
    }

    public Optional<ServerPlayer> getServerPlayer(MinecraftServer srv, UUID playerId) {
        return Optional.ofNullable(srv.m_6846_().m_11259_(playerId));
    }

    public void runIfPresent(MinecraftServer server, UUID playerId, Consumer<ServerPlayer> action) {
        this.getServerPlayer(server, playerId).ifPresent(action);
    }

    @Override
    public void execute(VaultRaid vault, VaultPlayer player, ServerLevel world) {
        player.runIfPresent(world.m_142572_(), sPlayer -> {
            CrystalData data;
            Collection<VaultPortal> portals;
            if (sPlayer.m_6084_() && this.snapshots.restoreSnapshot((Player)sPlayer)) {
                this.snapshots.removeSnapshot((Player)sPlayer);
            }
            if ((portals = vault.getGenerator().getPiecesAt(sPlayer.m_142538_(), VaultPortal.class)).isEmpty()) {
                return;
            }
            VaultPortal portal = portals.iterator().next();
            if (!this.isInPortal(world, (ServerPlayer)sPlayer)) {
                return;
            }
            String[] split = portal.getTemplate().m_135815_().split(Pattern.quote("_"));
            PlayerFavourData.VaultGodType type = this.fromColor(split[split.length - 1]);
            if (type == null) {
                return;
            }
            Branch branch = this.getOrCreate(portal.getUUID(), () -> new Branch(portal.getUUID(), type));
            if ((branch.vaultId == null || VaultRaidData.get(world).get(branch.vaultId) == null) && (data = this.createCrystalData(branch)) != null) {
                VaultRaid.Builder builder = data.createVault(world, null);
                VaultRaid newVault = VaultRaidData.get(world).startVault(world, builder, v -> {
                    v.getProperties().create(VaultRaid.LEVEL, 1000);
                    v.getProperties().create(VaultRaid.FORCE_ACTIVE, true);
                    v.getProperties().create(VaultRaid.PARENT, vault.getProperties().getValue(VaultRaid.IDENTIFIER));
                    branch.vaultId = v.getProperties().getBase(VaultRaid.IDENTIFIER).orElse(null);
                });
                this.initialize(branch, newVault);
                sPlayer.m_20091_();
            }
            world.m_142572_().m_18707_(() -> {
                if (branch.vaultId == null) {
                    return;
                }
                VaultRaid target = VaultRaidData.get(world).get(branch.vaultId);
                if (target == null) {
                    return;
                }
                if (VaultRaidData.get(world).getActiveFor(player.getPlayerId()) != VaultRaidData.get(world).get(branch.vaultId)) {
                    vault.getPlayers().remove(player);
                    this.snapshots.createSnapshot((Player)sPlayer);
                    this.joinVault(target, (ServerPlayer)sPlayer, world, branch);
                }
            });
        });
    }

    private PlayerFavourData.VaultGodType fromColor(String color) {
        if ("green".equals(color)) {
            return PlayerFavourData.VaultGodType.BENEVOLENT;
        }
        if ("blue".equals(color)) {
            return PlayerFavourData.VaultGodType.OMNISCIENT;
        }
        if ("yellow".equals(color)) {
            return PlayerFavourData.VaultGodType.TIMEKEEPER;
        }
        if ("red".equals(color)) {
            return PlayerFavourData.VaultGodType.MALEVOLENT;
        }
        return null;
    }

    private CrystalData createCrystalData(Branch branch) {
        CrystalData data = new CrystalData();
        data.setCanGenerateTreasureRooms(false);
        data.setCanTriggerInfluences(false);
        if (branch.type == PlayerFavourData.VaultGodType.BENEVOLENT) {
            data.setType(CrystalData.Type.FINAL_VELARA);
        } else if (branch.type == PlayerFavourData.VaultGodType.OMNISCIENT) {
            data.setType(CrystalData.Type.FINAL_TENOS);
        } else if (branch.type == PlayerFavourData.VaultGodType.TIMEKEEPER) {
            data.setType(CrystalData.Type.FINAL_WENDARR);
        } else if (branch.type == PlayerFavourData.VaultGodType.MALEVOLENT) {
            data.setType(CrystalData.Type.FINAL_IDONA);
        } else {
            data = null;
        }
        return data;
    }

    private void initialize(Branch branch, VaultRaid vault) {
        if (branch.type == PlayerFavourData.VaultGodType.BENEVOLENT) {
            vault.getActiveObjective(CakeHuntObjective.class).ifPresent(cakeHunt -> {
                cakeHunt.setModifierChance(1.0f);
                cakeHunt.setPoolType(VaultModifierPoolsConfig.ModifierPoolType.FINAL_VELARA_ADDS);
            });
        }
    }

    private void joinVault(VaultRaid vault, ServerPlayer player, ServerLevel world, Branch branch) {
        VaultRunner runner = new VaultRunner(player.m_142081_());
        if (branch.type == PlayerFavourData.VaultGodType.BENEVOLENT) {
            runner.getBehaviours().add(new VaultBehaviour(VaultRaid.NO_OBJECTIVES_LEFT_GLOBALLY, VaultRaid.EXIT_SAFELY));
            runner.getBehaviours().add(new VaultBehaviour(VaultRaid.NO_TIME_LEFT, VaultRaid.EXIT_DEATH));
            runner.getBehaviours().add(new VaultBehaviour(VaultRaid.IS_RUNNER.and(VaultRaid.IS_DEAD), VaultRaid.EXIT_DEATH_ALL_NO_SAVE));
            runner.getBehaviours().add(new VaultBehaviour(VaultRaid.IS_FINISHED.negate(), VaultRaid.TICK_SPAWNER.then(VaultRaid.TICK_CHEST_PITY)));
            runner.getBehaviours().add(new VaultBehaviour(VaultRaid.AFTER_GRACE_PERIOD.and(VaultRaid.IS_FINISHED.negate()), VaultRaid.TICK_INFLUENCES));
            runner.getBehaviours().add(new VaultBehaviour(VaultRaid.IS_RUNNER, VaultRaid.PAUSE_IN_ARENA.then(VaultRaid.CHECK_BAIL_FINAL)));
            runner.getBehaviours().add(new VaultBehaviour(VaultRaid.NO_ACTIVE_RUNNERS_LEFT, VaultRaid.REMOVE_SCAVENGER_ITEMS.then(VaultRaid.REMOVE_INVENTORY_RESTORE_SNAPSHOTS).then(VaultRaid.EXIT_SAFELY)));
            runner.getProperties().create(VaultRaid.SPAWNER, new VaultSpawner());
            runner.getTimer().start(30000);
        } else if (branch.type == PlayerFavourData.VaultGodType.OMNISCIENT) {
            runner.getBehaviours().add(new VaultBehaviour(VaultRaid.NO_OBJECTIVES_LEFT_GLOBALLY, VaultRaid.EXIT_SAFELY));
            runner.getBehaviours().add(new VaultBehaviour(VaultRaid.NO_TIME_LEFT, VaultRaid.EXIT_DEATH));
            runner.getBehaviours().add(new VaultBehaviour(VaultRaid.IS_RUNNER.and(VaultRaid.IS_DEAD), VaultRaid.EXIT_DEATH_ALL_NO_SAVE));
            runner.getBehaviours().add(new VaultBehaviour(VaultRaid.IS_FINISHED.negate(), VaultRaid.TICK_SPAWNER.then(VaultRaid.TICK_CHEST_PITY)));
            runner.getBehaviours().add(new VaultBehaviour(VaultRaid.AFTER_GRACE_PERIOD.and(VaultRaid.IS_FINISHED.negate()), VaultRaid.TICK_INFLUENCES));
            runner.getBehaviours().add(new VaultBehaviour(VaultRaid.IS_RUNNER, VaultRaid.PAUSE_IN_ARENA.then(VaultRaid.CHECK_BAIL_FINAL)));
            runner.getBehaviours().add(new VaultBehaviour(VaultRaid.NO_ACTIVE_RUNNERS_LEFT, VaultRaid.REMOVE_SCAVENGER_ITEMS.then(VaultRaid.REMOVE_INVENTORY_RESTORE_SNAPSHOTS).then(VaultRaid.EXIT_SAFELY)));
            runner.getProperties().create(VaultRaid.SPAWNER, new VaultSpawner());
            runner.getTimer().start(30000);
        } else if (branch.type == PlayerFavourData.VaultGodType.TIMEKEEPER) {
            runner.getBehaviours().add(new VaultBehaviour(VaultRaid.NO_OBJECTIVES_LEFT_GLOBALLY, VaultRaid.EXIT_SAFELY));
            runner.getBehaviours().add(new VaultBehaviour(VaultRaid.NO_TIME_LEFT, VaultRaid.EXIT_DEATH));
            runner.getBehaviours().add(new VaultBehaviour(VaultRaid.IS_RUNNER.and(VaultRaid.IS_DEAD), VaultRaid.EXIT_DEATH_ALL_NO_SAVE));
            runner.getBehaviours().add(new VaultBehaviour(VaultRaid.IS_FINISHED.negate(), VaultRaid.TICK_SPAWNER.then(VaultRaid.TICK_CHEST_PITY)));
            runner.getBehaviours().add(new VaultBehaviour(VaultRaid.AFTER_GRACE_PERIOD.and(VaultRaid.IS_FINISHED.negate()), VaultRaid.TICK_INFLUENCES));
            runner.getBehaviours().add(new VaultBehaviour(VaultRaid.IS_RUNNER, VaultRaid.PAUSE_IN_ARENA.then(VaultRaid.CHECK_BAIL_FINAL)));
            runner.getBehaviours().add(new VaultBehaviour(VaultRaid.NO_ACTIVE_RUNNERS_LEFT, VaultRaid.REMOVE_SCAVENGER_ITEMS.then(VaultRaid.REMOVE_INVENTORY_RESTORE_SNAPSHOTS).then(VaultRaid.EXIT_SAFELY)));
            runner.getProperties().create(VaultRaid.SPAWNER, new VaultSpawner());
            runner.getTimer().start(ModConfigs.TREASURE_HUNT.startTicks);
        } else if (branch.type == PlayerFavourData.VaultGodType.MALEVOLENT) {
            runner.getBehaviours().add(new VaultBehaviour(VaultRaid.NO_OBJECTIVES_LEFT_GLOBALLY, VaultRaid.EXIT_SAFELY));
            runner.getBehaviours().add(new VaultBehaviour(VaultRaid.IS_RUNNER.and(VaultRaid.IS_DEAD), VaultRaid.EXIT_DEATH_ALL_NO_SAVE));
            runner.getBehaviours().add(new VaultBehaviour(VaultRaid.IS_FINISHED.negate(), VaultRaid.TICK_SPAWNER.then(VaultRaid.TICK_CHEST_PITY)));
            runner.getBehaviours().add(new VaultBehaviour(VaultRaid.AFTER_GRACE_PERIOD.and(VaultRaid.IS_FINISHED.negate()), VaultRaid.TICK_INFLUENCES));
            runner.getBehaviours().add(new VaultBehaviour(VaultRaid.IS_RUNNER, VaultRaid.PAUSE_IN_ARENA.then(VaultRaid.CHECK_BAIL_FINAL)));
            runner.getBehaviours().add(new VaultBehaviour(VaultRaid.NO_ACTIVE_RUNNERS_LEFT, VaultRaid.REMOVE_SCAVENGER_ITEMS.then(VaultRaid.REMOVE_INVENTORY_RESTORE_SNAPSHOTS).then(VaultRaid.EXIT_SAFELY)));
            runner.getProperties().create(VaultRaid.SPAWNER, new VaultSpawner());
            runner.getProperties().create(VaultRaid.SHOW_TIMER, false);
        } else {
            return;
        }
        runner.getProperties().create(VaultRaid.LEVEL, 1000);
        runner.getTimer().runTime = vault.getPlayers().stream().mapToInt(t -> t.getTimer().runTime).max().orElse(0);
        vault.getPlayers().add(runner);
        vault.getInitializer().execute(vault, runner, world);
    }

    public boolean isInPortal(ServerLevel world, ServerPlayer player) {
        AABB box = player.m_142469_();
        BlockPos min = new BlockPos(box.f_82288_ + 0.001, box.f_82289_ + 0.001, box.f_82290_ + 0.001);
        BlockPos max = new BlockPos(box.f_82291_ - 0.001, box.f_82292_ - 0.001, box.f_82293_ - 0.001);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        if (!world.m_46832_(min, max)) {
            return false;
        }
        if (player.m_20092_()) {
            player.m_20091_();
            return false;
        }
        for (int xx = min.m_123341_(); xx <= max.m_123341_(); ++xx) {
            for (int yy = min.m_123342_(); yy <= max.m_123342_(); ++yy) {
                for (int zz = min.m_123343_(); zz <= max.m_123343_(); ++zz) {
                    BlockState state = world.m_8055_((BlockPos)pos.m_122178_(xx, yy, zz));
                    if (state.m_60734_() != ModBlocks.VAULT_PORTAL) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        ListTag branchList = new ListTag();
        this.branches.stream().map(Branch::serializeNBT).forEach(arg_0 -> branchList.add(arg_0));
        nbt.m_128365_("Branches", (Tag)branchList);
        nbt.m_128365_("Snapshots", (Tag)this.snapshots.m_7176_(new CompoundTag()));
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.branches.clear();
        ListTag branchList = nbt.m_128437_("Branches", 10);
        for (int i = 0; i < branchList.size(); ++i) {
            Branch branch = new Branch();
            branch.deserializeNBT(branchList.m_128728_(i));
            this.branches.add(branch);
        }
        this.snapshots.load(nbt.m_128469_("Snapshots"));
    }

    public static class Branch
    implements INBTSerializable<CompoundTag> {
        protected UUID portalId;
        protected UUID vaultId;
        protected PlayerFavourData.VaultGodType type;

        private Branch() {
        }

        public Branch(UUID portalId, PlayerFavourData.VaultGodType type) {
            this.portalId = portalId;
            this.type = type;
        }

        public UUID getPortalId() {
            return this.portalId;
        }

        public UUID getVaultId() {
            return this.vaultId;
        }

        public PlayerFavourData.VaultGodType getType() {
            return this.type;
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("Portal", this.portalId.toString());
            if (this.vaultId != null) {
                nbt.m_128359_("Vault", this.vaultId.toString());
            }
            nbt.m_128359_("Type", this.type.getName());
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.portalId = UUID.fromString(nbt.m_128461_("Portal"));
            this.vaultId = !nbt.m_128425_("Vault", 8) ? null : UUID.fromString(nbt.m_128461_("Vault"));
            this.type = PlayerFavourData.VaultGodType.fromName(nbt.m_128461_("Type"));
        }
    }
}

