/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.logic;

import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.world.data.PlayerFavourData;
import iskallia.vault.world.vault.VaultRaid;
import iskallia.vault.world.vault.influence.DamageInfluence;
import iskallia.vault.world.vault.influence.EffectInfluence;
import iskallia.vault.world.vault.influence.MobAttributeInfluence;
import iskallia.vault.world.vault.influence.MobsInfluence;
import iskallia.vault.world.vault.influence.TimeInfluence;
import iskallia.vault.world.vault.influence.VaultAttributeInfluence;
import iskallia.vault.world.vault.influence.VaultInfluence;
import iskallia.vault.world.vault.influence.VaultInfluences;
import iskallia.vault.world.vault.logic.objective.VaultObjective;
import iskallia.vault.world.vault.player.VaultPlayer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class VaultInfluenceHandler {
    private static final float influenceChance = 0.66f;
    private static final UUID BENEVOLENT_HP_REDUCTION = UUID.fromString("bb3be804-44c2-474a-af69-b300f5d01bc7");
    private static final UUID OMNISCIENT_SPEED_REDUCTION = UUID.fromString("3d0402b6-4edc-49fc-ada6-23700a9737ac");
    private static final UUID MALEVOLENCE_DAMAGE_REDUCTION = UUID.fromString("5d54dcbf-cb04-4716-85b7-e262080049c0");
    private static final UUID BENEVOLENT_HP_INCREASE = UUID.fromString("9093f3ee-64d8-4d64-b410-7052872f4b94");
    private static final UUID OMNISCIENT_ARMOR_INCREASE = UUID.fromString("15f0faaa-c014-4063-a3e5-ae801a95e721");
    private static final UUID MALEVOLENCE_DAMAGE_INCREASE = UUID.fromString("0011379d-97e7-44b1-860e-9d355746e886");
    private static final Random rand = new Random();
    private static final Map<PlayerFavourData.VaultGodType, InfluenceMessages> messages = new HashMap<PlayerFavourData.VaultGodType, InfluenceMessages>();

    public static void initializeInfluences(VaultRaid vault, ServerLevel world) {
        int vaultLvl = vault.getProperties().getBase(VaultRaid.LEVEL).orElse(0);
        if (vaultLvl < 50) {
            return;
        }
        CrystalData data = vault.getProperties().getBase(VaultRaid.CRYSTAL_DATA).orElse(null);
        if (data == null || !data.canTriggerInfluences() || !data.getType().canTriggerInfluences() || vault.getPlayers().size() > 1) {
            return;
        }
        if (vault.getAllObjectives().stream().anyMatch(VaultObjective::preventsInfluences)) {
            return;
        }
        VaultInfluences influences = vault.getInfluences();
        PlayerFavourData favourData = PlayerFavourData.get(world);
        HashMap<PlayerFavourData.VaultGodType, Integer> positives = new HashMap<PlayerFavourData.VaultGodType, Integer>();
        HashMap<PlayerFavourData.VaultGodType, Integer> negatives = new HashMap<PlayerFavourData.VaultGodType, Integer>();
        block0: for (PlayerFavourData.VaultGodType type2 : PlayerFavourData.VaultGodType.values()) {
            for (VaultPlayer vPlayer : vault.getPlayers()) {
                int favour2 = favourData.getFavour(vPlayer.getPlayerId(), type2);
                if (Math.abs(favour2) < 4 || rand.nextFloat() >= 0.66f) continue;
                if (favour2 < 0) {
                    negatives.put(type2, favour2);
                    continue block0;
                }
                positives.put(type2, favour2);
                continue block0;
            }
        }
        positives.forEach((type, favour) -> {
            Tuple<VaultInfluence, String> influenceResult = VaultInfluenceHandler.getPositiveInfluence(type, Math.abs(favour));
            influences.addInfluence((VaultInfluence)influenceResult.m_14418_(), vault, world);
            String message = messages.get(type).getPositiveMessage();
            MutableComponent vgName = new TextComponent(type.getName()).m_130940_(type.getChatColor());
            vgName.m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)type.getHoverChatComponent())));
            TextComponent txt = new TextComponent("");
            txt.m_7220_((Component)new TextComponent("[VG] ").m_130940_(ChatFormatting.DARK_PURPLE)).m_7220_((Component)vgName).m_7220_((Component)new TextComponent(": ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)new TextComponent(message));
            MutableComponent info = new TextComponent((String)influenceResult.m_14419_()).m_130940_(ChatFormatting.DARK_GRAY);
            vault.getPlayers().forEach(arg_0 -> VaultInfluenceHandler.lambda$initializeInfluences$2(world, (MutableComponent)txt, info, arg_0));
        });
        negatives.forEach((type, favour) -> {
            Tuple<VaultInfluence, String> influenceResult = VaultInfluenceHandler.getNegativeInfluence(type, Math.abs(favour));
            influences.addInfluence((VaultInfluence)influenceResult.m_14418_(), vault, world);
            String message = messages.get(type).getNegativeMessage();
            MutableComponent vgName = new TextComponent(type.getName()).m_130940_(type.getChatColor());
            vgName.m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)type.getHoverChatComponent())));
            TextComponent txt = new TextComponent("");
            txt.m_7220_((Component)new TextComponent("[VG] ").m_130940_(ChatFormatting.DARK_PURPLE)).m_7220_((Component)vgName).m_7220_((Component)new TextComponent(": ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)new TextComponent(message));
            MutableComponent info = new TextComponent((String)influenceResult.m_14419_()).m_130940_(ChatFormatting.DARK_GRAY);
            vault.getPlayers().forEach(arg_0 -> VaultInfluenceHandler.lambda$initializeInfluences$6(world, (MutableComponent)txt, info, arg_0));
        });
    }

    private static Tuple<VaultInfluence, String> getPositiveInfluence(PlayerFavourData.VaultGodType type, int favour) {
        DecimalFormat percentFormat = new DecimalFormat("0.##");
        VaultInfluence influence = null;
        String text = null;
        switch (type) {
            case BENEVOLENT: {
                switch (rand.nextInt(2)) {
                    case 1: {
                        int ampl = Mth.m_14045_((int)((favour - 4) / 8 + 1), (int)1, (int)2);
                        influence = new EffectInfluence(MobEffects.f_19605_, ampl);
                        text = "Grants +" + ampl + " Regeneration";
                        break;
                    }
                    case 0: {
                        int heal = 50 + Mth.m_14167_((float)((float)(favour - 4) * 4.166666f));
                        float healPerc = (float)heal / 100.0f;
                        influence = new VaultAttributeInfluence(VaultAttributeInfluence.Type.HEALING_EFFECTIVENESS, 1.0f + healPerc, true);
                        text = "Effectiveness of Healing is increased by " + heal + "%";
                    }
                }
                return new Tuple(influence, text);
            }
            case OMNISCIENT: {
                switch (rand.nextInt(2)) {
                    case 1: {
                        int ampl = Mth.m_14045_((int)(favour / 5), (int)1, (int)3);
                        influence = new EffectInfluence(MobEffects.f_19621_, ampl);
                        text = "Grants +" + ampl + " Luck";
                        break;
                    }
                    case 0: {
                        int increased = 25 + Math.min(Math.round((float)(favour - 4) * 6.25f), 75);
                        influence = new VaultAttributeInfluence(VaultAttributeInfluence.Type.CHEST_RARITY, (float)increased / 100.0f, false);
                        text = "Grants " + increased + "% Chest Rarity";
                    }
                }
                return new Tuple(influence, text);
            }
            case TIMEKEEPER: {
                switch (rand.nextInt(2)) {
                    case 1: {
                        int time = favour / 4;
                        influence = new TimeInfluence(time * 60 * 20);
                        text = "Grants " + time + " additional minutes";
                        break;
                    }
                    case 0: {
                        int cdReduction = 10 + Math.round((float)(favour - 4) * 2.5f);
                        influence = new VaultAttributeInfluence(VaultAttributeInfluence.Type.COOLDOWN_REDUCTION, 1.0f + (float)cdReduction / 100.0f, true);
                        text = "Grants +" + cdReduction + "% Cooldown Reduction";
                    }
                }
                return new Tuple(influence, text);
            }
            case MALEVOLENT: {
                switch (rand.nextInt(2)) {
                    case 1: {
                        int more = 25 + Math.round((float)(favour - 4) * 14.58f);
                        float perc = 1.0f + (float)more / 100.0f;
                        influence = new DamageInfluence(perc);
                        text = "You deal " + more + "% more damage";
                        break;
                    }
                    case 0: {
                        int incDrops = 100 + (favour - 4) * 25;
                        influence = new VaultAttributeInfluence(VaultAttributeInfluence.Type.SOUL_SHARD_DROPS, 1.0f + (float)incDrops / 100.0f, true);
                        text = "Monsters drop " + incDrops + "% more Soul Shards.";
                    }
                }
                return new Tuple(influence, text);
            }
        }
        throw new IllegalArgumentException("Unknown type: " + type.name());
    }

    private static Tuple<VaultInfluence, String> getNegativeInfluence(PlayerFavourData.VaultGodType type, int favour) {
        VaultInfluence influence = null;
        String text = null;
        switch (type) {
            case BENEVOLENT: {
                switch (rand.nextInt(2)) {
                    case 1: {
                        int more = 4 + Math.round((float)(favour - 4) * 0.5f);
                        influence = new MobsInfluence(more);
                        text = more + " additional monsters spawn around you";
                        break;
                    }
                    case 0: {
                        int reduced = 10 + Math.round((float)(favour - 4) * 3.3333f);
                        influence = new VaultAttributeInfluence(VaultAttributeInfluence.Type.HEALING_EFFECTIVENESS, 1.0f - (float)reduced / 100.0f, true);
                        text = "Effectiveness of Healing is reduced by " + reduced + "%";
                    }
                }
                return new Tuple(influence, text);
            }
            case OMNISCIENT: {
                switch (rand.nextInt(2)) {
                    case 1: {
                        int decreased = 25 + Math.min(Math.round((float)(favour - 4) * 6.25f), 75);
                        influence = new VaultAttributeInfluence(VaultAttributeInfluence.Type.CHEST_RARITY, (float)(-decreased) / 100.0f, false);
                        text = "Reduces Chest Rarity by " + decreased + "%";
                        break;
                    }
                    case 0: {
                        int ampl = Mth.m_14045_((int)(favour / 5), (int)1, (int)3);
                        influence = new EffectInfluence(MobEffects.f_19590_, ampl);
                        text = "Applies -" + ampl + " Luck";
                    }
                }
                return new Tuple(influence, text);
            }
            case TIMEKEEPER: {
                switch (rand.nextInt(2)) {
                    case 1: {
                        int time = 1 + (favour - 4) / 6;
                        influence = new TimeInfluence(-time * 60 * 20);
                        text = "Removes " + time + " minutes";
                        break;
                    }
                    case 0: {
                        int more = 10 + Math.round((float)(favour - 4) * 3.333f);
                        float perc = (float)more / 100.0f;
                        influence = new MobAttributeInfluence(Attributes.f_22279_, new AttributeModifier(OMNISCIENT_SPEED_REDUCTION, "Favours", (double)perc, AttributeModifier.Operation.MULTIPLY_TOTAL));
                        text = "Monsters move " + more + "% faster";
                    }
                }
                return new Tuple(influence, text);
            }
            case MALEVOLENT: {
                switch (rand.nextInt(2)) {
                    case 1: {
                        int more = 20 + (favour - 4) * 15;
                        influence = new MobAttributeInfluence(Attributes.f_22276_, new AttributeModifier(BENEVOLENT_HP_REDUCTION, "Favours", (double)((float)more / 100.0f), AttributeModifier.Operation.MULTIPLY_TOTAL));
                        text = "Monsters have " + more + "% more Health";
                        break;
                    }
                    case 0: {
                        int less = 10 + Math.round((float)(favour - 4) * 5.416666f);
                        influence = new DamageInfluence(1.0f - (float)less / 100.0f);
                        text = "You deal " + less + "% less damage";
                    }
                }
                return new Tuple(influence, text);
            }
        }
        throw new IllegalArgumentException("Unknown type: " + type.name());
    }

    private static /* synthetic */ void lambda$initializeInfluences$6(ServerLevel world, MutableComponent txt, MutableComponent info, VaultPlayer vPlayer) {
        vPlayer.runIfPresent(world.m_142572_(), sPlayer -> {
            sPlayer.m_6352_((Component)txt, Util.f_137441_);
            sPlayer.m_6352_((Component)info, Util.f_137441_);
        });
    }

    private static /* synthetic */ void lambda$initializeInfluences$2(ServerLevel world, MutableComponent txt, MutableComponent info, VaultPlayer vPlayer) {
        vPlayer.runIfPresent(world.m_142572_(), sPlayer -> {
            sPlayer.m_6352_((Component)txt, Util.f_137441_);
            sPlayer.m_6352_((Component)info, Util.f_137441_);
        });
    }

    static {
        InfluenceMessages benevolent = new InfluenceMessages();
        benevolent.positiveMessages.add("Our domain's ground will carve a path.");
        benevolent.positiveMessages.add("Tread upon our domain with care and it will respond in kind.");
        benevolent.positiveMessages.add("May your desire blossom into a wildfire.");
        benevolent.positiveMessages.add("Creation bends to our will.");
        benevolent.negativeMessages.add("Nature rises against you.");
        benevolent.negativeMessages.add("Prosperity withers at your touch.");
        benevolent.negativeMessages.add("Defile, rot, decay and fester.");
        benevolent.negativeMessages.add("The flower of your aspirations will waste away.");
        messages.put(PlayerFavourData.VaultGodType.BENEVOLENT, benevolent);
        InfluenceMessages omniscient = new InfluenceMessages();
        omniscient.positiveMessages.add("May foresight guide your step.");
        omniscient.positiveMessages.add("Careful planning and strategy may lead you.");
        omniscient.positiveMessages.add("A set choice; followed through and flawlessly executed.");
        omniscient.positiveMessages.add("Chance's hand may favour your goals.");
        omniscient.negativeMessages.add("A choice; leading one to disfavour.");
        omniscient.negativeMessages.add("Riches, Wealth, Prosperity. An illusion.");
        omniscient.negativeMessages.add("Cascading eventuality. Solidified in ruin.");
        omniscient.negativeMessages.add("Diminishing reality.");
        messages.put(PlayerFavourData.VaultGodType.OMNISCIENT, omniscient);
        InfluenceMessages timekeeper = new InfluenceMessages();
        timekeeper.positiveMessages.add("Seize the opportunity.");
        timekeeper.positiveMessages.add("A single instant, stretched to infinity.");
        timekeeper.positiveMessages.add("Your future glows golden with possibility.");
        timekeeper.positiveMessages.add("Hasten and value every passing moment.");
        timekeeper.negativeMessages.add("Eternity in the moment of standstill.");
        timekeeper.negativeMessages.add("Drown in the flow of time.");
        timekeeper.negativeMessages.add("Transience manifested.");
        timekeeper.negativeMessages.add("Immutable emptiness.");
        messages.put(PlayerFavourData.VaultGodType.TIMEKEEPER, timekeeper);
        InfluenceMessages malevolence = new InfluenceMessages();
        malevolence.positiveMessages.add("Enforce your path through obstacles.");
        malevolence.positiveMessages.add("Our vigor may aid your conquest.");
        malevolence.positiveMessages.add("Cherish this mote of my might.");
        malevolence.positiveMessages.add("A tempest incarnate.");
        malevolence.negativeMessages.add("Feel our domain's wrath.");
        malevolence.negativeMessages.add("Malice and spite given form.");
        malevolence.negativeMessages.add("Flee before the growing horde.");
        malevolence.negativeMessages.add("Perish from your own ambition.");
        messages.put(PlayerFavourData.VaultGodType.MALEVOLENT, malevolence);
    }

    private static class InfluenceMessages {
        private final List<String> positiveMessages = new ArrayList<String>();
        private final List<String> negativeMessages = new ArrayList<String>();

        private InfluenceMessages() {
        }

        private String getNegativeMessage() {
            return this.negativeMessages.get(rand.nextInt(this.negativeMessages.size()));
        }

        private String getPositiveMessage() {
            return this.positiveMessages.get(rand.nextInt(this.positiveMessages.size()));
        }
    }
}

